  CREATE TABLE "AB03B"."AB03B01T00" 
   (	"ID_001" NUMBER(8,0), 
	"DESC_ES_001" VARCHAR2(250 BYTE), 
	"DESC_EU_001" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B01T00"."ID_001" IS 'Secuencia, clave primaria de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B01T00"."DESC_ES_001" IS 'Descripcion en castellano de la Fase';
   COMMENT ON COLUMN "AB03B"."AB03B01T00"."DESC_EU_001" IS 'Descripcion en euskera de la Fase';
   COMMENT ON TABLE "AB03B"."AB03B01T00"  IS 'Tabla de Fases';
  
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B02T00" 
   (	"ID_002" NUMBER(8,0), 
	"ID_001_FASE" NUMBER(8,0), 
	"DESC_ES_002" VARCHAR2(200 BYTE), 
	"DESC_EU_002" VARCHAR2(200 BYTE), 
	"ENT_SAL_002" VARCHAR2(1 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B02T00"."ID_002" IS 'Secuencia PK de la tabla de tramites';
   COMMENT ON COLUMN "AB03B"."AB03B02T00"."ID_001_FASE" IS 'FK a tabla de Fases ';
   COMMENT ON COLUMN "AB03B"."AB03B02T00"."DESC_ES_002" IS 'Descripcin en castellano del Tramite ';
   COMMENT ON COLUMN "AB03B"."AB03B02T00"."DESC_EU_002" IS 'Descripcion en Euskera del Tramite';
   COMMENT ON COLUMN "AB03B"."AB03B02T00"."ENT_SAL_002" IS 'Indica si el trmite es de entrada o salida: E- Entrada; S-Salida';
   COMMENT ON TABLE "AB03B"."AB03B02T00"  IS 'Tabla de trmites';
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B36T00" 
   (	"ID_036" NUMBER(8,0), 
	"ID_002_TRAMITE" NUMBER(8,0), 
	"ID_001_FASE" NUMBER(8,0), 
	"DELEGACION_036" VARCHAR2(2 BYTE), 
	"FLAG_VB_036" VARCHAR2(1 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B36T00"."ID_036" IS 'Secuencia - Clave primaria de tabla AB03B36T00';
   COMMENT ON COLUMN "AB03B"."AB03B36T00"."ID_002_TRAMITE" IS 'FK trmites';
   COMMENT ON COLUMN "AB03B"."AB03B36T00"."ID_001_FASE" IS 'FK fases';
   COMMENT ON COLUMN "AB03B"."AB03B36T00"."DELEGACION_036" IS 'Id de la delegacin´ ';
   COMMENT ON COLUMN "AB03B"."AB03B36T00"."FLAG_VB_036" IS 'Flag del visto bueno: 0-Sin visto bueno; 1-Con visto bueno ';
   COMMENT ON TABLE "AB03B"."AB03B36T00"  IS 'Tabla de flags para visto bueno por trmite y delegacin';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B03T00" 
   (	"ID_003" NUMBER(8,0), 
	"DESC_ES_003" VARCHAR2(150 BYTE), 
	"DESC_EU_003" VARCHAR2(150 BYTE), 
	"ACTIVO_SN_003" VARCHAR2(1 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B03T00"."ID_003" IS 'PK Secuencial de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B03T00"."DESC_ES_003" IS 'Descripcion en Castellano del Cargo';
   COMMENT ON COLUMN "AB03B"."AB03B03T00"."DESC_EU_003" IS 'Descripcion Euskera del cargo';
   COMMENT ON COLUMN "AB03B"."AB03B03T00"."ACTIVO_SN_003" IS 'Marca de Activo (S/N)';
   COMMENT ON TABLE "AB03B"."AB03B03T00"  IS 'Tabla de Cargos';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B44T00" 
   (	"ID_044" NUMBER(8,0), 
	"DESC_ES_044" VARCHAR2(150 BYTE), 
	"DESC_EU_044" VARCHAR2(150 BYTE), 
	"ACTIVO_SN_044" CHAR(1 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B44T00"."ID_044" IS 'Secuencia - Clave primaria de la tabla 44';
   COMMENT ON COLUMN "AB03B"."AB03B44T00"."DESC_ES_044" IS 'Descripcion castellano de Tipos de Documentos';
   COMMENT ON COLUMN "AB03B"."AB03B44T00"."DESC_EU_044" IS 'Descripcion euskera de Tipos de Documentos';
   COMMENT ON COLUMN "AB03B"."AB03B44T00"."ACTIVO_SN_044" IS 'DEFAULT ''S'' check (ACTIVO_SN_012 in (''S'',''N'')';
   COMMENT ON TABLE "AB03B"."AB03B44T00"  IS 'Tabla de Tipos de Documentos';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B04T00" 
   (	"ID_004" NUMBER(8,0), 
	"NOMBRE_004" VARCHAR2(150 BYTE), 
	"APEL1_004" VARCHAR2(150 BYTE), 
	"APEL2_004" VARCHAR2(150 BYTE), 
	"ID_003_CARGO" NUMBER(8,0), 
	"ACTIVO_SN_004" VARCHAR2(1 CHAR), 
	"ID_PROV_004" VARCHAR2(2 BYTE), 
	"TIPO_DOC_044" NUMBER(8,0), 
	"NIF_FIRMANTE_004" VARCHAR2(150 BYTE), 
	"BUZON_004" VARCHAR2(15 BYTE), 
	"FIRMA_ESCANEADA_004" BLOB, 
	"F_VIGENCIA_DS_004" DATE,
	"F_VIGENCIA_HS_004" DATE,
	"USUARIO_004" VARCHAR2(20 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" 
 LOB ("FIRMA_ESCANEADA_004") STORE AS BASICFILE (
  TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

   COMMENT ON COLUMN "AB03B"."AB03B04T00"."ID_004" IS 'PK Secuencial de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."NOMBRE_004" IS 'Nombre del firmante';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."APEL1_004" IS 'Apellido 1 del firmante';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."APEL2_004" IS 'Apellido 2 del firmante';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."ID_003_CARGO" IS 'FK a tabla de cargos';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."ACTIVO_SN_004" IS 'Marca de Activo (S/N)';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."ID_PROV_004" IS 'ID de la provincia';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."TIPO_DOC_044" IS 'FK a tabla 44 -  tipos de documento';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."NIF_FIRMANTE_004" IS 'NIF del firmante';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."BUZON_004" IS 'Buzn';
   COMMENT ON COLUMN "AB03B"."AB03B04T00"."FIRMA_ESCANEADA_004" IS 'Firma escaneada';
    COMMENT ON COLUMN "AB03B"."AB03B04T00"."F_VIGENCIA_DS_004" IS 'Fecha de vigencia desde';
    
	COMMENT ON COLUMN "AB03B"."AB03B04T00"."F_VIGENCIA_HS_004"  IS 'Fecha de vigencia hasta';
	COMMENT ON COLUMN "AB03B"."AB03B04T00"."USUARIO_004"  IS 'Usuario';
    COMMENT ON TABLE "AB03B"."AB03B04T00"  IS 'Tabla de firmantes';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B05T00" 
   (	"ID_005" NUMBER(8,0), 
	"NOMBRE_005" VARCHAR2(150 BYTE), 
	"PLANTILLA_005" BLOB
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" 
 LOB ("PLANTILLA_005") STORE AS BASICFILE (
  TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

   COMMENT ON COLUMN "AB03B"."AB03B05T00"."ID_005" IS 'PK secuencial de la tabla.';
   COMMENT ON COLUMN "AB03B"."AB03B05T00"."NOMBRE_005" IS 'Nombre de la plantilla';
   COMMENT ON COLUMN "AB03B"."AB03B05T00"."PLANTILLA_005" IS 'Plantilla';
   COMMENT ON TABLE "AB03B"."AB03B05T00"  IS 'Tabla de plantillas';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B06T00" 
   (	"ID_006" VARCHAR2(1 CHAR), 
	"DESC_ES_006" VARCHAR2(150 BYTE), 
	"DESC_EU_006" VARCHAR2(150 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B06T00"."ID_006" IS 'Id de tipo de Modificacion';
   COMMENT ON COLUMN "AB03B"."AB03B06T00"."DESC_ES_006" IS 'Modificacion';
   COMMENT ON COLUMN "AB03B"."AB03B06T00"."DESC_EU_006" IS 'Descripcion Euskera';
   COMMENT ON TABLE "AB03B"."AB03B06T00"  IS 'Tipos de acceso ';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B07T00" 
   (	"ID_007" VARCHAR2(100 BYTE), 
	"DESC_ES_007" VARCHAR2(150 BYTE), 
	"DESC_EU_007" VARCHAR2(150 BYTE), 
	"ID_COD_PADRE" VARCHAR2(100 BYTE), 
	"ACTO_NOTIF_007" VARCHAR2(50 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B07T00"."ID_007" IS 'Identificador de cdigo de documento';
   COMMENT ON COLUMN "AB03B"."AB03B07T00"."DESC_ES_007" IS 'Descripcin en Castellano';
   COMMENT ON COLUMN "AB03B"."AB03B07T00"."DESC_EU_007" IS 'Descripcin en Euskera';
   COMMENT ON COLUMN "AB03B"."AB03B07T00"."ID_COD_PADRE" IS 'ID del padre';
   COMMENT ON COLUMN "AB03B"."AB03B07T00"."ACTO_NOTIF_007" IS 'Acto de notificacin';
   COMMENT ON TABLE "AB03B"."AB03B07T00"  IS 'Tabla de tipos/Subtipos de documentos de Dokusi';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B08T00" 
   (	"ID_008" NUMBER(8,0), 
	"DESC_ES_008" VARCHAR2(250 BYTE), 
	"DESC_EU_008" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B08T00"."ID_008" IS 'Secuencia, clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B08T00"."DESC_ES_008" IS 'Descripcion castellano de tipo de solicitud/plan';
   COMMENT ON COLUMN "AB03B"."AB03B08T00"."DESC_EU_008" IS 'Descripcion Euskera de tipo de solicitud/plan';
   COMMENT ON TABLE "AB03B"."AB03B08T00"  IS 'Tabla de Tipos de solicitud/plan';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B41T00" 
   (	"ID_041" NUMBER(8,0), 
	"DESC_ES_041" VARCHAR2(100 BYTE), 
	"DESC_EU_041" VARCHAR2(100 BYTE), 
	"ACTIVO_SN_041" VARCHAR2(1 CHAR), 
	"COD_MCA_041" VARCHAR2(4 CHAR), 
	"FRIABLE_041" VARCHAR2(1 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B41T00"."ID_041" IS 'Secuencia - Clave primaria de tabla AB03B41T00';
   COMMENT ON COLUMN "AB03B"."AB03B41T00"."DESC_ES_041" IS 'Descripcin en castellano del tipo de material';
   COMMENT ON COLUMN "AB03B"."AB03B41T00"."DESC_EU_041" IS 'Descripcin en euskera del tipo de material';
   COMMENT ON COLUMN "AB03B"."AB03B41T00"."ACTIVO_SN_041" IS 'Marca de Activo (S/N)';
   COMMENT ON COLUMN "AB03B"."AB03B41T00"."COD_MCA_041" IS 'Cdigo MCA';
   COMMENT ON COLUMN "AB03B"."AB03B41T00"."FRIABLE_041" IS 'Friable S/N';
   COMMENT ON TABLE "AB03B"."AB03B41T00"  IS 'Tabla de tipos de material';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B53T00" 
   (	"ID_053" NUMBER(8,0), 
	"DESC_ES_053" VARCHAR2(100 BYTE), 
	"DESC_EU_053" VARCHAR2(100 BYTE), 
	"ACTIVO_SN_053" VARCHAR2(1 CHAR), 
	"COD_MCA_053" VARCHAR2(4 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B53T00"."ID_053" IS 'Secuencia - Clave primaria de tabla AB03B53T00';
   COMMENT ON COLUMN "AB03B"."AB03B53T00"."DESC_ES_053" IS 'Descripcin en castellano del tipo de trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B53T00"."DESC_EU_053" IS 'Descripcin en euskera del tipo de trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B53T00"."ACTIVO_SN_053" IS 'Marca de Activo (S/N)';
   COMMENT ON COLUMN "AB03B"."AB03B53T00"."COD_MCA_053" IS 'Cdigo MCA';
   COMMENT ON TABLE "AB03B"."AB03B53T00"  IS 'Tabla de tipos de trabajo';
  /*****************************************************************************************************/
 
   CREATE TABLE "AB03B"."AB03B54T00" 
   (	"ID_054" NUMBER(8,0), 
	"DESC_ES_054" VARCHAR2(100 BYTE), 
	"DESC_EU_054" VARCHAR2(100 BYTE), 
	"ACTIVO_SN_054" VARCHAR2(1 CHAR), 
	"COD_MCA_054" VARCHAR2(4 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B54T00"."ID_054" IS 'Secuencia - Clave primaria de tabla AB03B54T00';
   COMMENT ON COLUMN "AB03B"."AB03B54T00"."DESC_ES_054" IS 'Descripcin en castellano del tipo de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B54T00"."DESC_EU_054" IS 'Descripcin en euskera del tipo de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B54T00"."ACTIVO_SN_054" IS 'Marca de Activo (S/N)';
   COMMENT ON COLUMN "AB03B"."AB03B54T00"."COD_MCA_054" IS 'Cdigo MCA';
   COMMENT ON TABLE "AB03B"."AB03B54T00"  IS 'Tabla de tipos de actividad';
  /*****************************************************************************************************/
    CREATE TABLE "AB03B"."AB03B55T00" 
   (	"ID_055" NUMBER(8,0), 
	"DESC_ES_055" VARCHAR2(100 BYTE), 
	"DESC_EU_055" VARCHAR2(100 BYTE), 
	"ACTIVO_SN_055" VARCHAR2(1 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B55T00"."ID_055" IS 'Secuencia - Clave primaria de tabla AB03B55T00';
   COMMENT ON COLUMN "AB03B"."AB03B55T00"."DESC_ES_055" IS 'Descripcin en castellano del subtipo de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B55T00"."DESC_EU_055" IS 'Descripcin en euskera del subtipo de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B55T00"."ACTIVO_SN_055" IS 'Marca de Activo (S/N)';
   COMMENT ON TABLE "AB03B"."AB03B55T00"  IS 'Tabla de subtipos de actividad';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B47T00" 
   (	"ID_047" NUMBER(8,0), 
	"TIPO_DOC_044" NUMBER(8,0), 
	"NIF_EMPRESA_047" VARCHAR2(150 BYTE), 
	"RAZON_SOCIAL_047" VARCHAR2(200 BYTE), 
	"CALLE_047" VARCHAR2(250 BYTE), 
	"NUM_CALLE_047" VARCHAR2(150 BYTE), 
	"PISO_047" VARCHAR2(150 BYTE), 
	"LETRA_047" VARCHAR2(25 BYTE), 
	"CP_047" VARCHAR2(10 BYTE), 
	"MUNICIPIO_047" VARCHAR2(10 BYTE), 
	"PROVINCIA_047" VARCHAR2(10 BYTE), 
	"REPRESENTANTE_LEGAL_047" VARCHAR2(200 BYTE), 
	"TELF1_047" VARCHAR2(50 BYTE), 
	"TELF2_047" VARCHAR2(50 BYTE), 
	"FAX_047" VARCHAR2(50 BYTE), 
	"EMAIL_047" VARCHAR2(150 BYTE), 
	"NSS_047" VARCHAR2(20 BYTE), 
	"ACTIVO_SN_047" VARCHAR2(1 CHAR), 
	"CNAE_047" VARCHAR2(4 BYTE), 
	"NOMBRE_EMPRESA_047" VARCHAR2(150 BYTE), 
	"NUM_RERA_047" VARCHAR2(20 BYTE),
	"REF_CTRAB_047"  VARCHAR2(50 BYTE),
	"LOCALIDAD_047" VARCHAR2(15 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B47T00"."ID_047" IS 'Secuencia - Clave primaria de tabla AB03B47T00';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."TIPO_DOC_044" IS 'FK a Tabla de tipos de documento';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."NIF_EMPRESA_047" IS 'NIF de la emrpesa ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."RAZON_SOCIAL_047" IS 'Razn social ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."CALLE_047" IS 'Direccin - Calle ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."PISO_047" IS 'Direccin - Piso';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."LETRA_047" IS 'Direccin - Letra ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."CP_047" IS 'Direccin - Cdigo postal ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."MUNICIPIO_047" IS 'Municipio ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."PROVINCIA_047" IS 'Provincia';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."REPRESENTANTE_LEGAL_047" IS 'Representante legal ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."TELF1_047" IS 'Telfono 1';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."TELF2_047" IS 'Telfono 2 ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."FAX_047" IS 'Fax ';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."EMAIL_047" IS 'Email';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."NSS_047" IS 'Número de la seguridad social';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."ACTIVO_SN_047" IS 'DEFAULT ''S'' check (ACTIVO_SN_047 in (''S'',''N'')';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."CNAE_047" IS 'CNAE de la empresa';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."NOMBRE_EMPRESA_047" IS 'Nombre de la empresa';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."NUM_RERA_047" IS 'Número del RERA (prov/correlativo)';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."REF_CTRAB_047" IS  'Referencia del centro de trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B47T00"."LOCALIDAD_047" IS  'Localidad';
   COMMENT ON TABLE "AB03B"."AB03B47T00"  IS 'Tabla de empresas';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B10T00" 
   (	"ID_010" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"NUM_REG_010" VARCHAR2(32 BYTE), 
	"FEC_REG_010" DATE, 
	"IDIOMA_COMUNIC_010" NUMBER(8,0), 
	"PROVINCIA_TRABAJO_010" VARCHAR2(10 BYTE), 
	"MUNICIP_TRABAJO_010" VARCHAR2(10 BYTE), 
	"CALLE_TRABAJO_010" VARCHAR2(250 BYTE), 
	"NUMERO_TRABAJO_010" VARCHAR2(150 BYTE), 
	"PISO_TRABAJO_010" VARCHAR2(150 BYTE), 
	"LETRA_TRABAJO_010" VARCHAR2(25 BYTE), 
	"CPOSTAL_TRABAJO_010" VARCHAR2(10 BYTE), 
	"F_INICIO_TRABAJO_010" DATE, 
	"DURACION_DIAS_010" NUMBER(5,0), 
	"ESTADO_EXP_010" VARCHAR2(1 CHAR), 
	"EXP_CERRADO_010" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"NOTIF_LEIDA_010" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"REQ_LEIDO_010" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"ID_008_TIPO_PLAN" NUMBER(8,0), 
	"EXP_SANC_010" VARCHAR2(50 BYTE), 
	"TECN_ASIGN_010" VARCHAR2(150 BYTE), 
	"RESUMEN_ACTUAC_ES_010" VARCHAR2(4000 BYTE), 
	"EXP_ESPECIF_010" VARCHAR2(20 BYTE), 
	"VOLUMEN_MAT_010" NUMBER(10,0), 
	"SUPERFICIE_010" NUMBER(10,0), 
	"RESUMEN_ACTUAC_EU_010" VARCHAR2(4000 BYTE), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"ID_041_MATERIAL" NUMBER(8,0), 
	"TIPO_DOC_044" NUMBER(8,0), 
	"NIF_TITULAR_010" VARCHAR2(20 BYTE), 
	"NOMBRE_TITULAR_010" VARCHAR2(50 BYTE), 
	"APE1_TITULAR_010" VARCHAR2(50 BYTE), 
	"APE2_TITULAR_010" VARCHAR2(50 BYTE), 
	"SEXO_TITULAR_010" VARCHAR2(1 CHAR), 
	"FECHA_VISITA_010" DATE, 
	"ID_054_ACTIV" NUMBER(8,0),
	"OID_DOC_VISITA_010" VARCHAR2(100 BYTE),
	"OID_DOC_SANCION_010" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_010" IS 'ID del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_ANO_010" IS 'Año del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_PROV_010" IS 'Provincia del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."NUM_REG_010" IS 'Numero de Registro de entrada';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."FEC_REG_010" IS 'Fecha de Registro del expediente.';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."IDIOMA_COMUNIC_010" IS 'Idioma de comunicacion del Solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."PROVINCIA_TRABAJO_010" IS 'FK a Tabla de Provincias NORA - Provincia donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."MUNICIP_TRABAJO_010" IS 'FK a tabla de Municipios de NORA  - Municipio donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."CALLE_TRABAJO_010" IS 'Calle donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."NUMERO_TRABAJO_010" IS 'Direccion - Numero de la calle donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."PISO_TRABAJO_010" IS ' Direccion - Piso donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."LETRA_TRABAJO_010" IS 'Direccin -  Letra donde se va a realizar el trabajo ';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."CPOSTAL_TRABAJO_010" IS 'Cdigo Postal donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."F_INICIO_TRABAJO_010" IS 'Fecha de inicio del trabajo ';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."DURACION_DIAS_010" IS 'Duracin del trabajo en das ';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ESTADO_EXP_010" IS 'Estado en el que se encuentra el exepdiente: P-Pendiente; F-Res.favorable; D-Res.Denegatoria; S-Desestimado';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."EXP_CERRADO_010" IS 'Expediente cerrado: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."NOTIF_LEIDA_010" IS 'Notificacin leda: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."REQ_LEIDO_010" IS 'Requerimiento leido: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_008_TIPO_PLAN" IS 'FK a tabla 8: tipo de plan/solicitud ';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."EXP_SANC_010" IS 'Expediente sancionador ';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."TECN_ASIGN_010" IS 'NIF del Tcnico asignado';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."RESUMEN_ACTUAC_ES_010" IS 'Resumen de la actuacin a realizar castellano';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."EXP_ESPECIF_010" IS 'Número de expediente especfico';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."VOLUMEN_MAT_010" IS 'Volumen de material a retirar (m3)';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."SUPERFICIE_010" IS 'Superficie del trabajo (m2)';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."RESUMEN_ACTUAC_EU_010" IS 'Resumen de la actuacin a realizar euskera';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_047_EMPRESA" IS 'FK a tabla 47 - empresas';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_041_MATERIAL" IS 'FK a tabla 41 Tipo de material';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."TIPO_DOC_044" IS 'FK a tabla 44 - Tipo documento (del titular)';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."NIF_TITULAR_010" IS 'NIF del titular';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."NOMBRE_TITULAR_010" IS 'Nombre  del titular';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."APE1_TITULAR_010" IS 'Apellido 1 del titular';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."APE2_TITULAR_010" IS 'Apellido 2 del titular';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."SEXO_TITULAR_010" IS 'Sexo del titular - H/M';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."FECHA_VISITA_010" IS 'Fecha/hora de la visita previa al informe';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."ID_054_ACTIV" IS 'FK  a tabla 54 de Tipos de Actividad';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."OID_DOC_VISITA_010" IS 'OID del documento aportado en la visita inicial';
   COMMENT ON COLUMN "AB03B"."AB03B10T00"."OID_DOC_SANCION_010" IS 'OID del documento aportado en el expediente sancionador';
   COMMENT ON TABLE "AB03B"."AB03B10T00"  IS 'Tabla de expedientes ';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B34T00" 
   (	"ID_034" NUMBER(8,0), 
	"DESC_ES_034" VARCHAR2(250 BYTE), 
	"DESC_EU_034" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B34T00"."ID_034" IS 'Secuencia - Clave primaria de tabla AB03B34T00';
   COMMENT ON COLUMN "AB03B"."AB03B34T00"."DESC_ES_034" IS 'Descripcin en castellano del estado';
   COMMENT ON COLUMN "AB03B"."AB03B34T00"."DESC_EU_034" IS 'Descripcin en euskera del estado';
   COMMENT ON TABLE "AB03B"."AB03B34T00"  IS 'Tabla de estados de tramitacin';
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B14T00" 
   (	"ID_014" NUMBER(8,0), 
	"ID_001_FASE" NUMBER(8,0), 
	"ID_002_TRAMITE" NUMBER(8,0), 
	"ID_010_NUM_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"F_ACTU_014" DATE, 
	"USUA_014" VARCHAR2(120 BYTE), 
	"F_REG_SAL_014" DATE, 
	"N_REG_SAL_014" VARCHAR2(32 BYTE), 
	"F_NOTIF_014" DATE, 
	"F_EXPIR_014" DATE, 
	"F_TRAMITACION_014" DATE, 
	"ID_034_ESTADO" NUMBER(8,0), 
	"OBSERVACIONES_014" VARCHAR2(500 BYTE),
	"ID_NOTIF_014"      VARCHAR2(50 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_014" IS 'Secuencia - clave primaria de la tabla 14';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_001_FASE" IS 'FK a tabla de Fases';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_002_TRAMITE" IS 'FK a Tabla de Trmites';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_010_NUM_EXP" IS 'FK a tabla de expedientes';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_ANO_010" IS 'Año del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_PROV_010" IS 'Provincia del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_ACTU_014" IS 'Fecha de actualizacin del estado';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."USUA_014" IS 'Usuario de actualizacin';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_REG_SAL_014" IS 'Fecha de salida del registro';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."N_REG_SAL_014" IS 'Número de registro de salida';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_NOTIF_014" IS 'Fecha de Notificacin';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_EXPIR_014" IS 'Fecha de expiracin de la notificacin';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."F_TRAMITACION_014" IS 'Fecha de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_034_ESTADO" IS 'FK tabla 34 - Estado de la tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."OBSERVACIONES_014" IS 'Observaciones';
   COMMENT ON COLUMN "AB03B"."AB03B14T00"."ID_NOTIF_014" IS 'Id de la notificacin';
   COMMENT ON TABLE "AB03B"."AB03B14T00"  IS 'Historial de Tramitacin de un expediente';
  /*****************************************************************************************************/
    CREATE TABLE "AB03B"."AB03B09T00" 
   (	"ID_009" NUMBER(8,0), 
	"ID_008_TIPO_PLAN" NUMBER(8,0), 
	"NUMANO_009" NUMBER(4,0), 
	"FLECTURA_009" DATE, 
	"JMSID_009" VARCHAR2(64 BYTE), 
	"NUMREG_009" VARCHAR2(32 BYTE), 
	"FREGISTRO_009" DATE, 
	"MENSAJE_009" CLOB, 
	"ID_001_FASE" NUMBER(8,0), 
	"ID_002_TRAMITE" NUMBER(8,0), 
	"REMITENTE_NOM_009" VARCHAR2(250 BYTE), 
	"SITUACION_009" VARCHAR2(1 BYTE), 
	"REMITENTE_ID_009" VARCHAR2(16 BYTE), 
	"ID_010_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"ID_014_TRAM" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" 
 LOB ("MENSAJE_009") STORE AS BASICFILE (
  TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_009" IS 'PK de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_008_TIPO_PLAN" IS 'Codigo de tipo de PLAN';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."NUMANO_009" IS 'Año de la peticion';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."FLECTURA_009" IS 'Fecha de lectura';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."JMSID_009" IS 'JMS ID';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."NUMREG_009" IS 'Numero de Registro de Entrada';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."FREGISTRO_009" IS 'Fecha de registro de la solicitud';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."MENSAJE_009" IS 'Mensaje completo enviado.';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_001_FASE" IS 'FK a Fase';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_002_TRAMITE" IS 'FK a Trmite';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."REMITENTE_NOM_009" IS 'Remitente';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."SITUACION_009" IS 'Situacin de la Solicitud:   P: Aceptada V: volcado a AB03B';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."REMITENTE_ID_009" IS 'ID del Remitente';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_010_EXP" IS 'FK tabla de expedientes - Id del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_ANO_010" IS 'FK tabla de expedientes - Año del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_PROV_010" IS 'FK tabla de expedientes - Provincia del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B09T00"."ID_014_TRAM" IS 'FK tabla historial de tramitacin';
   COMMENT ON TABLE "AB03B"."AB03B09T00"  IS 'Tabla repositorio para las entradas Telemticas';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B11T00" 
   (	"ID_011" NUMBER(8,0), 
	"ID_001_FASE" NUMBER(8,0), 
	"ID_002_TRAMITE" NUMBER(8,0), 
	"ID_008_TIPO_PLAN" NUMBER(8,0), 
	"DESC_ES_011" VARCHAR2(600 BYTE), 
	"DESC_EU_011" VARCHAR2(600 BYTE), 
	"ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_011" IS 'Clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_001_FASE" IS 'FK a Tabla de Fases';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_002_TRAMITE" IS 'FK a Tabla de Trmites';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_008_TIPO_PLAN" IS 'FK a Tipos de plan';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."DESC_ES_011" IS 'Descripcin Castellano del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."DESC_EU_011" IS 'Descripcin Euskera del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_007_TP_DOC_DOKUSI" IS 'Tipo de Documento de dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B11T00"."ID_007_ST_DOC_DOKUSI" IS 'SubTipo de Documento de Dokusi';
   COMMENT ON TABLE "AB03B"."AB03B11T00"  IS 'Tipos de documentos de entrada';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B12T00" 
   (	"ID_012" VARCHAR2(100 BYTE), 
	"DESC_ES_012" VARCHAR2(150 BYTE), 
	"DESC_EU_012" VARCHAR2(150 BYTE), 
	"ID_009_CODJMS" NUMBER(8,0), 
	"META_INF_012" VARCHAR2(640 BYTE), 
	"ID_011_DOC_SOL" NUMBER(8,0), 
	"OID_012" VARCHAR2(100 BYTE), 
	"ORG_DOC_ENTREGADO_015" VARCHAR2(640 BYTE), 
	"NOM_DOC_ENTREGADO_015" VARCHAR2(640 BYTE), 
	"FEC_DOC_ENTREGADO_015" DATE, 
	"TIPO_APORTACION_015" VARCHAR2(6 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_012" IS 'OID del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."DESC_ES_012" IS 'Descripcin en castellano';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."DESC_EU_012" IS 'Descripcin en Euskera';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_009_CODJMS" IS 'FK a la tabla 009 (Codigo de Solicitud Telemtica JMS)';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."META_INF_012" IS 'Metainformacin del documento';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."ID_011_DOC_SOL" IS 'FK a la tabla 011: ID del documento de solicitudes';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."ORG_DOC_ENTREGADO_015" IS 'Organismo de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."NOM_DOC_ENTREGADO_015" IS 'Nombre del Documento entregado';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."FEC_DOC_ENTREGADO_015" IS 'Fecha de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B12T00"."TIPO_APORTACION_015" IS 'Tipo de aportacin del documento: A- Adjuntado; E- Entregado';
   COMMENT ON TABLE "AB03B"."AB03B12T00"  IS 'Tabla de OIDs Dokusi de entrada Telemtica';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B13T00" 
   (	"ID_013" NUMBER(8,0), 
	"ID_001_FASE" NUMBER(8,0), 
	"ID_002_TRAMITE" NUMBER(8,0), 
	"DESC_ES_013" VARCHAR2(400 BYTE), 
	"DESC_EU_013" VARCHAR2(400 BYTE), 
	"ID_005_PLANTILLA" NUMBER(8,0), 
	"ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_008_TIPO_PLAN" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_013" IS 'PK Secuencia de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_001_FASE" IS 'FK a Tabla de Fases';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_002_TRAMITE" IS 'FK a Tabla de Trmites ';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."DESC_ES_013" IS 'Descripcin Castellano del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."DESC_EU_013" IS 'Descripcin Euskera del Documento ';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_005_PLANTILLA" IS 'FK a tabla 5: ID de la plantilla';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_007_TP_DOC_DOKUSI" IS 'Tipo de Documento de Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_007_ST_DOC_DOKUSI" IS 'SubTipo de Docuento de Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B13T00"."ID_008_TIPO_PLAN" IS 'FK a tabla 8: Tipos de plan';
   COMMENT ON TABLE "AB03B"."AB03B13T00"  IS 'Tabla de Tipos de Documentos generados';
  /*****************************************************************************************************/
  
CREATE TABLE "AB03B"."AB03B56T00" 
   (	"ID_056" NUMBER(8,0), 
	"ID_014" NUMBER(8,0), 
	"ID_041_MATERIAL" NUMBER(8,0), 
	"ID_054_ACTIVIDAD" NUMBER(8,0), 
	"ID_055_SUB_ACTIVIDAD" NUMBER(8,0), 
	"PREVISION_MCA_056" VARCHAR2(100 BYTE), 
	"ESTIMACION_MCA_056" NUMBER(8,2),
  "PROVINCIA_TRABAJO_056" VARCHAR2(10 BYTE), 
	"MUNICIP_TRABAJO_056" VARCHAR2(10 BYTE), 
	"CALLE_TRABAJO_056" VARCHAR2(250 BYTE), 
	"NUMERO_TRABAJO_056" VARCHAR2(150 BYTE), 
	"PISO_TRABAJO_056" VARCHAR2(150 BYTE), 
	"LETRA_TRABAJO_056" VARCHAR2(25 BYTE), 
	"CPOSTAL_TRABAJO_056" VARCHAR2(10 BYTE), 
	"F_INICIO_TRABAJO_056" DATE, 
	"DURACION_DIAS_056" NUMBER(5,0),
	"ID_057" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_056" IS 'Clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_014" IS 'FK a Tabla de Historial de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_041_MATERIAL" IS 'FK a Tipos de material';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_054_ACTIVIDAD" IS 'FK a Tipos de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."PROVINCIA_TRABAJO_056" IS 'FK a Tabla de Provincias NORA - Provincia donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."MUNICIP_TRABAJO_056" IS 'FK a tabla de Municipios de NORA  - Municipio donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."CALLE_TRABAJO_056" IS 'Calle donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."NUMERO_TRABAJO_056" IS 'Direccion - Numero de la calle donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."PISO_TRABAJO_056" IS ' Direccion - Piso donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."LETRA_TRABAJO_056" IS 'Direccin -  Letra donde se va a realizar el trabajo ';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."CPOSTAL_TRABAJO_056" IS 'Cdigo Postal donde se va a realizar el trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."F_INICIO_TRABAJO_056" IS 'Fecha de inicio del trabajo ';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."DURACION_DIAS_056" IS 'Duracin del trabajo en das ';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_057" IS 'Id fin de obra';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ID_055_SUB_ACTIVIDAD" IS 'FK a Subtipos de actividad';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."PREVISION_MCA_056" IS 'Previsin MCA';
   COMMENT ON COLUMN "AB03B"."AB03B56T00"."ESTIMACION_MCA_056" IS 'Estimacin MCA en KGs';
   COMMENT ON TABLE "AB03B"."AB03B56T00"  IS 'Datos de ejecucin de Osalan';
/*****************************************************************************************************/  
   CREATE TABLE "AB03B"."AB03B59T00" 
   (	"ID_059" NUMBER(8,0), 
	"ID_056_EJECUCION" NUMBER(8,0), 
	"ID_053_TRABAJO" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B59T00"."ID_059" IS 'Secuencia PK de la tabla de tipos de trabajo por ejecucin';
   COMMENT ON COLUMN "AB03B"."AB03B59T00"."ID_056_EJECUCION" IS 'FK a tabla de datos de ejecucin ';
   COMMENT ON COLUMN "AB03B"."AB03B59T00"."ID_053_TRABAJO" IS 'FK a tabla de tipos de trabajo ';
   COMMENT ON TABLE "AB03B"."AB03B59T00"  IS 'Tabla de tipos de trabajo por ejecucin';
  /*****************************************************************************************************/  
  CREATE TABLE "AB03B"."AB03B57T00" 
   (	"ID_057" NUMBER(8,0), 
	"ID_014" NUMBER(8,0), 
	"NIMA_057" VARCHAR2(100 BYTE), 
	"EXISTE_DSC_057" VARCHAR2(1 BYTE) DEFAULT 'N' , 
	"CANTIDAD_057" NUMBER(8,2), 
	"CORRECTO_NIMA_057" VARCHAR2(1 BYTE) DEFAULT 'N' , 
	"NUMERO_DA_057" VARCHAR2(100 BYTE), 
	"ACTIV_EVID_057" VARCHAR2(100 BYTE), 
	"SOLIC_PLAN_057" VARCHAR2(1 BYTE) DEFAULT 'N' , 
	"RECIBIDO_057" VARCHAR2(1 BYTE) DEFAULT 'N' , 
	"CORRECTO_ANEXO_057" VARCHAR2(1 BYTE) DEFAULT 'N' , 
	"REENVIADO_057" VARCHAR2(1 BYTE) DEFAULT 'N',
	"ID_056" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B57T00"."ID_057" IS 'Clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."ID_014" IS 'FK a Tabla de Historial de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."NIMA_057" IS 'Número de identificacin medioambiental';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."EXISTE_DSC_057" IS 'Existe documento de seguimiento y control S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."CANTIDAD_057" IS 'CAntidad total para esta ubicacin en KGs';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."CORRECTO_NIMA_057" IS 'Es correcto S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."NUMERO_DA_057" IS 'Número de documento de aceptacin';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."ACTIV_EVID_057" IS 'Activacin - Evidencia';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."SOLIC_PLAN_057" IS 'Solicitado en plan de trabajo S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."RECIBIDO_057" IS 'Recibido S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."CORRECTO_ANEXO_057" IS 'Es correcto S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."REENVIADO_057" IS 'Reenviado a servicios centrales S/N';
   COMMENT ON COLUMN "AB03B"."AB03B57T00"."ID_056" IS 'Id de inicio obra';
   COMMENT ON TABLE "AB03B"."AB03B57T00"  IS 'Datos de seguimiento de ejecucin de Osalan';
/*****************************************************************************************************/  
   CREATE TABLE "AB03B"."AB03B58T00" 
   (	"ID_058" NUMBER(8,0), 
	"ID_014" NUMBER(8,0), 
	"FECHA_HORA_058" DATE, 
	"INCUMPLIMIENTO_058" VARCHAR2(1 CHAR),
	"OID_DOC_VISITA_058" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B58T00"."ID_058" IS 'Clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B58T00"."ID_014" IS 'FK a Tabla de Historial de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B58T00"."FECHA_HORA_058" IS 'Fecha y hora de la visita';
   COMMENT ON COLUMN "AB03B"."AB03B58T00"."INCUMPLIMIENTO_058" IS 'Se detecta incumplimiento S/N';
   COMMENT ON COLUMN "AB03B"."AB03B58T00"."OID_DOC_VISITA_058" IS 'OID del documento aportado en la visita de comprobacin';
   COMMENT ON TABLE "AB03B"."AB03B58T00"  IS 'Tabla de visitas de comprobacin';
/*****************************************************************************************************/  
 CREATE TABLE "AB03B"."AB03B15T00" 
   (	"ID_015" NUMBER(8,0), 
	"ID_010_NUM_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"ID_013_TIPO_DOC_G" NUMBER(8,0), 
	"ID_014_HISTO_TRAM" NUMBER(8,0), 
	"ID_PIF_015" VARCHAR2(128 BYTE), 
	"OID_015" VARCHAR2(100 BYTE), 
	"OBSERVACIONES_ES_015" VARCHAR2(500 BYTE), 
	"OBSERVACIONES_EU_015" VARCHAR2(500 BYTE), 
	"CONDIC_ESPECIF_015" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"ORG_DOC_ENTREGADO_015" VARCHAR2(640 BYTE), 
	"NOM_DOC_ENTREGADO_015" VARCHAR2(640 BYTE), 
	"FEC_DOC_ENTREGADO_015" DATE, 
	"TIPO_APORTACION_015" VARCHAR2(6 BYTE), 
	"ID_011_DOCENTRADA" NUMBER(8,0), 
	"ID_004_FIRMANTE" NUMBER(8,0),
	"AUDITUSER_015"       VARCHAR2(100 BYTE),
	"MOTIVO_RECHAZO_015"       VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_015" IS 'PF Secuencial de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_010_NUM_EXP" IS 'FK a Tabla de Expedientes ';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_013_TIPO_DOC_G" IS 'FK a Tipos de Documentacin Generada';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_014_HISTO_TRAM" IS 'FK a Historial de Tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_PIF_015" IS 'Identificador del Documeto en PIF';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."OID_015" IS 'OID del Documento en Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."OBSERVACIONES_ES_015" IS 'Observaciones castellano';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."OBSERVACIONES_EU_015" IS 'Observaciones euskera';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."CONDIC_ESPECIF_015" IS 'Indica si la resolucin tiene condiciones especficas: N- no; S- s';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ORG_DOC_ENTREGADO_015" IS 'Organismo de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."NOM_DOC_ENTREGADO_015" IS 'Nombre del Documento entregado';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."FEC_DOC_ENTREGADO_015" IS 'Fecha de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."TIPO_APORTACION_015" IS 'Tipo de aportacion del documento: A-Adjuntado; E- Entregado';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_011_DOCENTRADA" IS 'FK a tabla 11 - Tipo Documentos de Entrada';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."ID_004_FIRMANTE" IS 'FK a tabla 4 firmantes';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."AUDITUSER_015" IS 'Usuario que manda el documento para convertirlo a PDF';
   COMMENT ON COLUMN "AB03B"."AB03B15T00"."MOTIVO_RECHAZO_015" IS 'Motivo de rechazo de la firma';   
   COMMENT ON TABLE "AB03B"."AB03B15T00"  IS 'Documentacin de expedientes ';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B16T00" 
   (	"ID_016" NUMBER(8,0), 
	"ID_010_NUM_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"ID_006_TP_ACCESO" VARCHAR2(1 CHAR), 
	"F_ACTU_016" DATE, 
	"USU_MODIF_016" VARCHAR2(150 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_016" IS 'Secuencia - Clave primaria de tabla AB03B16T00';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_010_NUM_EXP" IS 'FK a Tabla de expedientes';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_ANO_010" IS 'FK tabla de expedientes - Año del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_PROV_010" IS 'FK tabla de expedientes - Provincia del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."ID_006_TP_ACCESO" IS 'FK a Tipo de Acceso';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."F_ACTU_016" IS 'Fecha de Actualizacin del resgistro';
   COMMENT ON COLUMN "AB03B"."AB03B16T00"."USU_MODIF_016" IS 'Usuario de acceso al resgistro';
   COMMENT ON TABLE "AB03B"."AB03B16T00"  IS 'Tabla de Accesos a Expedientes';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B40T00" 
   (	"ID_040" NUMBER(8,0), 
	"DESC_ES_040" VARCHAR2(100 BYTE), 
	"DESC_EU_040" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B40T00"."ID_040" IS 'Secuencia - Clave primaria de tabla AB03B40T00';
   COMMENT ON COLUMN "AB03B"."AB03B40T00"."DESC_ES_040" IS 'Descripcin en castellano de la naturaleza del trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B40T00"."DESC_EU_040" IS 'Descripcin en euskera de la naturaleza del trabajo';
   COMMENT ON TABLE "AB03B"."AB03B40T00"  IS 'Tabla de tipo de naturaleza concreta del trabajo';
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B42T00" 
   (	"ID_042" NUMBER(8,0), 
	"ID_040" NUMBER(8,0), 
	"ID_010_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B42T00"."ID_042" IS 'Secuencia - Clave primaria de tabla AB03B42T00';
   COMMENT ON COLUMN "AB03B"."AB03B42T00"."ID_040" IS 'FK a Tabla de tipos de naturaleza del trabajo';
   COMMENT ON COLUMN "AB03B"."AB03B42T00"."ID_010_EXP" IS 'FK tabla de expedientes - Id del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B42T00"."ID_ANO_010" IS 'FK tabla de expedientes - Año del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B42T00"."ID_PROV_010" IS 'FK tabla de expedientes - Provincia del expediente ';
   COMMENT ON TABLE "AB03B"."AB03B42T00"  IS 'Tabla de naturaleza de los trabajos por expediente';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B32T00" 
   (	"ID_032" NUMBER(8,0), 
	"TIPO_DOC_044" NUMBER(8,0), 
	"NIF_032" VARCHAR2(150 BYTE), 
	"NOMBRE_032" VARCHAR2(150 BYTE), 
	"APELLIDO1_032" VARCHAR2(150 BYTE), 
	"APELLIDO2_032" VARCHAR2(150 BYTE), 
	"ESTADO_032" VARCHAR2(1 CHAR) DEFAULT '1', 
	"NSS_032" VARCHAR2(20 BYTE), 
	"SEXO_032" VARCHAR2(1 CHAR), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"FECHA_APTITUD_032" DATE, 
	"TITULACIONES_032" VARCHAR2(500 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B32T00"."ID_032" IS 'Secuencia - Clave primaria de tabla AB03B32T00';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."TIPO_DOC_044" IS 'FK  a tabla 44 - Tipo documento (NIF, CIF....)';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."NIF_032" IS 'NIF del trabajador';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."NOMBRE_032" IS 'Nombre del trabajador';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."APELLIDO1_032" IS 'Apellido 1 del trabajador';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."APELLIDO2_032" IS 'Apellido 2 del trabajador';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."ESTADO_032" IS 'Estado del trabajador en trabajos RERA: 1-Alta 0-Baja';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."NSS_032" IS 'Número de la seguridad social';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."SEXO_032" IS 'Sexo del trabajador: M- Mujer; H- Hombre';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."ID_047_EMPRESA" IS 'FK tabla 47 - empresas';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."FECHA_APTITUD_032" IS 'Fecha lmite de aptitud mdica';
   COMMENT ON COLUMN "AB03B"."AB03B32T00"."TITULACIONES_032" IS 'Titulaciones del trabajador';
   COMMENT ON TABLE "AB03B"."AB03B32T00"  IS 'Tabla de trabajadores por empresa RERA';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B33T00" 
   (	"ID_033" NUMBER(8,0), 
	"ID_032_TRAB" NUMBER(8,0), 
	"ID_010_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"ACTIVO_SN_033" VARCHAR2(1 BYTE) DEFAULT '1'
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ID_033" IS 'Secuencia - Clave primaria de tabla AB03B33T00';
   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ID_032_TRAB" IS 'FK a Tabla de trabajadores RERA';
   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ID_010_EXP" IS 'FK tabla de expedientes - Id del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ID_ANO_010" IS 'FK tabla de expedientes - Año del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ID_PROV_010" IS 'FK tabla de expedientes - Provincia del expediente ';
   COMMENT ON COLUMN "AB03B"."AB03B33T00"."ACTIVO_SN_033" IS 'Marca de Activo (1-Activo, 0-Inactivo)';
   COMMENT ON TABLE "AB03B"."AB03B33T00"  IS 'Tabla de trabajadores por expediente';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B45T00" 
   (	"ID_045" NUMBER(8,0), 
	"DESC_ES_045" VARCHAR2(150 BYTE), 
	"DESC_EU_045" VARCHAR2(150 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B45T00"."ID_045" IS 'Secuencia - Clave primaria de la tabla 45';
   COMMENT ON COLUMN "AB03B"."AB03B45T00"."DESC_ES_045" IS 'Descripcion castellano de Tipo de organismo';
   COMMENT ON COLUMN "AB03B"."AB03B45T00"."DESC_EU_045" IS 'Descripcion euskera de Tipo de organismo';
   COMMENT ON TABLE "AB03B"."AB03B45T00"  IS 'Tabla de Tipos de Organismo';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B39T00" 
   (	"ID_039" NUMBER(2,0), 
	"TERRITORIO_039" VARCHAR2(2 BYTE), 
	"CALLE_039" VARCHAR2(250 BYTE), 
	"NUMERO_039" VARCHAR2(150 BYTE), 
	"PISO_039" VARCHAR2(150 BYTE), 
	"LETRA_039" VARCHAR2(25 BYTE), 
	"COD_POSTAL_039" VARCHAR2(10 BYTE), 
	"MUNICIPIO_039" VARCHAR2(10 BYTE), 
	"TELEFONO_039" VARCHAR2(50 BYTE), 
	"FAX_039" VARCHAR2(50 BYTE), 
	"DESC_ES_039" VARCHAR2(250 BYTE), 
	"DESC_EU_039" VARCHAR2(250 BYTE), 
	"ID_045_ORG" NUMBER(8,0), 
	"REG_MANUAL_039" VARCHAR2(1 CHAR), 
	"EMAIL_039" VARCHAR2(100 BYTE),
	"ID_PERFIL_039" VARCHAR2(3 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B39T00"."ID_039" IS 'Secuencia - Clave primaria de tabla AB03B39T00';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."TERRITORIO_039" IS 'FK a tabla de provincias NORA';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."CALLE_039" IS 'Direccin del organismo - Calle';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."NUMERO_039" IS 'Direccin del organismo - Número';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."PISO_039" IS 'Direccin del organismo - Piso';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."LETRA_039" IS 'Direccin del organismo - Letra';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."COD_POSTAL_039" IS 'Direccin del organismo - Cdigo postal';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."MUNICIPIO_039" IS 'Direccin del organismo - Municipio';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."TELEFONO_039" IS 'Número de telfono';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."FAX_039" IS 'Número de fax';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."DESC_ES_039" IS 'Descripcin en castellano';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."DESC_EU_039" IS 'Descripcin en euskera';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."ID_045_ORG" IS 'FK a tabla 45 -  Tipos de organismo';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."REG_MANUAL_039" IS 'Registro manual: 0- automtico; 1- manual';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."EMAIL_039" IS 'Direccin de email';
   COMMENT ON COLUMN "AB03B"."AB03B39T00"."ID_PERFIL_039" IS 'Id del perfil de usuario';
   COMMENT ON TABLE "AB03B"."AB03B39T00"  IS 'Tabla de organismos';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B46T00" 
   (	"ID_046" NUMBER(8,0), 
	"ID_014_HISTO_TRAM" NUMBER(8,0), 
	"ID_039_ORGAN" NUMBER(8,0), 
	"ESTADO_046" VARCHAR2(1 CHAR), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"FEC_COMUNIC_046" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B46T00"."ID_046" IS 'Secuencia - Clave primaria de tabla AB03B46T00';
   COMMENT ON COLUMN "AB03B"."AB03B46T00"."ID_014_HISTO_TRAM" IS 'FK a Tabla de historial de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B46T00"."ID_039_ORGAN" IS 'FK tabla de organismos ';
   COMMENT ON COLUMN "AB03B"."AB03B46T00"."ESTADO_046" IS 'Estado de la comunicacion: 0- No enviado; 1- Enviado; 2- Con error ';
   COMMENT ON COLUMN "AB03B"."AB03B46T00"."ID_047_EMPRESA" IS 'FK a tabla 47 de empresas';
   COMMENT ON COLUMN "AB03B"."AB03B46T00"."FEC_COMUNIC_046" IS 'Fecha en la que se realiza la comunicacin';
   COMMENT ON TABLE "AB03B"."AB03B46T00"  IS 'Tabla de comunicaciones';
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B17T00" 
   (	"ID_017" NUMBER(8,0), 
	"DESC_ES_017" VARCHAR2(250 BYTE), 
	"DESC_EU_017" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B17T00"."ID_017" IS 'Secuencia, clave primaria de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B17T00"."DESC_ES_017" IS 'Descripcion en castellano de la Fase RERA';
   COMMENT ON COLUMN "AB03B"."AB03B17T00"."DESC_EU_017" IS 'Descripcion en euskera de la Fase  RERA';
   COMMENT ON TABLE "AB03B"."AB03B17T00"  IS 'Tabla de Fases de RERA';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B18T00" 
   (	"ID_018" NUMBER(8,0), 
	"ID_017_FASE" NUMBER(8,0), 
	"DESC_ES_018" VARCHAR2(200 BYTE), 
	"DESC_EU_018" VARCHAR2(200 BYTE), 
	"ENT_SAL_018" VARCHAR2(1 CHAR)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B18T00"."ID_018" IS 'Secuencia PK de la tabla de tramites';
   COMMENT ON COLUMN "AB03B"."AB03B18T00"."ID_017_FASE" IS 'FK a tabla de Fases RERA';
   COMMENT ON COLUMN "AB03B"."AB03B18T00"."DESC_ES_018" IS 'Descripcin en castellano del Tramite RERA';
   COMMENT ON COLUMN "AB03B"."AB03B18T00"."DESC_EU_018" IS 'Descripcion en Euskera del Tramite RERA';
   COMMENT ON COLUMN "AB03B"."AB03B18T00"."ENT_SAL_018" IS 'Indica si el trmite es de entrada o salida: E- Entrada; S-Salida';
   COMMENT ON TABLE "AB03B"."AB03B18T00"  IS 'Tabla de trmites de RERA';

  /*****************************************************************************************************/
 
  CREATE TABLE "AB03B"."AB03B21T00" 
   (	"ID_021" NUMBER(8,0), 
	"NOMBRE_021" VARCHAR2(150 BYTE), 
	"PLANTILLA_021" BLOB
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" 
 LOB ("PLANTILLA_021") STORE AS BASICFILE (
  TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

   COMMENT ON COLUMN "AB03B"."AB03B21T00"."ID_021" IS 'PK secuencial de la tabla.';
   COMMENT ON COLUMN "AB03B"."AB03B21T00"."NOMBRE_021" IS 'Nombre de la plantilla RERA';
   COMMENT ON COLUMN "AB03B"."AB03B21T00"."PLANTILLA_021" IS 'Plantilla RERA';
   COMMENT ON TABLE "AB03B"."AB03B21T00"  IS 'Tabla de plantillas de RERA';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B22T00" 
   (	"ID_022" NUMBER(8,0), 
	"DESC_ES_022" VARCHAR2(250 BYTE), 
	"DESC_EU_022" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B22T00"."ID_022" IS 'Secuencia, clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B22T00"."DESC_ES_022" IS 'Descripcion castellano de tipo de solicitud RERA';
   COMMENT ON COLUMN "AB03B"."AB03B22T00"."DESC_EU_022" IS 'Descripcion Euskera de tipo de solicitud RERA';
   COMMENT ON TABLE "AB03B"."AB03B22T00"  IS 'Tabla de Tipos de solicitudes RERA';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B24T00" 
   (	"ID_024" NUMBER(8,0), 
	"NUM_REG_024" VARCHAR2(32 BYTE), 
	"FEC_REG_024" DATE, 
	"IDIOMA_COMUNIC_024" NUMBER(8,0), 
	"INSCRIPCION_FAVORABLE_024" NUMBER(1,0), 
	"EXP_CERRADO_024" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"NOTIF_LEIDA_024" VARCHAR2(1 CHAR) DEFAULT 'N' --  Flag para marcar la lectura de la notificacion
  , 
	"REQ_LEIDO_024" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"ID_022_TIPO_PLAN" NUMBER(8,0), 
	"CAMBIO_ESTATUTOS_024" VARCHAR2(1 CHAR) DEFAULT 'N', 
	"ESTADO_EMPRESA_024" VARCHAR2(1 CHAR) DEFAULT '0', 
	"F_CAMBIO_ESTADO_024" DATE, 
	"ID_PROV_024" VARCHAR2(2 CHAR), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"TIPO_DOC_044" NUMBER(8,0), 
	"NIF_SOLICITANTE_024" VARCHAR2(150 BYTE), 
	"NOMBRE_SOLICIT_024" VARCHAR2(150 BYTE), 
	"CARGO_EMPRESA_024" VARCHAR2(100 BYTE), 
	"APE1_SOLICIT_024" VARCHAR2(50 BYTE), 
	"APE2_SOLICIT_024" VARCHAR2(50 BYTE), 
	"SEXO_SOLICIT_024" VARCHAR2(1 BYTE), 
	"ID_ANO_024" NUMBER(4,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_024" IS 'ID del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."NUM_REG_024" IS 'Numero de Registro de entrada';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."FEC_REG_024" IS 'Fecha de Registro del expediente.';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."IDIOMA_COMUNIC_024" IS 'Idioma de comunicacion del Solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."INSCRIPCION_FAVORABLE_024" IS 'Inscripcin favorable de la empresa: 1: SI 0: NO';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."EXP_CERRADO_024" IS 'Expediente cerrado: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."NOTIF_LEIDA_024" IS 'Notificacinn leda: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."REQ_LEIDO_024" IS 'Requerimiento leido: S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_022_TIPO_PLAN" IS 'FK a tabla 22: tipo de plan RERA ';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."CAMBIO_ESTATUTOS_024" IS 'Indica si la empresa ha tenido cambios en sus estatutos S: SI N: NO';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ESTADO_EMPRESA_024" IS 'Estado de la empresa en RERA: 0-Alta 1-Baja';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."F_CAMBIO_ESTADO_024" IS 'Fecha de cambio de la empresa (alta/baja)';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_PROV_024" IS 'Provincia del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_047_EMPRESA" IS 'FK a tabla 47 de Empresas';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."TIPO_DOC_044" IS 'FK a Tabla de tipos de documento';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."NIF_SOLICITANTE_024" IS 'NIF del solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."NOMBRE_SOLICIT_024" IS 'Nombre del solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."CARGO_EMPRESA_024" IS 'Cargo del solicitante dentro de la empresa';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."APE1_SOLICIT_024" IS 'Apellido 1 del solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."APE2_SOLICIT_024" IS 'Apellido 2 del solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."SEXO_SOLICIT_024" IS 'Sexo del solicitante';
   COMMENT ON COLUMN "AB03B"."AB03B24T00"."ID_ANO_024" IS 'Año del expediente';
   COMMENT ON TABLE "AB03B"."AB03B24T00"  IS 'Tabla de expedientes RERA';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B30T00" 
   (	"ID_030" NUMBER(8,0), 
	"ID_024_NUM_EXP" NUMBER(8,0), 
	"ID_006_TP_ACCESO" VARCHAR2(1 CHAR), 
	"F_ACTU_030" DATE, 
	"USU_MODIF_030" VARCHAR2(150 BYTE), 
	"ID_PROV_024" VARCHAR2(2 CHAR), 
	"ID_ANO_024" NUMBER(4,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_030" IS 'Secuencia - Clave primaria de tabla AB03B30T00';
   COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_024_NUM_EXP" IS 'FK a Tabla de expedientes';
   COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_006_TP_ACCESO" IS 'FK a Tipo de Acceso';
   COMMENT ON COLUMN "AB03B"."AB03B30T00"."F_ACTU_030" IS 'Fecha de Actualizacin del resgistro';
   COMMENT ON COLUMN "AB03B"."AB03B30T00"."USU_MODIF_030" IS 'Usuario de acceso al resgistro';
   COMMENT ON COLUMN "AB03B"."AB03B30T00"."ID_ANO_024" IS 'FK a Tabla de expedientes - Año';
   COMMENT ON TABLE "AB03B"."AB03B30T00"  IS 'Tabla de Accesos a Expedientes RERA';
  /*****************************************************************************************************/
   CREATE TABLE "AB03B"."AB03B35T00" 
   (	"ID_035" NUMBER(8,0), 
	"DESC_ES_035" VARCHAR2(250 BYTE), 
	"DESC_EU_035" VARCHAR2(250 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B35T00"."ID_035" IS 'Secuencia - Clave primaria de tabla AB03B35T00';
   COMMENT ON COLUMN "AB03B"."AB03B35T00"."DESC_ES_035" IS 'Descripcin en castellano del estado';
   COMMENT ON COLUMN "AB03B"."AB03B35T00"."DESC_EU_035" IS 'Descripcin en euskera del estado';
   COMMENT ON TABLE "AB03B"."AB03B35T00"  IS 'Tabla de estados de tramitacin RERA';
 /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B28T00" 
   (	"ID_028" NUMBER(8,0), 
	"ID_017_FASE" NUMBER(8,0), 
	"ID_018_TRAMITE" NUMBER(8,0), 
	"ID_024_NUM_EXP" NUMBER(8,0), 
	"F_ACTU_028" DATE, 
	"USUA_028" VARCHAR2(120 BYTE), 
	"F_REG_SAL_028" DATE, 
	"N_REG_SAL_028" VARCHAR2(32 BYTE), 
	"F_NOTIF_028" DATE, 
	"F_EXPIR_028" DATE, 
	"F_TRAMITACION_028" DATE, 
	"ID_035_ESTADO" NUMBER(8,0), 
	"ID_PROV_024" VARCHAR2(2 CHAR), 
	"ID_ANO_024" NUMBER(4,0), 
	"OBSERVACIONES_028" VARCHAR2(500 BYTE),
	"ID_NOTIF_028"      VARCHAR2(50 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_028" IS 'Secuencia - clave primaria de la tabla 28';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_017_FASE" IS 'FK a tabla de Fases RERA';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_018_TRAMITE" IS 'FK a Tabla de Trmites RERA';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_024_NUM_EXP" IS 'FK a tabla de expedientes RERA';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_ACTU_028" IS 'Fecha de actualizacin del estado';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."USUA_028" IS 'Usuario de actualizacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_REG_SAL_028" IS 'Fecha de salida del registro';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."N_REG_SAL_028" IS 'Número de registro de salida';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_NOTIF_028" IS 'Fecha de Notificacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_EXPIR_028" IS 'Fecha de expiracin de la notificacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."F_TRAMITACION_028" IS 'Fecha de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_035_ESTADO" IS 'FK tabla 35 - Estado de la tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_PROV_024" IS 'Provincia del expediente';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_ANO_024" IS 'FK a Tabla de expedientes - Año';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."ID_NOTIF_028" IS 'Id de la notificacin';
   COMMENT ON COLUMN "AB03B"."AB03B28T00"."OBSERVACIONES_028" IS 'Observaciones
';
   COMMENT ON TABLE "AB03B"."AB03B28T00"  IS 'Historial de Tramitacin de un expediente RERA';
 /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B23T00" 
   (	"ID_023" NUMBER(8,0), 
	"ID_022_TIPO_PLAN" NUMBER(8,0), 
	"NUMANO_023" NUMBER(4,0), 
	"FLECTURA_023" DATE, 
	"JMSID_023" VARCHAR2(64 BYTE), 
	"NUMREG_023" VARCHAR2(32 BYTE), 
	"FREGISTRO_023" DATE, 
	"MENSAJE_023" CLOB, 
	"ID_017_FASE" NUMBER(8,0), 
	"ID_018_TRAMITE" NUMBER(8,0), 
	"REMITENTE_NOM_023" VARCHAR2(250 BYTE), 
	"SITUACION_023" VARCHAR2(1 BYTE), 
	"REMITENTE_ID_023" VARCHAR2(16 BYTE), 
	"ID_024_EXP" NUMBER(4,0), 
	"ID_PROV_024" VARCHAR2(2 BYTE), 
	"ID_ANO_024" NUMBER(4,0), 
	"ID_028_TRAM" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" 
 LOB ("MENSAJE_023") STORE AS BASICFILE (
  TABLESPACE "AB0301E00" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
  NOCACHE LOGGING 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)) ;

   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_023" IS 'PK de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_022_TIPO_PLAN" IS 'Codigo de tipo de solicitud RERA';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."NUMANO_023" IS 'Año de la peticion';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."FLECTURA_023" IS 'Fecha de lectura';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."JMSID_023" IS 'JMS ID';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."NUMREG_023" IS 'Numero de Registro de Entrada';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."FREGISTRO_023" IS 'Fecha de registro de la solicitud';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."MENSAJE_023" IS 'Mensaje completo enviado.';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_017_FASE" IS 'FK a Fase RERA';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_018_TRAMITE" IS 'FK a Trmite RERA ';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."REMITENTE_NOM_023" IS 'Remitente';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."SITUACION_023" IS 'Situacin de la Solicitud RERA:   P: Aceptada V: volcado a AB03B';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."REMITENTE_ID_023" IS 'ID del Remitente';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_024_EXP" IS 'FK a tabla 24 - Id del expediente RERA Relacionado';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_PROV_024" IS 'FK a tabla 24 - Provincia del expediente RERA Relacionado';
   COMMENT ON COLUMN "AB03B"."AB03B23T00"."ID_028_TRAM" IS 'FK tabla historial de tramitacin';
   COMMENT ON TABLE "AB03B"."AB03B23T00"  IS 'Tabla repositorio para las entradas Telemticas de RERA';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B25T00" 
   (	"ID_025" NUMBER(8,0), 
	"ID_017_FASE" NUMBER(8,0), 
	"ID_018_TRAMITE" NUMBER(8,0), 
	"ID_022_TIPO_PLAN" NUMBER(8,0), 
	"DESC_ES_025" VARCHAR2(600 BYTE), 
	"DESC_EU_025" VARCHAR2(600 BYTE), 
	"ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_025" IS 'Clave primaria';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_017_FASE" IS 'FK a Tabla de Fases RERA';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_018_TRAMITE" IS 'FK a Tabla de Trmites RERA';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_022_TIPO_PLAN" IS 'FK a Tipos de solicitud RERA';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."DESC_ES_025" IS 'Descripcin Castellano del Documento RERA';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."DESC_EU_025" IS 'Descripcin Euskera del Documento RERA';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_007_TP_DOC_DOKUSI" IS 'Tipo de Documento de dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B25T00"."ID_007_ST_DOC_DOKUSI" IS 'SubTipo de Documento de Dokusi';
   COMMENT ON TABLE "AB03B"."AB03B25T00"  IS 'Tipos de documentos de entrada RERA';
  /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B26T00" 
   (	"ID_026" NUMBER(8,0), 
	"DESC_ES_026" VARCHAR2(150 BYTE), 
	"DESC_EU_026" VARCHAR2(150 BYTE), 
	"ID_023_CODJMS" NUMBER(8,0), 
	"META_INF_026" VARCHAR2(640 BYTE), 
	"ID_025_DOC_SOL" NUMBER(8,0), 
	"OID_026" VARCHAR2(100 BYTE), 
	"ORG_DOC_ENTREGADO_026" VARCHAR2(640 BYTE), 
	"NOM_DOC_ENTREGADO_026" VARCHAR2(640 BYTE), 
	"FEC_DOC_ENTREGADO_026" DATE, 
	"TIPO_APORTACION_026" VARCHAR2(6 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_026" IS 'OID del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."DESC_ES_026" IS 'Descripcin en castellano';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."DESC_EU_026" IS 'Descripcin en Euskera';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_023_CODJMS" IS 'FK a la tabla 023 (Codigo de Solicitud Telemtica JMS RERA)';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."META_INF_026" IS 'Metainformacin del documento';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."ID_025_DOC_SOL" IS 'FK a la tabla 025: ID del documento de solicitudes RERA';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."OID_026" IS 'OID de dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."ORG_DOC_ENTREGADO_026" IS 'Organismo de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."NOM_DOC_ENTREGADO_026" IS 'Nombre del Documento entregado';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."FEC_DOC_ENTREGADO_026" IS 'Fecha de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B26T00"."TIPO_APORTACION_026" IS 'Tipo de aportacin del documento: A- Adjuntado; E- Entregado';
   COMMENT ON TABLE "AB03B"."AB03B26T00"  IS 'Tabla de OIDs Dokusi de entrada Telemtica RERA';
  /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B27T00" 
   (	"ID_027" NUMBER(8,0), 
	"ID_017_FASE" NUMBER(8,0), 
	"ID_018_TRAMITE" NUMBER(8,0), 
	"DESC_ES_027" VARCHAR2(400 BYTE), 
	"DESC_EU_027" VARCHAR2(400 BYTE), 
	"ID_021_PLANTILLA" NUMBER(8,0), 
	"ID_007_TP_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_007_ST_DOC_DOKUSI" VARCHAR2(100 BYTE), 
	"ID_022_TIPO_PLAN" NUMBER(8,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_027" IS 'PK Secuencia de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_017_FASE" IS 'FK a Tabla de Fases';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_018_TRAMITE" IS 'FK a Tabla de Trmites ';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."DESC_ES_027" IS 'Descripcin Castellano del Documento';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."DESC_EU_027" IS 'Descripcin Euskera del Documento ';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_021_PLANTILLA" IS 'FK a tabla 27: ID de la plantilla RERA';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_007_TP_DOC_DOKUSI" IS 'Tipo de Documento de Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_007_ST_DOC_DOKUSI" IS 'SubTipo de Docuento de Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B27T00"."ID_022_TIPO_PLAN" IS 'FK a tabla 22: Tipos de solicitud';
   COMMENT ON TABLE "AB03B"."AB03B27T00"  IS 'Tabla de Tipos de Documentos generados RERA';
  /*****************************************************************************************************/
  
  CREATE TABLE "AB03B"."AB03B37T00" 
   (	"ID_037" NUMBER(8,0), 
	"ID_018_TRAMITE" NUMBER(8,0), 
	"ID_017_FASE" NUMBER(8,0), 
	"DELEGACION_037" VARCHAR2(2 BYTE), 
	"FLAG_VB_037" VARCHAR2(1 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B37T00"."ID_037" IS 'Secuencia - Clave primaria de tabla AB03B37T00';
   COMMENT ON COLUMN "AB03B"."AB03B37T00"."ID_018_TRAMITE" IS 'FK trmites';
   COMMENT ON COLUMN "AB03B"."AB03B37T00"."ID_017_FASE" IS 'FK fases';
   COMMENT ON COLUMN "AB03B"."AB03B37T00"."DELEGACION_037" IS 'Id de la delegacin´ ';
   COMMENT ON COLUMN "AB03B"."AB03B37T00"."FLAG_VB_037" IS 'Flag del visto bueno: 0-Sin visto bueno; 1-Con visto bueno ';
   COMMENT ON TABLE "AB03B"."AB03B37T00"  IS 'Tabla de flags para visto bueno por trmite y delegacin RERA';
 /*****************************************************************************************************/
 
 CREATE TABLE "AB03B"."AB03B29T00" 
   (	"ID_029" NUMBER(8,0), 
	"ID_024_NUM_EXP" NUMBER(8,0), 
	"ID_027_TIPO_DOC_G" NUMBER(8,0), 
	"ID_028_HISTO_TRAM" NUMBER(8,0), 
	"ID_PIF_029" VARCHAR2(128 BYTE), 
	"OID_029" VARCHAR2(20 BYTE), 
	"ID_PROV_024" VARCHAR2(2 CHAR), 
	"OBSERVACIONES_ES_029" VARCHAR2(500 BYTE), 
	"OBSERVACIONES_EU_029" VARCHAR2(500 BYTE), 
	"ORG_DOC_ENTREGADO_029" VARCHAR2(640 BYTE), 
	"NOM_DOC_ENTREGADO_029" VARCHAR2(640 BYTE), 
	"FEC_DOC_ENTREGADO_029" DATE, 
	"TIPO_APORTACION_029" VARCHAR2(6 BYTE), 
	"ID_025_DOCENTRADA" NUMBER(8,0), 
	"ID_ANO_024" NUMBER(4,0), 
	"ID_004_FIRMANTE" NUMBER(8,0),
	"AUDITUSER_029"  VARCHAR2(100 BYTE),
	"MOTIVO_RECHAZO_029"       VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_029" IS 'PF Secuencial de la tabla';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_024_NUM_EXP" IS 'FK a Tabla de Expedientes RERA';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_027_TIPO_DOC_G" IS 'FK a Tipos de Documentacin Generada RERA';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_028_HISTO_TRAM" IS 'FK a Historial de Tramitacin RERA';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_PIF_029" IS 'Identificador del Documeto en PIF';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."OID_029" IS 'OID del Documento en Dokusi';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_PROV_024" IS 'FK a Tabla de Expedientes RERA - provincia';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."OBSERVACIONES_ES_029" IS 'Observaciones castellano';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."OBSERVACIONES_EU_029" IS 'Observaciones euskera';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ORG_DOC_ENTREGADO_029" IS 'Organismo de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."NOM_DOC_ENTREGADO_029" IS 'Nombre del Documento entregado';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."FEC_DOC_ENTREGADO_029" IS 'Fecha de entrega del documento';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."TIPO_APORTACION_029" IS 'Tipo de aportacin del documento: A- Adjuntado; E- Entregado';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_025_DOCENTRADA" IS 'FK a tabla 25 - Tipo Documentos de Entrada';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_ANO_024" IS 'FK a Tabla de expedientes - Año';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."ID_004_FIRMANTE" IS 'FK a tabla 4 firmantes';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."AUDITUSER_029" IS 'Usuario que manda el documento para convertirlo a PDF';
   COMMENT ON COLUMN "AB03B"."AB03B29T00"."MOTIVO_RECHAZO_029" IS 'Motivo de rechazo de la firma';   
   COMMENT ON TABLE "AB03B"."AB03B29T00"  IS 'Documentacin de expedientes RERA';
 /*****************************************************************************************************/
  CREATE TABLE "AB03B"."AB03B31T00" 
   (	"ID_031" NUMBER(8,0), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"ESTADO_031" VARCHAR2(1 CHAR) DEFAULT '0', 
	"F_CAMBIO_ESTADO_031" DATE, 
	"NUM_RERA_031" VARCHAR2(20 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B31T00"."ID_031" IS 'Secuencia - Clave primaria de tabla AB03B31T00';
   COMMENT ON COLUMN "AB03B"."AB03B31T00"."ID_047_EMPRESA" IS 'FK a tabla de empresas';
   COMMENT ON COLUMN "AB03B"."AB03B31T00"."ESTADO_031" IS 'Estado de la empresa en RERA: 0-Alta 1-Baja ';
   COMMENT ON COLUMN "AB03B"."AB03B31T00"."F_CAMBIO_ESTADO_031" IS 'Fecha del cambio de estado alta/baja';
   COMMENT ON TABLE "AB03B"."AB03B31T00"  IS 'Tabla de Histrico de altas/bajas de una empresa en RERA';
 /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B48T00" 
   (	"ID_048" NUMBER(8,0), 
	"DESC_ES_048" VARCHAR2(150 BYTE), 
	"DESC_EU_048" VARCHAR2(150 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B48T00"."ID_048" IS 'Secuencia - Clave primaria de la tabla 48';
   COMMENT ON COLUMN "AB03B"."AB03B48T00"."DESC_ES_048" IS 'Descripcion castellano de Tipo de organismo';
   COMMENT ON COLUMN "AB03B"."AB03B48T00"."DESC_EU_048" IS 'Descripcion euskera de Tipo de organismo';
   COMMENT ON TABLE "AB03B"."AB03B48T00"  IS 'Tabla de Tipos de Organismo RERA';
 /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B49T00" 
   (	"ID_049" NUMBER(2,0), 
	"TERRITORIO_049" VARCHAR2(2 BYTE), 
	"CALLE_049" VARCHAR2(250 BYTE), 
	"NUMERO_049" VARCHAR2(150 BYTE), 
	"PISO_049" VARCHAR2(150 BYTE), 
	"LETRA_049" VARCHAR2(25 BYTE), 
	"COD_POSTAL_049" VARCHAR2(10 BYTE), 
	"MUNICIPIO_049" VARCHAR2(10 BYTE), 
	"TELEFONO_049" VARCHAR2(50 BYTE), 
	"FAX_049" VARCHAR2(50 BYTE), 
	"DESC_ES_049" VARCHAR2(250 BYTE), 
	"DESC_EU_049" VARCHAR2(250 BYTE), 
	"ID_048_ORG" NUMBER(8,0), 
	"REG_MANUAL_049" VARCHAR2(1 CHAR), 
	"EMAIL_049" VARCHAR2(100 BYTE),
	"ID_PERFIL_049" VARCHAR2(3 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B49T00"."ID_049" IS 'Secuencia - Clave primaria de tabla AB03B49T00';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."TERRITORIO_049" IS 'FK a tabla de provincias NORA';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."CALLE_049" IS 'Direccin del organismo - Calle';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."NUMERO_049" IS 'Direccin del organismo - Número';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."PISO_049" IS 'Direccin del organismo - Piso';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."LETRA_049" IS 'Direccin del organismo - Letra';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."COD_POSTAL_049" IS 'Direccin del organismo - Cdigo postal';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."MUNICIPIO_049" IS 'Direccin del organismo - Municipio';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."TELEFONO_049" IS 'Número de telfono';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."FAX_049" IS 'Número de fax';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."DESC_ES_049" IS 'Descripcin en castellano';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."DESC_EU_049" IS 'Descripcin en euskera';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."ID_048_ORG" IS 'FK a tabla 48 -  Tipos de organismo RERA';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."REG_MANUAL_049" IS 'Registro manual: 0- automtico; 1- manual';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."EMAIL_049" IS 'Direccin de email';
   COMMENT ON COLUMN "AB03B"."AB03B49T00"."ID_PERFIL_049" IS 'Id del perfil de usuario';
   COMMENT ON TABLE "AB03B"."AB03B49T00"  IS 'Tabla de organismos RERA';
  
 /*****************************************************************************************************/
 CREATE TABLE "AB03B"."AB03B50T00" 
   (	"ID_050" NUMBER(8,0), 
	"ID_028_HISTO_TRAM" NUMBER(8,0), 
	"ID_049_ORGAN" NUMBER(8,0), 
	"ESTADO_050" VARCHAR2(1 CHAR), 
	"ID_047_EMPRESA" NUMBER(8,0), 
	"FEC_COMUNIC_050" DATE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B50T00"."ID_050" IS 'Secuencia - Clave primaria de tabla AB03B50T00';
   COMMENT ON COLUMN "AB03B"."AB03B50T00"."ID_028_HISTO_TRAM" IS 'FK a Tabla de historial de tramitacin';
   COMMENT ON COLUMN "AB03B"."AB03B50T00"."ID_049_ORGAN" IS 'FK tabla de organismos ';
   COMMENT ON COLUMN "AB03B"."AB03B50T00"."ESTADO_050" IS 'Estado de la comunicacion: 0- No enviado; 1- Enviado; 2- Con error ';
   COMMENT ON TABLE "AB03B"."AB03B50T00"  IS 'Tabla de comunicaciones RERA';
/*****************************************************************************************************/

CREATE TABLE "AB03B"."AB03B51T00" 
   (	"ID_051" NUMBER(8,0), 
	"ID_010_EXP" NUMBER(8,0), 
	"ID_ANO_010" NUMBER(4,0), 
	"ID_PROV_010" VARCHAR2(2 BYTE), 
	"TIPO_051" VARCHAR2(1 BYTE), 
	"VALOR_051" VARCHAR2(100 BYTE)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B51T00"."ID_051" IS 'Secuencia - Clave primaria de tabla AB03B51T00';
   COMMENT ON COLUMN "AB03B"."AB03B51T00"."ID_010_EXP" IS 'FK a Tabla de expedientes - ID';
   COMMENT ON COLUMN "AB03B"."AB03B51T00"."ID_ANO_010" IS 'FK tabla de expedientes - año';
   COMMENT ON COLUMN "AB03B"."AB03B51T00"."ID_PROV_010" IS 'FK tabla de expedientes - provincia';
   COMMENT ON COLUMN "AB03B"."AB03B51T00"."TIPO_051" IS 'Tipo del canal de aviso: S-SMS, E- Email';
   COMMENT ON COLUMN "AB03B"."AB03B51T00"."VALOR_051" IS 'Canal de aviso (número de telfono o direccin de email)';
   COMMENT ON TABLE "AB03B"."AB03B51T00"  IS 'Tabla de canales de aviso';
/*****************************************************************************************************/

 CREATE TABLE "AB03B"."AB03B52T00" 
   (	"ID_052" NUMBER(8,0), 
	"ID_024_NUM_EXP" NUMBER(8,0), 
	"ID_PROV_024" VARCHAR2(2 BYTE), 
	"TIPO_052" VARCHAR2(1 BYTE), 
	"VALOR_052" VARCHAR2(100 BYTE), 
	"ID_ANO_024" NUMBER(4,0)
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 
 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

   COMMENT ON COLUMN "AB03B"."AB03B52T00"."ID_052" IS 'Secuencia - Clave primaria de tabla AB03B51T00';
   COMMENT ON COLUMN "AB03B"."AB03B52T00"."ID_024_NUM_EXP" IS 'FK a Tabla de expedientes RERA- ID';
   COMMENT ON COLUMN "AB03B"."AB03B52T00"."ID_PROV_024" IS 'FK tabla de expedientes RERA - provincia';
   COMMENT ON COLUMN "AB03B"."AB03B52T00"."TIPO_052" IS 'Tipo del canal de aviso: S-SMS, E- Email';
   COMMENT ON COLUMN "AB03B"."AB03B52T00"."VALOR_052" IS 'Canal de aviso (número de telfono o direccin de email)';
   COMMENT ON COLUMN "AB03B"."AB03B52T00"."ID_ANO_024" IS 'FK a Tabla de expedientes - Año';
   COMMENT ON TABLE "AB03B"."AB03B52T00"  IS 'Tabla de canales de aviso RERA';

/*****************************************************************************************************/
  
  CREATE TABLE "AB03B"."AB03B60T00"
  (
    "ID_060"            NUMBER(8,0) NOT NULL ENABLE,
    "ID_010_NUM_EXP"        NUMBER(8,0),
    "ID_PROV_010"       VARCHAR2(2 BYTE),
	"ID_ANO_010"     NUMBER(4,0),
	"REQUER_060"	 NUMBER(1,0) DEFAULT 0,
	"RESOL_060"      NUMBER(1,0) DEFAULT 0,
	"DESIS_060"      NUMBER(1,0) DEFAULT 0,
	"RECAL_060"      NUMBER(1,0) DEFAULT 0,
	"AP_OSAL_060"      NUMBER(1,0) DEFAULT 0,
	"AP_INSP_060"      NUMBER(1,0) DEFAULT 0
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
/*****************************************************************************************************/

 CREATE TABLE "AB03B"."AB03B61T00"
  (
    "ID_061"         NUMBER(8,0) NOT NULL ENABLE,
    "ID_024_NUM_EXP" NUMBER(8,0),
    "ID_PROV_024"    VARCHAR2(2 BYTE),
    "ID_ANO_024"     NUMBER(4,0),
    "REQUER_061"     NUMBER(1,0) DEFAULT 0,
    "JUSTIF_061"      NUMBER(1,0) DEFAULT 0,
    "BAJA_061"      NUMBER(1,0) DEFAULT 0
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ; 
 /*****************************************************************************************************/ 
  CREATE TABLE "AB03B"."AB03B62T00"
  (
    "ID_062"         NUMBER(8,0) NOT NULL ENABLE,
    "ID_011_TP_DOC" NUMBER(8,0),
    "ID_015_DOC"    NUMBER(8,0)
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
 /*****************************************************************************************************/
  
  CREATE TABLE "AB03B"."AB03B63T00"
  (
	"ID_063"         NUMBER(8,0) NOT NULL ENABLE,
	"ID_033_TRABEXP"         NUMBER(8,0) NOT NULL ,
    "ID_056_DATEJEC"         NUMBER(8,0)NOT NULL
  )
  SEGMENT CREATION IMMEDIATE PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING STORAGE
  (
    INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645 PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT
  )
  TABLESPACE "AB0301E00" ;
 /*****************************************************************************************************/ 
   CREATE TABLE AB03B.AB03B66T00
   (	"ID_066" NUMBER(8,0) NOT NULL ENABLE, 
	"ID_PROV_066" VARCHAR2(2 BYTE) NOT NULL ENABLE, 
	"ID_ANYO_066" NUMBER(4,0) NOT NULL ENABLE, 
	"ID_EXP_066" NUMBER(8,0) NOT NULL ENABLE, 
	"ID_TIPO_066" NUMBER(1,0) NOT NULL ENABLE,
	"ERROR_066" VARCHAR2(500 BYTE), 
	"FECHA_066" TIMESTAMP (6), 
	 CONSTRAINT "PK_AB03B66T00" PRIMARY KEY ("ID_066")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE
   ) SEGMENT CREATION IMMEDIATE 
  PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
  
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ID_066" IS 'Id';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ID_PROV_066" IS 'Provincia del expediente';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ID_ANYO_066" IS 'Anio del expediente';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ID_EXP_066" IS 'Id expediente';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ID_TIPO_066" IS 'PF Secuencial de la tabla. 0-Amianto, 1-RERA';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."ERROR_066" IS 'Descripcion del error';
  COMMENT ON COLUMN "AB03B"."AB03B66T00"."FECHA_066" IS 'Fecha del error';
  /*****************************************************************************************************/
  CREATE UNIQUE INDEX "AB03B"."PK_AB03BT001" ON "AB03B"."AB03B01T00" ("ID_001") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B02T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B02T00" ON "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B03T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B03T00" ON "AB03B"."AB03B03T00" ("ID_003") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B04T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B04T00" ON "AB03B"."AB03B04T00" ("ID_004") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B05T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B05T00" ON "AB03B"."AB03B05T00" ("ID_005") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B06T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B06T00" ON "AB03B"."AB03B06T00" ("ID_006") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B07T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B07T00" ON "AB03B"."AB03B07T00" ("ID_007") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B08T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B08T00" ON "AB03B"."AB03B08T00" ("ID_008") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B09T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B09T00" ON "AB03B"."AB03B09T00" ("ID_009") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B10T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B10T00" ON "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B11T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B11T00" ON "AB03B"."AB03B11T00" ("ID_011") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B12T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B12T00" ON "AB03B"."AB03B12T00" ("ID_012") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B13T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B13T00" ON "AB03B"."AB03B13T00" ("ID_013") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B14T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B14T00" ON "AB03B"."AB03B14T00" ("ID_014") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B15T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B15T00" ON "AB03B"."AB03B15T00" ("ID_015") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B16T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B16T00" ON "AB03B"."AB03B16T00" ("ID_016") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03BT017
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03BT017" ON "AB03B"."AB03B17T00" ("ID_017") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B18T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B18T00" ON "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B21T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B21T00" ON "AB03B"."AB03B21T00" ("ID_021") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B22T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B22T00" ON "AB03B"."AB03B22T00" ("ID_022") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B23T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B23T00" ON "AB03B"."AB03B23T00" ("ID_023") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B24T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B24T00" ON "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B25T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B25T00" ON "AB03B"."AB03B25T00" ("ID_025") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B26T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B26T00" ON "AB03B"."AB03B26T00" ("ID_026") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B27T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B27T00" ON "AB03B"."AB03B27T00" ("ID_027") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B28T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B28T00" ON "AB03B"."AB03B28T00" ("ID_028") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B29T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B29T00" ON "AB03B"."AB03B29T00" ("ID_029") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B30T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B30T00" ON "AB03B"."AB03B30T00" ("ID_030") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B31T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B31T00" ON "AB03B"."AB03B31T00" ("ID_031") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B32T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B32T00" ON "AB03B"."AB03B32T00" ("ID_032") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B33T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B33T00" ON "AB03B"."AB03B33T00" ("ID_033") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B34T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B34T00" ON "AB03B"."AB03B34T00" ("ID_034") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B35T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B35T00" ON "AB03B"."AB03B35T00" ("ID_035") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B36T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B36T00" ON "AB03B"."AB03B36T00" ("ID_036") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B37T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B37T00" ON "AB03B"."AB03B37T00" ("ID_037") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B39T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B39T00" ON "AB03B"."AB03B39T00" ("ID_039") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B40T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B40T00" ON "AB03B"."AB03B40T00" ("ID_040") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B41T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B41T00" ON "AB03B"."AB03B41T00" ("ID_041") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B42T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B42T00" ON "AB03B"."AB03B42T00" ("ID_042") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B44T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B44T00" ON "AB03B"."AB03B44T00" ("ID_044") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B45T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B45T00" ON "AB03B"."AB03B45T00" ("ID_045") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B46T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B46T00" ON "AB03B"."AB03B46T00" ("ID_046") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B47T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B47T00" ON "AB03B"."AB03B47T00" ("ID_047") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B48T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B48T00" ON "AB03B"."AB03B48T00" ("ID_048") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B49T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B49T00" ON "AB03B"."AB03B49T00" ("ID_049") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B50T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B50T00" ON "AB03B"."AB03B50T00" ("ID_050") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B51T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B51T00" ON "AB03B"."AB03B51T00" ("ID_051") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B52T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B52T00" ON "AB03B"."AB03B52T00" ("ID_052") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B53T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B53T00" ON "AB03B"."AB03B53T00" ("ID_053") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B54T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B54T00" ON "AB03B"."AB03B54T00" ("ID_054") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B55T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B55T00" ON "AB03B"."AB03B55T00" ("ID_055") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B56T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B56T00" ON "AB03B"."AB03B56T00" ("ID_056") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B57T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B57T00" ON "AB03B"."AB03B57T00" ("ID_057") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B58T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B58T00" ON "AB03B"."AB03B58T00" ("ID_058") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
--------------------------------------------------------
--  DDL for Index PK_AB03B59T00
--------------------------------------------------------

  CREATE UNIQUE INDEX "AB03B"."PK_AB03B59T00" ON "AB03B"."AB03B59T00" ("ID_059")
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
   
--------------------------------------------------------
--  DDL for Index PK_AB03B60T00
--------------------------------------------------------  
  CREATE UNIQUE INDEX "AB03B"."PK_AB03B60T00" ON "AB03B"."AB03B60T00" ("ID_060") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;

--------------------------------------------------------
--  DDL for Index PK_AB03B61T00
--------------------------------------------------------
  CREATE UNIQUE INDEX "AB03B"."PK_AB03B61T00" ON "AB03B"."AB03B61T00" ("ID_061") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
 
 --------------------------------------------------------
--  DDL for Index PK_AB03B62T00
--------------------------------------------------------
  CREATE UNIQUE INDEX "AB03B"."PK_AB03B62T00" ON "AB03B"."AB03B62T00" ("ID_062") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
    
----------------------------------------------------------
--  DDL for Index PK_AB03B62T00
--------------------------------------------------------
  CREATE UNIQUE INDEX "AB03B"."PK_AB03B63T00" ON "AB03B"."AB03B63T00" ("ID_063") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00" ;
  
--------------------------------------------------------
--  Constraints for Table AB03B01T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B01T00" ADD CONSTRAINT "PK_AB03BT001" PRIMARY KEY ("ID_001")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B01T00" ADD CONSTRAINT "SYS_C0066113" CHECK ("ID_001" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B01T00" MODIFY ("ID_001" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B02T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B02T00" ADD CONSTRAINT "PK_AB03B02T00" PRIMARY KEY ("ID_001_FASE", "ID_002")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B02T00" MODIFY ("ID_001_FASE" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B02T00" MODIFY ("ID_002" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B03T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B03T00" MODIFY ("ID_003" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B03T00" ADD CONSTRAINT "PK_AB03B03T00" PRIMARY KEY ("ID_003")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B04T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B04T00" MODIFY ("ID_004" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B04T00" MODIFY ("ID_003_CARGO" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B04T00" ADD CONSTRAINT "PK_AB03B04T00" PRIMARY KEY ("ID_004")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B05T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B05T00" MODIFY ("ID_005" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B05T00" ADD CONSTRAINT "SYS_C0066001" CHECK ("ID_005" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B05T00" ADD CONSTRAINT "PK_AB03B05T00" PRIMARY KEY ("ID_005")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B06T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B06T00" MODIFY ("ID_006" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B06T00" ADD CONSTRAINT "PK_AB03B06T00" PRIMARY KEY ("ID_006")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B07T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B07T00" MODIFY ("ID_007" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B07T00" ADD CONSTRAINT "PK_AB03B07T00" PRIMARY KEY ("ID_007")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B08T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B08T00" ADD CONSTRAINT "PK_AB03B08T00" PRIMARY KEY ("ID_008")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B08T00" ADD CONSTRAINT "SYS_C0065971" CHECK ("ID_008" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B08T00" MODIFY ("ID_008" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B09T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B09T00" MODIFY ("ID_009" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B09T00" ADD CONSTRAINT "PK_AB03B09T00" PRIMARY KEY ("ID_009")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B10T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "PK_AB03B10T00" PRIMARY KEY ("ID_ANO_010", "ID_010", "ID_PROV_010")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "SYS_C0066005" CHECK ("ID_010" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" MODIFY ("ID_PROV_010" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B10T00" MODIFY ("ID_ANO_010" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B10T00" MODIFY ("ID_010" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B11T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B11T00" MODIFY ("ID_011" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B11T00" MODIFY ("DESC_ES_011" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B11T00" MODIFY ("DESC_EU_011" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "SYS_C0066019" CHECK ("ID_011" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "PK_AB03B11T00" PRIMARY KEY ("ID_011")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B12T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B12T00" ADD CONSTRAINT "PK_AB03B12T00" PRIMARY KEY ("ID_012")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B13T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B13T00" MODIFY ("ID_013" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B13T00" ADD CONSTRAINT "PK_AB03B13T00" PRIMARY KEY ("ID_013")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B14T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B14T00" ADD CONSTRAINT "PK_AB03B14T00" PRIMARY KEY ("ID_014")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B14T00" MODIFY ("ID_014" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B15T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B15T00" MODIFY ("ID_015" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "PK_AB03B15T00" PRIMARY KEY ("ID_015")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B16T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B16T00" MODIFY ("ID_016" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B16T00" ADD CONSTRAINT "SYS_C0065977" CHECK ("F_ACTU_016" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B16T00" ADD CONSTRAINT "SYS_C0065974" CHECK ("ID_016"     IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B16T00" ADD CONSTRAINT "PK_AB03B16T00" PRIMARY KEY ("ID_016")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B17T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B17T00" MODIFY ("ID_017" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B17T00" ADD CONSTRAINT "SYS_C0066115" CHECK ("ID_017" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B17T00" ADD CONSTRAINT "PK_AB03BT017" PRIMARY KEY ("ID_017")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B18T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B18T00" MODIFY ("ID_018" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B18T00" MODIFY ("ID_017_FASE" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B18T00" ADD CONSTRAINT "PK_AB03B18T00" PRIMARY KEY ("ID_017_FASE", "ID_018")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B21T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B21T00" MODIFY ("ID_021" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B21T00" ADD CONSTRAINT "SYS_C0066315" CHECK ("ID_021" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B21T00" ADD CONSTRAINT "PK_AB03B21T00" PRIMARY KEY ("ID_021")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B22T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B22T00" MODIFY ("ID_022" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B22T00" ADD CONSTRAINT "SYS_C0066316" CHECK ("ID_022" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B22T00" ADD CONSTRAINT "PK_AB03B22T00" PRIMARY KEY ("ID_022")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B23T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B23T00" MODIFY ("ID_023" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B23T00" ADD CONSTRAINT "PK_AB03B23T00" PRIMARY KEY ("ID_023")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B24T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B24T00" MODIFY ("ID_ANO_024" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B24T00" ADD CONSTRAINT "PK_AB03B24T00" PRIMARY KEY ("ID_024", "ID_PROV_024", "ID_ANO_024")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B24T00" MODIFY ("ID_024" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B24T00" MODIFY ("ID_PROV_024" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B24T00" ADD CONSTRAINT "SYS_C0066317" CHECK ("ID_024" IS NOT NULL) ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B25T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B25T00" MODIFY ("ID_025" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B25T00" MODIFY ("DESC_ES_025" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B25T00" MODIFY ("DESC_EU_025" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "SYS_C0066318" CHECK ("ID_025" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "PK_AB03B25T00" PRIMARY KEY ("ID_025")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B26T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B26T00" ADD CONSTRAINT "PK_AB03B26T00" PRIMARY KEY ("ID_026")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B27T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B27T00" MODIFY ("ID_027" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B27T00" ADD CONSTRAINT "PK_AB03B27T00" PRIMARY KEY ("ID_027")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B28T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B28T00" MODIFY ("ID_028" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B28T00" ADD CONSTRAINT "PK_AB03B28T00" PRIMARY KEY ("ID_028")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B29T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B29T00" MODIFY ("ID_029" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "PK_AB03B29T00" PRIMARY KEY ("ID_029")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B30T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B30T00" MODIFY ("ID_030" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B30T00" ADD CONSTRAINT "SYS_C0066319" CHECK ("F_ACTU_030" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B30T00" ADD CONSTRAINT "SYS_C0066320" CHECK ("ID_030"     IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B30T00" ADD CONSTRAINT "PK_AB03B30T00" PRIMARY KEY ("ID_030")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B31T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B31T00" MODIFY ("ID_031" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B31T00" ADD CONSTRAINT "SYS_C0066321" CHECK ("ID_031" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B31T00" ADD CONSTRAINT "PK_AB03B31T00" PRIMARY KEY ("ID_031")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 131072 NEXT 131072 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B32T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B32T00" MODIFY ("ID_032" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B32T00" ADD CONSTRAINT "SYS_C0066322" CHECK ("ID_032" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B32T00" ADD CONSTRAINT "PK_AB03B32T00" PRIMARY KEY ("ID_032")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B33T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B33T00" MODIFY ("ID_033" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B33T00" ADD CONSTRAINT "SYS_C0066332" CHECK ("ID_033" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B33T00" ADD CONSTRAINT "PK_AB03B33T00" PRIMARY KEY ("ID_033")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B34T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B34T00" ADD CONSTRAINT "PK_AB03B34T00" PRIMARY KEY ("ID_034")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B34T00" ADD CONSTRAINT "SYS_C0066333" CHECK ("ID_034" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B34T00" MODIFY ("ID_034" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B35T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B35T00" MODIFY ("ID_035" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B35T00" ADD CONSTRAINT "SYS_C0066334" CHECK ("ID_035" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B35T00" ADD CONSTRAINT "PK_AB03B35T00" PRIMARY KEY ("ID_035")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B36T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B36T00" MODIFY ("ID_036" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B36T00" ADD CONSTRAINT "SYS_C0066335" CHECK ("ID_036" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B36T00" ADD CONSTRAINT "PK_AB03B36T00" PRIMARY KEY ("ID_036")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B37T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B37T00" MODIFY ("ID_037" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B37T00" ADD CONSTRAINT "SYS_C0066336" CHECK ("ID_037" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B37T00" ADD CONSTRAINT "PK_AB03B37T00" PRIMARY KEY ("ID_037")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B39T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B39T00" MODIFY ("ID_039" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B39T00" ADD CONSTRAINT "SYS_C0066338" CHECK ("ID_039" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B39T00" ADD CONSTRAINT "PK_AB03B39T00" PRIMARY KEY ("ID_039")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B40T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B40T00" MODIFY ("ID_040" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B40T00" ADD CONSTRAINT "SYS_C0066340" CHECK ("ID_040" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B40T00" ADD CONSTRAINT "PK_AB03B40T00" PRIMARY KEY ("ID_040")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B41T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B41T00" ADD CONSTRAINT "PK_AB03B41T00" PRIMARY KEY ("ID_041")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B41T00" ADD CONSTRAINT "SYS_C0066341" CHECK ("ID_041" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B41T00" MODIFY ("ID_041" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B42T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B42T00" MODIFY ("ID_042" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B42T00" ADD CONSTRAINT "SYS_C0066342" CHECK ("ID_042" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B42T00" ADD CONSTRAINT "PK_AB03B42T00" PRIMARY KEY ("ID_042")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B44T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B44T00" ADD CONSTRAINT "PK_AB03B44T00" PRIMARY KEY ("ID_044")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B44T00" ADD CONSTRAINT "SYS_C0065987" CHECK ("ID_044"        IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B44T00" ADD CONSTRAINT "SYS_C0065988" CHECK ("ACTIVO_SN_044" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B44T00" MODIFY ("ID_044" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B45T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B45T00" MODIFY ("ID_045" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B45T00" ADD CONSTRAINT "SYS_C0065990" CHECK ("ID_045"        IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B45T00" ADD CONSTRAINT "PK_AB03B45T00" PRIMARY KEY ("ID_045")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B46T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B46T00" MODIFY ("ID_046" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B46T00" ADD CONSTRAINT "SYS_C0066346" CHECK ("ID_046" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B46T00" ADD CONSTRAINT "PK_AB03B46T00" PRIMARY KEY ("ID_046")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B47T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B47T00" ADD CONSTRAINT "PK_AB03B47T00" PRIMARY KEY ("ID_047")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B47T00" ADD CONSTRAINT "SYS_C0066347" CHECK ("ID_047" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B47T00" MODIFY ("ID_047" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B48T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B48T00" MODIFY ("ID_048" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B48T00" ADD CONSTRAINT "SYS_C0065991" CHECK ("ID_048"        IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B48T00" ADD CONSTRAINT "PK_AB03B48T00" PRIMARY KEY ("ID_048")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B49T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B49T00" MODIFY ("ID_049" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B49T00" ADD CONSTRAINT "SYS_C0066339" CHECK ("ID_049" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B49T00" ADD CONSTRAINT "PK_AB03B49T00" PRIMARY KEY ("ID_049")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B50T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B50T00" MODIFY ("ID_050" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B50T00" ADD CONSTRAINT "SYS_C0066350" CHECK ("ID_050" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B50T00" ADD CONSTRAINT "PK_AB03B50T00" PRIMARY KEY ("ID_050")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B51T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B51T00" MODIFY ("ID_051" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B51T00" ADD CONSTRAINT "SYS_C0066351" CHECK ("ID_051" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B51T00" ADD CONSTRAINT "PK_AB03B51T00" PRIMARY KEY ("ID_051")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B52T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B52T00" MODIFY ("ID_052" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B52T00" ADD CONSTRAINT "SYS_C0066352" CHECK ("ID_052" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B52T00" ADD CONSTRAINT "PK_AB03B52T00" PRIMARY KEY ("ID_052")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B53T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B53T00" ADD CONSTRAINT "PK_AB03B53T00" PRIMARY KEY ("ID_053")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B53T00" ADD CONSTRAINT "SYS_C0066353" CHECK ("ID_053" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B53T00" MODIFY ("ID_053" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B54T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B54T00" MODIFY ("ID_054" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B54T00" ADD CONSTRAINT "PK_AB03B54T00" PRIMARY KEY ("ID_054")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B54T00" ADD CONSTRAINT "SYS_C0066354" CHECK ("ID_054" IS NOT NULL) ENABLE;
--------------------------------------------------------
--  Constraints for Table AB03B55T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B55T00" ADD CONSTRAINT "PK_AB03B55T00" PRIMARY KEY ("ID_055")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B55T00" ADD CONSTRAINT "SYS_C0066355" CHECK ("ID_055" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B55T00" MODIFY ("ID_055" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B56T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "PK_AB03B56T00" PRIMARY KEY ("ID_056")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "SYS_C0066056" CHECK ("ID_056" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B56T00" MODIFY ("ID_056" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B57T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B57T00" ADD CONSTRAINT "PK_AB03B57T00" PRIMARY KEY ("ID_057")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B57T00" ADD CONSTRAINT "SYS_C0066057" CHECK ("ID_057" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B57T00" MODIFY ("ID_057" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B58T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B58T00" ADD CONSTRAINT "PK_AB03B58T00" PRIMARY KEY ("ID_058")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B58T00" ADD CONSTRAINT "SYS_C0066058" CHECK ("ID_058" IS NOT NULL) ENABLE;
  ALTER TABLE "AB03B"."AB03B58T00" MODIFY ("ID_058" NOT NULL ENABLE);
--------------------------------------------------------
--  Constraints for Table AB03B59T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B59T00" ADD CONSTRAINT "PK_AB03B59T00" PRIMARY KEY ("ID_059")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B59T00" MODIFY ("ID_053_TRABAJO" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B59T00" MODIFY ("ID_056_EJECUCION" NOT NULL ENABLE);
  ALTER TABLE "AB03B"."AB03B59T00" MODIFY ("ID_059" NOT NULL ENABLE);
  
--------------------------------------------------------
--  Constraints for Table AB03B60T00
--------------------------------------------------------  
  ALTER TABLE "AB03B"."AB03B60T00" ADD CONSTRAINT "PK_AB03B60T00" PRIMARY KEY ("ID_060")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B60T00" ADD CONSTRAINT "SYS_C0066360" CHECK ("ID_060" IS NOT NULL) ENABLE;
 
--------------------------------------------------------
--  Constraints for Table AB03B61T00
--------------------------------------------------------  
  ALTER TABLE "AB03B"."AB03B61T00" ADD CONSTRAINT "PK_AB03B61T00" PRIMARY KEY ("ID_061")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B61T00" ADD CONSTRAINT "SYS_C0066361" CHECK ("ID_061" IS NOT NULL) ENABLE;
 
 --------------------------------------------------------
--  Constraints for Table AB03B62T00
--------------------------------------------------------  
  ALTER TABLE "AB03B"."AB03B62T00" ADD CONSTRAINT "PK_AB03B62T00" PRIMARY KEY ("ID_062")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B62T00" ADD CONSTRAINT "SYS_C0066362" CHECK ("ID_062" IS NOT NULL) ENABLE;
     
  
  
   --------------------------------------------------------
--  Constraints for Table AB03B62T00
--------------------------------------------------------  
  ALTER TABLE "AB03B"."AB03B63T00" ADD CONSTRAINT "PK_AB03B63T00" PRIMARY KEY ("ID_063")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1
  BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "AB0301E00"  ENABLE;
  ALTER TABLE "AB03B"."AB03B63T00" ADD CONSTRAINT "SYS_C0066363" CHECK ("ID_063" IS NOT NULL) ENABLE;
     
  
--------------------------------------------------------
--  Ref Constraints for Table AB03B02T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B02T00" ADD CONSTRAINT "FK_AB03B02T00_AB03B01T00" FOREIGN KEY ("ID_001_FASE")
	  REFERENCES "AB03B"."AB03B01T00" ("ID_001") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B04T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B04T00" ADD CONSTRAINT "FK_AB03B04T00_AB03B03T00" FOREIGN KEY ("ID_003_CARGO")
	  REFERENCES "AB03B"."AB03B03T00" ("ID_003") ENABLE;
  ALTER TABLE "AB03B"."AB03B04T00" ADD CONSTRAINT "FK_AB03B04T00_AB03B44T00" FOREIGN KEY ("TIPO_DOC_044")
	  REFERENCES "AB03B"."AB03B44T00" ("ID_044") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B09T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B09T00" ADD CONSTRAINT "FK_AB03B09T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE", "ID_002_TRAMITE")
	  REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE;
  ALTER TABLE "AB03B"."AB03B09T00" ADD CONSTRAINT "FK_AB03B09T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE;
  ALTER TABLE "AB03B"."AB03B09T00" ADD CONSTRAINT "FK_AB03B09T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
  ALTER TABLE "AB03B"."AB03B09T00" ADD CONSTRAINT "FK_AB03B09T00_AB03B14T00" FOREIGN KEY ("ID_014_TRAM")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B10T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "FK_AB03B10T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "FK_AB03B10T00_AB03B41T00" FOREIGN KEY ("ID_041_MATERIAL")
	  REFERENCES "AB03B"."AB03B41T00" ("ID_041") ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "FK_AB03B10T00_AB03B44T00" FOREIGN KEY ("TIPO_DOC_044")
	  REFERENCES "AB03B"."AB03B44T00" ("ID_044") ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "FK_AB03B10T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
  ALTER TABLE "AB03B"."AB03B10T00" ADD CONSTRAINT "FK_AB03B10T00_AB03B54T00" FOREIGN KEY ("ID_054_ACTIV")
	  REFERENCES "AB03B"."AB03B54T00" ("ID_054") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B11T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "FK_AB03B11T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE", "ID_002_TRAMITE")
	  REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE;
  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "FK_AB03B11T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "FK_AB03B11T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B11T00" ADD CONSTRAINT "FK_AB03B11T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B12T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B12T00" ADD CONSTRAINT "FK_AB03B12T00_AB03B09T00" FOREIGN KEY ("ID_009_CODJMS")
	  REFERENCES "AB03B"."AB03B09T00" ("ID_009") ENABLE;
  ALTER TABLE "AB03B"."AB03B12T00" ADD CONSTRAINT "FK_AB03B12T00_AB03B11T00" FOREIGN KEY ("ID_011_DOC_SOL")
	  REFERENCES "AB03B"."AB03B11T00" ("ID_011") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B13T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B13T00" ADD CONSTRAINT "FK_AB03B13T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE", "ID_002_TRAMITE")
	  REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE;
  ALTER TABLE "AB03B"."AB03B13T00" ADD CONSTRAINT "FK_AB03B13T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B13T00" ADD CONSTRAINT "FK_AB03B13T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B13T00" ADD CONSTRAINT "FK_AB03B13T00_AB03B08T00" FOREIGN KEY ("ID_008_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B08T00" ("ID_008") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B14T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B14T00" ADD CONSTRAINT "FK_AB03B14T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE", "ID_002_TRAMITE")
	  REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE;
  ALTER TABLE "AB03B"."AB03B14T00" ADD CONSTRAINT "FK_AB03B14T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
  ALTER TABLE "AB03B"."AB03B14T00" ADD CONSTRAINT "FK_AB03B14T00_AB03B34T00" FOREIGN KEY ("ID_034_ESTADO")
	  REFERENCES "AB03B"."AB03B34T00" ("ID_034") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B15T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "FK_AB03B15T00_AB03B04T00" FOREIGN KEY ("ID_004_FIRMANTE")
	  REFERENCES "AB03B"."AB03B04T00" ("ID_004") ENABLE;
  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "FK_AB03B15T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "FK_AB03B15T00_AB03B11T00" FOREIGN KEY ("ID_011_DOCENTRADA")
	  REFERENCES "AB03B"."AB03B11T00" ("ID_011") ENABLE;
  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "FK_AB03B15T00_AB03B13T00" FOREIGN KEY ("ID_013_TIPO_DOC_G")
	  REFERENCES "AB03B"."AB03B13T00" ("ID_013") ENABLE;
  ALTER TABLE "AB03B"."AB03B15T00" ADD CONSTRAINT "FK_AB03B15T00_AB03B14T00" FOREIGN KEY ("ID_014_HISTO_TRAM")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B16T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B16T00" ADD CONSTRAINT "FK_AB03B16T00_AB03B06T00" FOREIGN KEY ("ID_006_TP_ACCESO")
	  REFERENCES "AB03B"."AB03B06T00" ("ID_006") ENABLE;
  ALTER TABLE "AB03B"."AB03B16T00" ADD CONSTRAINT "FK_AB03B16T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_NUM_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B18T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B18T00" ADD CONSTRAINT "FK_AB03B18T00_AB03B17T00" FOREIGN KEY ("ID_017_FASE")
	  REFERENCES "AB03B"."AB03B17T00" ("ID_017") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B23T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B23T00" ADD CONSTRAINT "FK_AB03B23T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE", "ID_018_TRAMITE")
	  REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE;
  ALTER TABLE "AB03B"."AB03B23T00" ADD CONSTRAINT "FK_AB03B23T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE;
  ALTER TABLE "AB03B"."AB03B23T00" ADD CONSTRAINT "FK_AB03B23T00_AB03B24T00" FOREIGN KEY ("ID_024_EXP", "ID_PROV_024", "ID_ANO_024")
	  REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE;
  ALTER TABLE "AB03B"."AB03B23T00" ADD CONSTRAINT "FK_AB03B23T00_AB03B28T00" FOREIGN KEY ("ID_028_TRAM")
	  REFERENCES "AB03B"."AB03B28T00" ("ID_028") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B24T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B24T00" ADD CONSTRAINT "FK_AB03B24T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE;
  ALTER TABLE "AB03B"."AB03B24T00" ADD CONSTRAINT "FK_AB03B24T00_AB03B44T00" FOREIGN KEY ("TIPO_DOC_044")
	  REFERENCES "AB03B"."AB03B44T00" ("ID_044") ENABLE;
  ALTER TABLE "AB03B"."AB03B24T00" ADD CONSTRAINT "FK_AB03B24T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B25T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "FK_AB03B25T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "FK_AB03B25T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "FK_AB03B25T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE", "ID_018_TRAMITE")
	  REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE;
  ALTER TABLE "AB03B"."AB03B25T00" ADD CONSTRAINT "FK_AB03B25T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B26T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B26T00" ADD CONSTRAINT "FK_AB03B26T00_AB03B23T00" FOREIGN KEY ("ID_023_CODJMS")
	  REFERENCES "AB03B"."AB03B23T00" ("ID_023") ENABLE;
  ALTER TABLE "AB03B"."AB03B26T00" ADD CONSTRAINT "FK_AB03B26T00_AB03B25T00" FOREIGN KEY ("ID_025_DOC_SOL")
	  REFERENCES "AB03B"."AB03B25T00" ("ID_025") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B27T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B27T00" ADD CONSTRAINT "FK_AB03B27T00_AB03B07T00_1" FOREIGN KEY ("ID_007_TP_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B27T00" ADD CONSTRAINT "FK_AB03B27T00_AB03B07T00_2" FOREIGN KEY ("ID_007_ST_DOC_DOKUSI")
	  REFERENCES "AB03B"."AB03B07T00" ("ID_007") ENABLE;
  ALTER TABLE "AB03B"."AB03B27T00" ADD CONSTRAINT "FK_AB03B27T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE", "ID_018_TRAMITE")
	  REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE;
  ALTER TABLE "AB03B"."AB03B27T00" ADD CONSTRAINT "FK_AB03B27T00_AB03B22T00" FOREIGN KEY ("ID_022_TIPO_PLAN")
	  REFERENCES "AB03B"."AB03B22T00" ("ID_022") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B28T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B28T00" ADD CONSTRAINT "FK_AB03B28T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE", "ID_018_TRAMITE")
	  REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE;
  ALTER TABLE "AB03B"."AB03B28T00" ADD CONSTRAINT "FK_AB03B28T00_AB03B24T00" FOREIGN KEY ("ID_024_NUM_EXP", "ID_PROV_024", "ID_ANO_024")
	  REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE;
  ALTER TABLE "AB03B"."AB03B28T00" ADD CONSTRAINT "FK_AB03B28T00_AB03B35T00" FOREIGN KEY ("ID_035_ESTADO")
	  REFERENCES "AB03B"."AB03B35T00" ("ID_035") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B29T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "FK_AB03B29T00_AB03B04T00" FOREIGN KEY ("ID_004_FIRMANTE")
	  REFERENCES "AB03B"."AB03B04T00" ("ID_004") ENABLE;
  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "FK_AB03B29T00_AB03B24T00" FOREIGN KEY ("ID_024_NUM_EXP", "ID_PROV_024", "ID_ANO_024")
	  REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE;
  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "FK_AB03B29T00_AB03B25T00" FOREIGN KEY ("ID_025_DOCENTRADA")
	  REFERENCES "AB03B"."AB03B25T00" ("ID_025") ENABLE;
  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "FK_AB03B29T00_AB03B27T00" FOREIGN KEY ("ID_027_TIPO_DOC_G")
	  REFERENCES "AB03B"."AB03B27T00" ("ID_027") ENABLE;
  ALTER TABLE "AB03B"."AB03B29T00" ADD CONSTRAINT "FK_AB03B29T00_AB03B28T00" FOREIGN KEY ("ID_028_HISTO_TRAM")
	  REFERENCES "AB03B"."AB03B28T00" ("ID_028") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B30T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B30T00" ADD CONSTRAINT "FK_AB03B30T00_AB03B06T00" FOREIGN KEY ("ID_006_TP_ACCESO")
	  REFERENCES "AB03B"."AB03B06T00" ("ID_006") ENABLE;
  ALTER TABLE "AB03B"."AB03B30T00" ADD CONSTRAINT "FK_AB03B30T00_AB03B24T00" FOREIGN KEY ("ID_024_NUM_EXP", "ID_PROV_024", "ID_ANO_024")
	  REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B31T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B31T00" ADD CONSTRAINT "FK_AB03B31T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B32T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B32T00" ADD CONSTRAINT "FK_AB03B32T00_AB03B44T00" FOREIGN KEY ("TIPO_DOC_044")
	  REFERENCES "AB03B"."AB03B44T00" ("ID_044") ENABLE;
  ALTER TABLE "AB03B"."AB03B32T00" ADD CONSTRAINT "FK_AB03B32T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B33T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B33T00" ADD CONSTRAINT "FK_AB03B33T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
  ALTER TABLE "AB03B"."AB03B33T00" ADD CONSTRAINT "FK_AB03B33T00_AB03B32T00" FOREIGN KEY ("ID_032_TRAB")
	  REFERENCES "AB03B"."AB03B32T00" ("ID_032") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B36T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B36T00" ADD CONSTRAINT "FK_AB03B36T00_AB03B02T00" FOREIGN KEY ("ID_001_FASE", "ID_002_TRAMITE")
	  REFERENCES "AB03B"."AB03B02T00" ("ID_001_FASE", "ID_002") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B37T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B37T00" ADD CONSTRAINT "FK_AB03B37T00_AB03B18T00" FOREIGN KEY ("ID_017_FASE", "ID_018_TRAMITE")
	  REFERENCES "AB03B"."AB03B18T00" ("ID_017_FASE", "ID_018") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B39T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B39T00" ADD CONSTRAINT "FK_AB03B39T00_AB03B45T00" FOREIGN KEY ("ID_045_ORG")
	  REFERENCES "AB03B"."AB03B45T00" ("ID_045") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B42T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B42T00" ADD CONSTRAINT "FK_AB03B42T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
  ALTER TABLE "AB03B"."AB03B42T00" ADD CONSTRAINT "FK_AB03B42T00_AB03B40T00" FOREIGN KEY ("ID_040")
	  REFERENCES "AB03B"."AB03B40T00" ("ID_040") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B46T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B46T00" ADD CONSTRAINT "FK_AB03B46T00_AB03B14T00" FOREIGN KEY ("ID_014_HISTO_TRAM")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
  ALTER TABLE "AB03B"."AB03B46T00" ADD CONSTRAINT "FK_AB03B46T00_AB03B39T00" FOREIGN KEY ("ID_039_ORGAN")
	  REFERENCES "AB03B"."AB03B39T00" ("ID_039") ENABLE;
  ALTER TABLE "AB03B"."AB03B46T00" ADD CONSTRAINT "FK_AB03B46T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B47T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B47T00" ADD CONSTRAINT "FK_AB03B47T00_AB03B44T00" FOREIGN KEY ("TIPO_DOC_044")
	  REFERENCES "AB03B"."AB03B44T00" ("ID_044") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B49T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B49T00" ADD CONSTRAINT "FK_AB03B49T00_AB03B48T00" FOREIGN KEY ("ID_048_ORG")
	  REFERENCES "AB03B"."AB03B48T00" ("ID_048") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B50T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B50T00" ADD CONSTRAINT "FK_AB03B50T00_AB03B28T00" FOREIGN KEY ("ID_028_HISTO_TRAM")
	  REFERENCES "AB03B"."AB03B28T00" ("ID_028") ENABLE;
  ALTER TABLE "AB03B"."AB03B50T00" ADD CONSTRAINT "FK_AB03B50T00_AB03B47T00" FOREIGN KEY ("ID_047_EMPRESA")
	  REFERENCES "AB03B"."AB03B47T00" ("ID_047") ENABLE;
  ALTER TABLE "AB03B"."AB03B50T00" ADD CONSTRAINT "FK_AB03B50T00_AB03B49T00" FOREIGN KEY ("ID_049_ORGAN")
	  REFERENCES "AB03B"."AB03B49T00" ("ID_049") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B51T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B51T00" ADD CONSTRAINT "FK_AB03B51T00_AB03B10T00" FOREIGN KEY ("ID_ANO_010", "ID_010_EXP", "ID_PROV_010")
	  REFERENCES "AB03B"."AB03B10T00" ("ID_ANO_010", "ID_010", "ID_PROV_010") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B52T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B52T00" ADD CONSTRAINT "FK_AB03B52T00_AB03B24T00" FOREIGN KEY ("ID_024_NUM_EXP", "ID_PROV_024", "ID_ANO_024")
	  REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B56T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "FK_AB03B56T00_AB03B14T00" FOREIGN KEY ("ID_014")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "FK_AB03B56T00_AB03B41T00" FOREIGN KEY ("ID_041_MATERIAL")
	  REFERENCES "AB03B"."AB03B41T00" ("ID_041") ENABLE;
  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "FK_AB03B56T00_AB03B54T00" FOREIGN KEY ("ID_054_ACTIVIDAD")
	  REFERENCES "AB03B"."AB03B54T00" ("ID_054") ENABLE;
  ALTER TABLE "AB03B"."AB03B56T00" ADD CONSTRAINT "FK_AB03B56T00_AB03B55T00" FOREIGN KEY ("ID_055_SUB_ACTIVIDAD")
	  REFERENCES "AB03B"."AB03B55T00" ("ID_055") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B57T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B57T00" ADD CONSTRAINT "FK_AB03B57T00_AB03B14T00" FOREIGN KEY ("ID_014")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B58T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B58T00" ADD CONSTRAINT "FK_AB03B58T00_AB03B14T00" FOREIGN KEY ("ID_014")
	  REFERENCES "AB03B"."AB03B14T00" ("ID_014") ENABLE;
--------------------------------------------------------
--  Ref Constraints for Table AB03B59T00
--------------------------------------------------------

  ALTER TABLE "AB03B"."AB03B59T00" ADD CONSTRAINT "FK_AB03B59T00_AB03B53T00" FOREIGN KEY ("ID_053_TRABAJO")
	  REFERENCES "AB03B"."AB03B53T00" ("ID_053") ENABLE;
  ALTER TABLE "AB03B"."AB03B59T00" ADD CONSTRAINT "FK_AB03B59T00_AB03B56T00" FOREIGN KEY ("ID_056_EJECUCION")
	  REFERENCES "AB03B"."AB03B56T00" ("ID_056") ENABLE;

--------------------------------------------------------
--  Ref Constraints for Table AB03B60T00
--------------------------------------------------------	  
ALTER TABLE "AB03B"."AB03B60T00" ADD CONSTRAINT "FK_AB03B60T00_AB03B10T00" FOREIGN KEY ("ID_010_NUM_EXP", "ID_PROV_010", "ID_ANO_010") 
	REFERENCES "AB03B"."AB03B10T00" ("ID_010", "ID_PROV_010", "ID_ANO_010") ENABLE;	  

--------------------------------------------------------
--  Ref Constraints for Table AB03B61T00
--------------------------------------------------------
ALTER TABLE "AB03B"."AB03B61T00" ADD CONSTRAINT "FK_AB03B61T00_AB03B24T00" FOREIGN KEY ("ID_024_NUM_EXP", "ID_PROV_024", "ID_ANO_024") 
	REFERENCES "AB03B"."AB03B24T00" ("ID_024", "ID_PROV_024", "ID_ANO_024") ENABLE; 

--------------------------------------------------------
--  Ref Constraints for Table AB03B62T00
--------------------------------------------------------
ALTER TABLE "AB03B"."AB03B62T00" ADD CONSTRAINT "FK_AB03B62T00_AB03B11T00" FOREIGN KEY ("ID_011_TP_DOC") 
	REFERENCES "AB03B"."AB03B11T00" ("ID_011") ENABLE; 
ALTER TABLE "AB03B"."AB03B62T00" ADD CONSTRAINT "FK_AB03B62T00_AB03B15T00" FOREIGN KEY ("ID_015_DOC") 
	REFERENCES "AB03B"."AB03B15T00" ("ID_015") ENABLE; 

--------------------------------------------------------
--  Ref Constraints for Table AB03B62T00
--------------------------------------------------------
  ALTER TABLE "AB03B"."AB03B63T00" ADD CONSTRAINT "FK_AB03B63T00_AB03B33T00" FOREIGN KEY ("ID_033_TRABEXP") 
	REFERENCES "AB03B"."AB03B33T00" ("ID_033") ENABLE; 
ALTER TABLE "AB03B"."AB03B63T00" ADD CONSTRAINT "FK_AB03B63T00_AB03B56T00" FOREIGN KEY ("ID_056_DATEJEC") 
	REFERENCES "AB03B"."AB03B56T00" ("ID_056") ENABLE; 
	

REM INSERTING into AB03B.AB03B01T00
SET DEFINE OFF;
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('1','Recepcin y anlisis de la solicitud','Eskaera jasotzea eta aztertzea');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('2','Subsanacin','Zuzenketa');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('3','Resolucin','Ebazpena');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('4','Comunicacin inicio de trabajo','Lanaren hasiera komunikatzea');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('5','Aportacin voluntaria de documentacin','Dokumentazioa borondatez aurkeztea');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('6','Recurso de alzada','Gorako errekurtsoa');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('7','Comunicacin desestimiento por la empresa','Enpresak atzera egitea komunikatzea');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('8','Comunicacin de fin de obra/cierre','Obra-amaieraren/obra-itxieraren komunikazioa');
Insert into AB03B.AB03B01T00 (ID_001,DESC_ES_001,DESC_EU_001) values ('9','Cierre','Ixtea');
REM INSERTING into AB03B.AB03B02T00
SET DEFINE OFF;
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','1','Recepcin de la solicitud telemtica','Eskaera telematikoa jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','1','Registro de la solicitud e inicio del expediente','Eskaera  eta espedientea hastea erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('3','1','Apertura del expediente en Mis Gestiones','Espedientea irekitzea Nire Kudeaketak atalean','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('4','1','Recepcin de informes de Osalan','Osalanen txostenak jasotzea','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('5','1','Recepcin de informes de Inspeccin','Ikuskaritza-txostenak jasotzea','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','2','Requerimiento de subsanacin','Zuzentzeko Errekerimendua','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','2','Notificacin de Requerimiento de subsanacin','Zuzenketa-errekerimenduaren jakinarazpena','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('3','2','Recepcin de documentacin de subsanacin','Zuzenketa-dokumentazioa jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('4','2','Registro en el expediente de la documentacin de subsanacin','Zuzenketa-dokumentazioa espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','3','Resolucin','Ebazpena','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','3','Notificacin resolucin','Ebazpenaren jakinarazpena','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','4','Recepcin comunicacin inicio de trabajo','Lanaren hasieraren komunikazioa jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','4','Registro comunicacin inicio de trabajo en el expediente','Lan-hasieraren komunikazioa espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','5','Recepcin de la documentacin de aportacin voluntaria','Dokumentazioa borondatez aurkeztea jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','5','Registro de la documentacin voluntaria en el expediente','Dokumentazioa borondatez aurkeztea espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','6','Recepcin de recurso de alzada','Gora jotzeko errekurtsoa jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','6','Registro del recurso de alzada en el expediente','Gora jotzeko errekurtsoa espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('3','6','Generar resolucin de recurso de alzada','Sortu gora jotzeko errekurtsoaren ebazpena','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('4','6','Notificar resolucin del recurso de alzada','Jakinarazi gora jotzeko errekurtsoaren ebazpena','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','7','Recepcin de desestimiento por parte de la empresa','Enpresak atzera egitea jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','7','Registro del desestimiento en el expediente','Atzera egitea espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('3','7','Generar resolucin de desestimiento','Sortu atzera egitearen ebazpena ','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('4','7','Notificar resolucin de desestimiento','Jakinarazi atzera egitearen ebazpena ','S');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','8','Recepcin de la comunicacin de fin de obra','Obra-amaieraren komunikazioa jasotzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('2','8','Registro del fin de obra en el expediente','Obra-amaiera espedientean erregistratzea','E');
Insert into AB03B.AB03B02T00 (ID_002,ID_001_FASE,DESC_ES_002,DESC_EU_002,ENT_SAL_002) values ('1','9','Cierre del expediente','Espedientea ixtea','S');

REM INSERTING into AB03B.AB03B03T00
SET DEFINE OFF;
Insert into AB03B.AB03B03T00 (ID_003,DESC_ES_003,DESC_EU_003,ACTIVO_SN_003) values ('3','Director','Zuzendaria','S');
Insert into AB03B.AB03B03T00 (ID_003,DESC_ES_003,DESC_EU_003,ACTIVO_SN_003) values ('1','Tcnico','Teknikaria','S');
Insert into AB03B.AB03B03T00 (ID_003,DESC_ES_003,DESC_EU_003,ACTIVO_SN_003) values ('2','Delegado','Ordezkaria','S');
Insert into AB03B.AB03B03T00 (ID_003,DESC_ES_003,DESC_EU_003,ACTIVO_SN_003) values ('4','Osalan','Osalan','S');
Insert into AB03B.AB03B03T00 (ID_003,DESC_ES_003,DESC_EU_003,ACTIVO_SN_003) values ('5','Inspeccin','Ikuskaritza','S');

REM INSERTING into AB03B.AB03B44T00
SET DEFINE OFF;

Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('2','CIF','IFK','S');
Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('3','PASAPORTE','PASAPORTEA','S');
Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('4','NIF','IFZ','S');
Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('5','OTROS','BESTEAK','S');
Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('1','DNI','NAN','S');
Insert into AB03B.AB03B44T00 (ID_044,DESC_ES_044,DESC_EU_044,ACTIVO_SN_044) values ('6','NIE','AIZ','S');

REM INSERTING into AB03B.AB03B04T00
SET DEFINE OFF;
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('2','Koldo','Perez','Martinez','2','S','01','1','99999990S','AB03B-03',to_date('10/09/2017  00:00:00','DD/MM/YYYY  HH24:MI:SS'),to_date('10/09/2018  00:00:00','DD/MM/YYYY  HH24:MI:SS'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('3','Maria','Garcia','Perez','2','S','20','1','99999990S','AB03B-04',to_date('05/07/2017  00:00:00','DD/MM/YYYY  HH24:MI:SS'),to_date('10/09/2018  00:00:00','DD/MM/YYYY  HH24:MI:SS'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('1','Ana','Ape1','Ape2','2','S','48','1','99999990S','AB03B-05',to_date('05/07/2017  00:00:00','DD/MM/YYYY  HH24:MI:SS'),to_date('10/09/2018  00:00:00','DD/MM/YYYY  HH24:MI:SS'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('5','Inspeccin','De','Araba','5','AB03BUIA','S','01','1','99999990S','AB03B-11', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('4','Osalan','De','Araba','4','AB03BUDA','S','01','1','99999990S','AB03B-08', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('6','Osalan','De','Bizkaia','4','AB03BUDB','S','48','1','99999990S','AB03B-10', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('7','Osalan','De','Gipuzkoa','4','AB03BUDG','S','20','1','99999990S','AB03B-09', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('8','Inspeccin','De','Bizkaia','5','AB03BUIB','S','48','1','99999990S','AB03B-13', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));
Insert into AB03B.AB03B04T00 (ID_004,NOMBRE_004,APEL1_004,APEL2_004,ID_003_CARGO,USUARIO_004,ACTIVO_SN_004,ID_PROV_004,TIPO_DOC_044,NIF_FIRMANTE_004,BUZON_004,FIRMA_ESCANEADA_004,F_VIGENCIA_DS_004,F_VIGENCIA_HS_004) values ('9','Inspeccin','De','Gipuzkoa','5','AB03BUIG','S','20','1','99999990S','AB03B-12', EMPTY_BLOB(),to_timestamp('02/10/2017 00:00:00','DD/MM/RR HH24:MI:SSXFF'),to_timestamp('02/10/2027 00:00:00','DD/MM/RR HH24:MI:SSXFF'));

REM INSERTING into AB03B.AB03B05T00
SET DEFINE OFF;
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('5','Resolucion_Denegatoria');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('6','Desistimiento');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('4','RequerimientoSubsanacion');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('1','Resolucin plan sucesivo');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('2','Resolucin plan generico');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('3','Resolucin plan especifico');
Insert into AB03B.AB03B05T00 (ID_005,NOMBRE_005) values ('7','RecursoAlzada');
REM INSERTING into AB03B.AB03B06T00
SET DEFINE OFF;
Insert into AB03B.AB03B06T00 (ID_006,DESC_ES_006,DESC_EU_006) values ('A','Alta',null);
Insert into AB03B.AB03B06T00 (ID_006,DESC_ES_006,DESC_EU_006) values ('M','Modificacin',null);
Insert into AB03B.AB03B06T00 (ID_006,DESC_ES_006,DESC_EU_006) values ('C','Consulta',null);

REM INSERTING into AB03B.AB03B34T00
SET DEFINE OFF;
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('4','Pendiente de firma','Sinatu zain');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('6','Firmado','Sinatua');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('7','Pendiente de visto bueno','Oniritziaren zain');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('3','Pendiente enviar a Firma','Sinatzera bidaltzeke');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('5','Firma rechazada','Sinadura ukatua');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('1','En tramitacin','Izapidetzen');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('2','Realizado','Eginda');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('8','Visto Bueno','Oniritzia');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('9','Notificacion pendiente de leer','Irakurtzeko dagoen jakinarazpena');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('10','Acuse de recibo ','Hartu izanaren agiria');
Insert into AB03B.AB03B34T00 (ID_034,DESC_ES_034,DESC_EU_034) values ('11','Expirado','Iraungita');

REM INSERTING into AB03B.AB03B35T00
SET DEFINE OFF;
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('1','En tramitacin','Izapidetzen');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('2','Realizado','Eginda');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('3','Pendiente enviar a Firma','Sinatzera bidaltzeke');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('4','Pendiente de firma','Sinatu zain');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('5','Firma rechazada','Sinadura ukatua');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('6','Firmado','Sinatua');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('7','Pendiente de visto bueno','Oniritziaren zain');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('8','Visto Bueno','Oniritzia');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('9','Notificacin pendiente de leer','Irakurtzeko dagoen jakinarazpena');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('10','Acuse de recibo','Hartu izanaren agiria');
Insert into AB03B.AB03B35T00 (ID_035,DESC_ES_035,DESC_EU_035) values ('11','Expirado','Iraungita');
REM INSERTING into AB03B.AB03B36T00
SET DEFINE OFF;
Insert into AB03B.AB03B36T00 (ID_036,ID_002_TRAMITE,ID_001_FASE,DELEGACION_036,FLAG_VB_036) values ('2','1','2','01','0');
Insert into AB03B.AB03B36T00 (ID_036,ID_002_TRAMITE,ID_001_FASE,DELEGACION_036,FLAG_VB_036) values ('3','3','6','01','1');
Insert into AB03B.AB03B36T00 (ID_036,ID_002_TRAMITE,ID_001_FASE,DELEGACION_036,FLAG_VB_036) values ('4','3','7','01','0');
Insert into AB03B.AB03B36T00 (ID_036,ID_002_TRAMITE,ID_001_FASE,DELEGACION_036,FLAG_VB_036) values ('1','1','3','01','0');
REM INSERTING into AB03B.AB03B37T00
SET DEFINE OFF;
REM INSERTING into AB03B.AB03B45T00
SET DEFINE OFF;
Insert into AB03B.AB03B45T00 (ID_045,DESC_ES_045,DESC_EU_045) values ('1','Delegacin Territorial','Lurralde Ordezkaritza');
Insert into AB03B.AB03B45T00 (ID_045,DESC_ES_045,DESC_EU_045) values ('2','Osalan','Osalan');
Insert into AB03B.AB03B45T00 (ID_045,DESC_ES_045,DESC_EU_045) values ('3','Inspeccin','Ikuskaritza');
Insert into AB03B.AB03B45T00 (ID_045,DESC_ES_045,DESC_EU_045) values ('4','Direccin de trabajo','Lan Zuzendaritza');

REM INSERTING into AB03B.AB03B39T00
SET DEFINE OFF;
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('1','01','Samaniego','2','2','','01008','059','945017030','945017031','Delegacin territorial De lava','Arabako lurralde ordezkaritza','1','1','trabajoaraba@euskadi.eus','01');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('2','01','Jos Atxotegi','1','','','01009','059','945016800','945016801','Centro Territorial de Araba','Arabako lurralde zentroa','2','0','osalancatga@euskadi.eus','01');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('3','01','General Alava','10','2','','01005','059','945062100','945062101','Inspeccin de Trabajo en Araba-lava','Araba-lavako Lan Ikuskaritza','3','0','itpv-alava@euskadi.eus','01');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('4','48','Gran Va','85','','','48011','020','944031216','944031212','Delegacin territorial de Bizkaia','Bizkaiko lurralde ordezkaritza','1','0','trabajobizkaia@euskadi.eus','48');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('5','20','Intxaurrondo','70','2','','20015','069','943023224','943023201','Delegacin territorial de Gipuzkoa','Gipuzkoako lurralde ordezkaritza','1','0','trabajogipuzkoa@euskadi.eus','20');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('6','20','Maldatxo bidea','s/n','','','20012','069','943023262','943023251','Centro Territorial de Gipuzkoa','Gipuzkoako lurralde zentroa','2','0','osalancatdo@euskadi.eus','20');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('7','48','Camino de la Dinamita','s/n(Monte Basatxu)','','','48903','013','944032179','94 032107','Centro Territorial de Bizkaia','Bizkaiko lurralde zentroa','2','0','osalancatba@euskadi.eus','48');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('8','20','Urdaneta','7','1','','20006','069','943023550','943023551','Inspeccin de Trabajo en Gipuzkoa','Gipuzkoako Lan Ikuskaritza','3','0','itpv-gipuzkoa@euskadi.eus','20');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('9','48','Gran Va','50','3','','48011','020','944032700','944032701','Inspeccin de Trabajo en Bizkaia','Bizkaiko Lan Ikuskaritza','3','0','itpv-bizkaia@euskadi.eus ','48');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('10','48','Camino de la Dinamita','s/n(Monte Basatxu)','','','48001','013','944032190','','Osalan Servicios Centrales','Osalan zerbitzu orokorrak','2','1','','699');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('11','01','Donostia-San Sebastian kalea','1','','','01010','059','945019320','945019415','Subdireccin de la Inspeccin de Trabajo del Pas Vasco','Euskadiko Lan Ikuskaritzako Zuzendaritzaordea','3','1','itpv@euskadi.eus','599');
Insert into AB03B39T00 (ID_039,TERRITORIO_039,CALLE_039,NUMERO_039,PISO_039,LETRA_039,COD_POSTAL_039,MUNICIPIO_039,TELEFONO_039,FAX_039,DESC_ES_039,DESC_EU_039,ID_045_ORG,REG_MANUAL_039,EMAIL_039,ID_PERFIL_039) values ('12','01','Donostia - San Sebastian','1','','','01010','059','945019317','945019415','Direccin de Trabajo y Seguridad Social','Laneko eta Gizarte Segurantzako Zuzendaritza','4','1','trabajo@euskadi.eus','99');

REM INSERTING into AB03B.AB03B40T00
SET DEFINE OFF;
REM INSERTING into AB03B.AB03B41T00
SET DEFINE OFF;
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('1','Proyectado y revestido','Proiektatua eta estalia','S','6.1','N');
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('2','Calorifugados','Bero-ihesekoak','S','6.2','S');
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('3','Otros friables','Beste hauskor batzuk','S','6.3','S');
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('4','Fibrocemento','Zuntz-zementua','S','6.4','N');
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('5','Losetas amianto-vinilo','Amianto-binilozko lauza txikiak','S','6.5','N');
Insert into AB03B.AB03B41T00 (ID_041,DESC_ES_041,DESC_EU_041,ACTIVO_SN_041,COD_MCA_041,FRIABLE_041) values ('6','Otros no friables','Hauskor ez diren beste batzuk','S','6.6','N');

REM INSERTING into AB03B.AB03B42T00
SET DEFINE OFF;


REM INSERTING into AB03B.AB03B07T00
SET DEFINE OFF;
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('1','ejgv_d_solicitud','Solicitud',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('2','ejgv_d_plan','Plan',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('3','ejgv_d_resolucion','Resolucin',null,'RESOL');
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('4','ejgv_d_resolucion_inscrip','Resolucin de inscripcin','ejgv_d_resolucion',null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('8','ejgv_d_informe','Informe',null,'COMUNICATION_NOT_INFORM');
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('5','ejgv_d_resolucion_recu','Resolucin del recurso','ejgv_d_resolucion','RESOL_RECUR');
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('6','ejgv_d_resolucion_desisti','Resolucin de desistimiento','ejgv_d_resolucion','r02d1F337460E1F40617B2D000E3C8EA08914BA01AFA');
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('7','ejgv_d_requsubs','Requerimiento de subsanacin',null,'REQ_SUB');
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('10','ejgv_d_archivo','Documento genrico de Archivo',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('11','ejgv_d_resolucion_auto','Resolucin de autorizacin','ejgv_d_resolucion',null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('12','ejgv_d_programa','Programa',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('13','ejgv_d_informe_seguiyeval','Informe de seguimiento y evaluacin','ejgv_d_informe',null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('14','ejgv_d_estudetalle','Estudio de detalle',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('15','ejgv_d_ficha','Ficha tcnica',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('16','ejgv_d_sancion','Sancin',null,null);
Insert into AB03B.AB03B07T00 (ID_007,DESC_ES_007,DESC_EU_007,ID_COD_PADRE,ACTO_NOTIF_007) values ('17','r02dFD02D2CE8F252C7DC356BDE2AF1F748596EBD404','Plan de Seguridad y Salud en el Trabajo','ejgv_d_plan',null);

																														
REM INSERTING into AB03B.AB03B08T00
SET DEFINE OFF;
Insert into AB03B.AB03B08T00 (ID_008,DESC_ES_008,DESC_EU_008) values ('1','Genrico','Orokorra');
Insert into AB03B.AB03B08T00 (ID_008,DESC_ES_008,DESC_EU_008) values ('2','Especfico','Espezifikoa');
Insert into AB03B.AB03B08T00 (ID_008,DESC_ES_008,DESC_EU_008) values ('3','Sucesivo','Ondoz ondokoa');
REM INSERTING into AB03B.AB03B09T00
SET DEFINE OFF;
REM INSERTING into AB03B.AB03B54T00
SET DEFINE OFF;
Insert into AB03B.AB03B54T00 (ID_054,DESC_ES_054,DESC_EU_054,ACTIVO_SN_054,COD_MCA_054) values ('1','Retirada amianto y MCA','Amiantoa eta MCA kentzea','S','5.1');
Insert into AB03B.AB03B54T00 (ID_054,DESC_ES_054,DESC_EU_054,ACTIVO_SN_054,COD_MCA_054) values ('2','Mantenimiento/Reparacin','Mantentze-lanak/Konponketa','S','5.2');
Insert into AB03B.AB03B54T00 (ID_054,DESC_ES_054,DESC_EU_054,ACTIVO_SN_054,COD_MCA_054) values ('3','Transporte de residuos','Hondakinak garraiatzea','S','5.3');
Insert into AB03B.AB03B54T00 (ID_054,DESC_ES_054,DESC_EU_054,ACTIVO_SN_054,COD_MCA_054) values ('4','Tratamiento-Destruccin de residuos','Hondakinak tratatzea/deuseztatzea','S','5.4');
Insert into AB03B.AB03B54T00 (ID_054,DESC_ES_054,DESC_EU_054,ACTIVO_SN_054,COD_MCA_054) values ('5','Otras','Beste batzuk','S','5.5');


REM INSERTING into AB03B.AB03B11T00
SET DEFINE OFF;

Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('58','2','3','1','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('59','2','3','2','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('60','2','3','3','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('61','1','1','1','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('62','1','1','2','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('63','1','1','3','Otros','Besteak','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('64','7','1','1','Solicitud de desistimiento','Atzera egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('65','7','1','2','Solicitud de desistimiento','Atzera egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('66','7','1','3','Solicitud de desistimiento','Atzera egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('67','6','1','1','Solicitud de recurso de alzada','Gora jotzeko errekurtsorako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('68','6','1','2','Solicitud de recurso de alzada','Gora jotzeko errekurtsorako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('69','6','1','3','Solicitud de recurso de alzada','Gora jotzeko errekurtsorako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('40','5','1','1','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('41','5','1','2','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('42','5','1','3','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('43','5','1','1','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('44','5','1','2','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('45','5','1','3','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('46','5','1','1','Solicitud de aportacin voluntaria de documentacin','Dokumentazioa borondatez aurkeztearen eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('47','5','1','2','Solicitud de aportacin voluntaria de documentacin','Dokumentazioa borondatez aurkeztearen eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('48','5','1','3','Solicitud de aportacin voluntaria de documentacin','Dokumentazioa borondatez aurkeztearen eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('49','2','3','1','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('50','2','3','2','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('51','2','3','3','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('52','2','3','1','Incripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('53','2','3','2','Incripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('54','2','3','3','Incripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('55','2','3','1','Solicitud de Subsanacin','Zuzenketak egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('56','2','3','2','Solicitud de Subsanacin','Zuzenketak egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('57','2','3','3','Solicitud de Subsanacin','Zuzenketak egiteko eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('1','1','1','1','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('2','1','1','1','Solicitud de autorizacin de plan de trabajo con riesgo por amianto','Amianto-arriskua duten lan-plana baimentzeako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('3','1','1','1','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('4','2','1','1','Requerimiento de subsanacin','Zuzentzeko Errekerimendua','7',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('6','3','1','1','Resolucin','Ebazpena','3',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('7','4','1','1','Comunicacin de inicio de obra','Lanaren hasiera komunikatzea','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('8','5','1','1','Aportacin voluntaria','Borondatez aurkeztea','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('9','6','1','1','Recurso de alzada','Gorako errekurtsoa','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('10','6','3','1','Resolucin de recurso de alzada','Gorako errekurtsoaren ebazpena','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('11','7','1','1','Desistimiento','Atzera egitea','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('12','7','3','1','Resolucin de Desistimiento','Atzera egitearen ebazpena','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('13','8','1','1','Comunicacin de fin de obra','Obra-amaieraren komunikazioa','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('14','1','1','2','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('15','1','1','2','Solicitud de autorizacin de plan de trabajo con riesgo por amianto','Amianto-arriskua duten lan-plana baimentzeako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('16','1','1','2','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('17','2','1','2','Requerimiento de subsanacin','Zuzentzeko Errekerimendua','7',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('19','3','1','2','Resolucin','Ebazpena','3',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('20','4','1','2','Comunicacin de inicio de obra','Lanaren hasiera komunikatzea','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('21','5','1','2','Aportacin voluntaria','Borondatez aurkeztea','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('22','6','1','2','Recurso de alzada','Gorako errekurtsoa','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('23','6','3','2','Resolucin de recurso de alzada','Gorako errekurtsoaren ebazpena','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('24','7','1','2','Desistimiento','Atzera egitea','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('25','7','3','2','Resolucin de Desistimiento','Atzera egitearen ebazpena','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('26','8','1','2','Comunicacin de fin de obra','Obra-amaieraren komunikazioa','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('27','1','1','3','Plan de trabajo','Lan-plana','2',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('28','1','1','3','Solicitud de autorizacin de plan de trabajo','Amianto-arriskua duten lan-plana baimentzeako eskaera','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('29','1','1','3','Inscripcin en RERA','AAEEn inskripzioa','4',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('30','2','1','3','Requerimiento de subsanacin','Zuzentzeko Errekerimendua','7',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('32','3','1','3','Resolucin','Ebazpena','3',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('33','4','1','3','Comunicacin de inicio de obra','Lanaren hasiera komunikatzea','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('34','5','1','3','Aportacin voluntaria','Borondatez aurkeztea','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('35','6','1','3','Recurso de alzada','Gorako errekurtsoa','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('36','6','3','3','Resolucin de recurso de alzada','Gorako errekurtsoaren ebazpena','5',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('37','7','1','3','Desistimiento','Atzera egitea','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('38','7','3','3','Resolucin de Desistimiento','Atzera egitearen ebazpena','6',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('39','8','1','3','Comunicacin de fin de obra','Obra-amaieraren komunikazioa','1',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('70','1','1','1','Resolucin de autorizacin de Planes de Trabajo de caracter general con Riesgo por Amianto','Amianto-arriskua duten lan-planak baimentzeako ebazpena','11',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('71','5','1','1','Resolucin de autorizacin de Planes de Trabajo de caracter general con Riesgo por Amianto','Amianto-arriskua duten lan-planak baimentzeako ebazpena','11',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('72','2','3','1','Resolucin de autorizacin de Planes de Trabajo de caracter general con Riesgo por Amianto','Amianto-arriskua duten lan-planak baimentzeako ebazpena','11',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('73','8','1','1','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('74','8','1','2','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('75','8','1','3','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('76','2','3','1','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('77','2','3','2','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('78','2','3','3','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('79','8','1','1','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('80','8','1','2','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('81','8','1','3','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('82','2','3','1','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('83','2','3','2','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('84','2','3','3','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('85',null,null,null,'Informe visita Osalan','Osalaren bisitaren Txostena','8',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('86',null,null,null,'Resolucin del Expediente Sancionador','Zehapen-espedientearen ebazpena','16',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('87','1','1','1','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('88','1','1','2','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('89','1','1','3','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('90','2','3','1','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('91','2','3','2','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('92','2','3','3','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('93','4','1','1','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('94','4','1','2','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('95','4','1','3','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('96','5','1','1','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('97','5','1','2','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('98','5','1','3','Calendario Laboral','Lan-egutegia','12',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('99','5','1','1','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('100','5','1','2','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('101','5','1','3','Anexo IV (Evaluacin de la exposicin)','IV eranskina (Evaluacin de la exposicin)_eu','13',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('102','5','1','3','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('103','5','1','2','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('104','5','1','1','Gestin de residuos','Hondakinen kudeaketa','14',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('105','8','1','1','Otros','Besterik','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('106','8','1','2','Otros','Besterik','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('107','8','1','3','Otros','Besterik','10',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('125','5','1','3','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('124','2','3','3','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('123','1','1','3','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('122','5','1','2','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('121','1','1','2','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('120','2','3','2','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('119','5','1','1','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('118','2','3','1','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('117','1','1','1','Anexo V (Ficha vigilancia sanitaria)','V eranskina (Langileen berariazko osasun-zaintzari fitxak)','15',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('116','5','1','3','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('115','2','3','3','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('114','1','1','3','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('113','5','1','2','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('112','2','3','2','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('111','1','1','2','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('110','5','1','1','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('109','2','3','1','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);
Insert into AB03B.AB03B11T00 (ID_011,ID_001_FASE,ID_002_TRAMITE,ID_008_TIPO_PLAN,DESC_ES_011,DESC_EU_011,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('108','1','1','1','Plan de Seguridad y Salud en el Trabajo','Laneko Osasun eta Segurtasun Plana','17',null);





REM INSERTING into AB03B.AB03B13T00
SET DEFINE OFF;
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('5','3','1','Resolucion_denegatoria','Ezezko ebazpena','5','3',null,null);
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('6','7','3','Desistimiento','Atzera egitea','6','6',null,null);
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('8','1','4','Informe Osalan','Osalanen txostena',null,'8',null,null);
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('9','1','5','Informe Inspeccin','Ikuskaritzaren txostena',null,'8',null,null);
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('7','6','3','Recurso de Alzada','Gorako errekurtsoa','7','5',null,null);
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('1','3','1','Resolucin de plan sucesivo','Ondoz ondoko planaren ebazpena','1','3',null,'3');
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('2','3','1','Resolucion de plan genrico','Plan orokorraren ebazpena','2','3',null,'1');
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('3','3','1','Resolucion de plan especfico','Plan espezifikoaren ebazpena','3','3',null,'2');
Insert into AB03B.AB03B13T00 (ID_013,ID_001_FASE,ID_002_TRAMITE,DESC_ES_013,DESC_EU_013,ID_005_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_008_TIPO_PLAN) values ('4','2','1','Requerimiento de Subsanacin','Zuzentzeko Errekerimendua','4','7',null,null);



REM INSERTING into AB03B.AB03B17T00
SET DEFINE OFF;
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('1','Recepcin y anlisis de la solicitud','Eskaera jasotzea eta aztertzea');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('2','Subsanacin','Zuzenketa');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('3','Justificante de inscripcin','Inskripzio-egiaztagiria');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('4','Aportacin voluntaria de documentacin','Dokumentazioa borondatez aurkeztea');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('5','Modificacin de expediente','Espediente bat aldatzea');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('6','Baja de expediente','Espediente-baja');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('7','Alegaciones','Alegazioak');
Insert into AB03B.AB03B17T00 (ID_017,DESC_ES_017,DESC_EU_017) values ('8','Cierre','Ixtea');
REM INSERTING into AB03B.AB03B18T00
SET DEFINE OFF;
REM INSERTING into AB03B18T00
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (4,6,'Confirmacin de baja','Baja berrespena','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,1,'Recepcin de la solicitud telemtica','Eskaera telematikoa jasotzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,1,'Registro de la solicitud e inicio del expediente','Eskaera  eta espedientea hastea erregistratzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (3,1,'Apertura del expediente en Mis Gestiones','Espedientea irekitzea Nire Kudeaketak atalean','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,2,'Requerimiento de subsanacin','Zuzentzeko Errekerimendua','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,2,'Notificacin de Requerimiento de subsanacin','Zuzenketa-errekerimenduaren jakinarazpena','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (3,2,'Recepcin de documentacin de subsanacin','Zuzenketa-dokumentazioa jasotzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (4,2,'Registro en el expediente de la documentacin de subsanacin','Zuzenketa-dokumentazioa espedientean erregistratzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,3,'Justificante de inscripcin ','Inskripzio-egiaztagiria','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,3,'Comunicacin de justificante de inscripcin','Inskripzio-egiaztagiriaren komunikazioa','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,4,'Recepcin de la documentacin de aportacin voluntaria','Dokumentazioa borondatez aurkeztea jasotzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,4,'Registro de la documentacin voluntaria en el expediente','Dokumentazioa borondatez aurkeztea espedientean erregistratzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,5,'Recepcin de modificacin de datos RERA','AAEE datuen aldaketa jasotzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,5,'Registro en el expediente de la modificacin','Aldaketa espedientean erregistratzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,6,'Recepcin de solicitud de baja de expediente','Espedienteari baja emateko eskaera jasotzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (2,6,'Registro en el expediente de la baja','Baja emateko espedientean erregistratzea','E');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (1,8,'Cierre del expediente','Espedientea ixtea','S');
Insert into AB03B18T00 (ID_018,ID_017_FASE,DESC_ES_018,DESC_EU_018,ENT_SAL_018) values (3,6,'Apertura del expediente en Mis Gestiones','Espedientea irekitzea Nire Kudeaketak atalean','S');
REM INSERTING into AB03B.AB03B21T00
SET DEFINE OFF;
Insert into AB03B.AB03B21T00 (ID_021,NOMBRE_021) values ('1','Justificante de inscripcin');
Insert into AB03B.AB03B21T00 (ID_021,NOMBRE_021) values ('2','Requerimiento de Subsanacion');
REM INSERTING into AB03B.AB03B22T00
SET DEFINE OFF;
Insert into AB03B.AB03B22T00 (ID_022,DESC_ES_022,DESC_EU_022) values ('3','Baja','Baja');
Insert into AB03B.AB03B22T00 (ID_022,DESC_ES_022,DESC_EU_022) values ('0','General','Orokorra');


REM INSERTING into AB03B.AB03B25T00
SET DEFINE OFF;
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('1','1','1','0','Solicitud de inscripcin en RERA','Inskribatzeko eskaera RERAn','1',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('2','6','1','3','Solicitud de baja en RERA','Baja emateko eskaera RERAn','1',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('4','4','1','0','Ficha de vigilancia de la salud','Ficha de vigilancia de la salud_eu','15',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('5','4','1','0','Aportacin voluntaria de documentos','Dokumentazioa borondatez aurkeztea','1',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('3','1','1','0','Ficha de vigilancia de la salud','Osasunaren zaintza-fitxa','15','4');
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('6','2','3','0','Ficha de vigilancia de la salud','Osasunaren zaintza-fitxa','15','4');
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('7','2','3','0','Subsanacin','Zuzenketa','1',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('8','1','1','0','Otros','Besteak','10',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('9','2','3','0','Otros','Besteak','10',null);
Insert into AB03B.AB03B25T00 (ID_025,ID_017_FASE,ID_018_TRAMITE,ID_022_TIPO_PLAN,DESC_ES_025,DESC_EU_025,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI) values ('10','4','1','0','Otros','Besteak','10',null);


REM INSERTING into AB03B.AB03B27T00
SET DEFINE OFF;
Insert into AB03B.AB03B27T00 (ID_027,ID_017_FASE,ID_018_TRAMITE,DESC_ES_027,DESC_EU_027,ID_021_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_022_TIPO_PLAN) values ('1','3','1','Justificante de Inscripcin','Inskripzio-egiaztagiria','1','4',null,null);
Insert into AB03B.AB03B27T00 (ID_027,ID_017_FASE,ID_018_TRAMITE,DESC_ES_027,DESC_EU_027,ID_021_PLANTILLA,ID_007_TP_DOC_DOKUSI,ID_007_ST_DOC_DOKUSI,ID_022_TIPO_PLAN) values ('4','2','1','Requerimiento de subsanacin','Zuzentzeko Errekerimendua','2','7',null,null);

REM INSERTING into AB03B.AB03B48T00
SET DEFINE OFF;
Insert into AB03B.AB03B48T00 (ID_048,DESC_ES_048,DESC_EU_048) values ('1','Delegacin Territorial','Lurralde Ordezkaritza');
Insert into AB03B.AB03B48T00 (ID_048,DESC_ES_048,DESC_EU_048) values ('2','Osalan','Osalan');
Insert into AB03B.AB03B48T00 (ID_048,DESC_ES_048,DESC_EU_048) values ('4','Direccin de trabajo','Lan Zuzendaritza');


REM INSERTING into AB03B.AB03B49T00
SET DEFINE OFF;
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('1','01','Samaniego','2','2','','01008','059','945017030','945017031','Delegacin territorial De lava','Arabako lurralde ordezkaritza','1','1','trabajoaraba@euskadi.eus','01');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('2','01','Jos Atxotegi','1','','','01009','059','945016800','945016801','Centro Territorial de Araba','Arabako lurralde zentroa','2','0','osalancatga@euskadi.eus','01');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('3','48','Gran Va','85','','','48011','020','944031216','944031212','Delegacin territorial de Bizkaia','Bizkaiko lurralde ordezkaritza','1','0','trabajobizkaia@euskadi.eus','48');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('4','20','Intxaurrondo','70','2','','20015','069','943023224','943023201','Delegacin territorial de Gipuzkoa','Gipuzkoako lurralde ordezkaritza','1','0','trabajogipuzkoa@euskadi.eus','20');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('5','20','Maldatxo bidea','s/n','','','20012','069','943023262','943023251','Centro Territorial de Gipuzkoa','Gipuzkoako lurralde zentroa','2','0','osalancatdo@euskadi.eus','20');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('6','48','Camino de la Dinamita','s/n(Monte Basatxu)','','','48903','013','944032179','94 032107','Centro Territorial de Bizkaia','Bizkaiko lurralde zentroa','2','0','osalancatba@euskadi.eus','48');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('7','48','Camino de la Dinamita','s/n(Monte Basatxu)','','','48001','013','944032190','','Osalan Servicios Centrales','Osalan zerbitzu orokorrak','2','1','','699');
Insert into AB03B49T00 (ID_049,TERRITORIO_049,CALLE_049,NUMERO_049,PISO_049,LETRA_049,COD_POSTAL_049,MUNICIPIO_049,TELEFONO_049,FAX_049,DESC_ES_049,DESC_EU_049,ID_048_ORG,REG_MANUAL_049,EMAIL_049,ID_PERFIL_049) values ('8','01','Donostia - San Sebastian','1','','','01010','059','945019317','945019415','Direccin de Trabajo y Seguridad Social','Laneko eta Gizarte Segurantzako Zuzendaritza','4','1','trabajo@euskadi.eus','99');

REM INSERTING into AB03B.AB03B53T00
SET DEFINE OFF;
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('1','Fachada','Fatxada','S','F');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('2','Cubierta','Estalkia','S','C');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('3','Tubera','Hodia','S','T');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('4','Bajante','Zorrotena','S','B');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('5','Canaln','Erretena','S','Cn');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('6','Chimenea','Tximinia','S','Ch');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('7','Depsito','Biltegia','S','D');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('8','Jardineras','Jardinerak','S','J');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('9','Residuo','Hondakinak','S','R');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('10','Marquesina','Markesinak','S','M');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('11','Varios','Bestelakoak','S','X');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('12','Escombros','Obra-hondakinak','S','E');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('13','Calderas','Galdarak','S','CC');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('14','Hornos','Labeak','S','H');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('15','Calorifugados','Bero-ihesekoak','S','CG');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('16','Proyectado','Proiektatua','S','PR');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('17','Pizarras','Arbelak','S','PI');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('18','Ferodos','Ferodoak','S','FE');
Insert into AB03B.AB03B53T00 (ID_053,DESC_ES_053,DESC_EU_053,ACTIVO_SN_053,COD_MCA_053) values ('19','Arqueta','Kutxatila','S','AR');

REM INSERTING into AB03B.AB03B55T00
SET DEFINE OFF;
Insert into AB03B.AB03B55T00 (ID_055,DESC_ES_055,DESC_EU_055,ACTIVO_SN_055) values ('1','Trabajos en general','Lanak, orokorrean','S');
Insert into AB03B.AB03B55T00 (ID_055,DESC_ES_055,DESC_EU_055,ACTIVO_SN_055) values ('2','Transportes','Garraioak','S');
Insert into AB03B.AB03B55T00 (ID_055,DESC_ES_055,DESC_EU_055,ACTIVO_SN_055) values ('3','Vertederos','Hondakindegiak','S');
Insert into AB03B.AB03B55T00 (ID_055,DESC_ES_055,DESC_EU_055,ACTIVO_SN_055) values ('4','Matenimiento de aguas','Uren mantentze-lanak','S');


INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'1',	'2',	'B01167147',	'S',	'01-00003',	'IMPERMEABILIZACIONES ISFATEC, S.L.',	'43',	'01/1010426/53',	'IMPERMEABILIZACIONES ISFATEC, S.L.',	'GUATEMALA', 	'17',	'BAJO',	null,	'01012',	'059',	null,	'01',	'945269361',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'2',	'2',	'A01007541',	'S',	'01-00005',	'LANBIDE EMPRESA CONSTRUCTORA, S.A.',	'9',	'01/0011397/75',	'LANBIDE EMPRESA CONSTRUCTORA, S.A.',	'AVDA. LOS OLMOS',	'4',	null,	null,	'01013',	'059',	null,	'01',	'945257433',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'3',	'2',	'A36360683',	'S',	'01-00006',	'CORTES, DERRIBOS Y EXCAVACIONES, S.A. (CORDEX)',	'45',	'36/1063380/86',	'CORTES, DERRIBOS Y EXCAVACIONES, S.A. (CORDEX)',	'A REIGOSA',	'43',	null,	null,	'36157',	'043',	null,	'36',	'986757272',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'4',	'2',	'B01254952',	'S',	'01-00008',	'CONTENEDORES ESCOR VITORIA, S.L.',	'43',	'01/1013662/88',	'CONTENEDORES ESCOR VITORIA, S.L.',	'ZORROLLETA',	'6',	'PAB.3',	'A',	'01015',	'059',	null,	'01',	'945290390',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'5',	'2',	'B32008179',	'S',	'01-00009',	'ESTEVEZ CONDUCTOS SUBTERRNEOS, S.L.',	'43',	'01/0019423/50',	'ESTEVEZ CONDUCTOS SUBTERRNEOS, S.L.',	'ZURRUPITIETA', 	'26',	'PAB.14',	null,	'01015',	'059',	null,	'01',	'945290333',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'6',	'2',	'B01267863',	'S',	'01-00010',	'CONSTRUCCIONES Y REHABILITACIONES IIGO',	'43',	'01/1014140/81',	'CONSTRUCCIONES Y REHABILITACIONES IIGO',	'KANPO KALE BERRIA',	'23-B',	null,	null,	'01001',	'059',	null,	'01',	'945271675',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'7',	'2',	'B01346097',	'S',	'01-00011',	'JIN MAO, S.L.',	'43',	'01/1032259/61',	'JIN MAO, S.L.',	'BRUNO VILLARREAL',	'7',	'BAJO',	null,	'01012',	'059',	null,	'01',	'945243750',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'8',	'2',	'B01298264',	'S',	'01-00012',	'SEINGA SEGURIDAD INTEGRAL GASTEIZ, S.L.',	'43',	'01/1018257/27',	'SEINGA SEGURIDAD INTEGRAL GASTEIZ, S.L.',	'BARRATXI',	'9',	'PAB.A',	null,	'01013',	'059',	null,	'01',	'945253018',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'9',	'2',	'B01301936',	'S',	'01-00013',	'ANAIAK APLISERVICIOS, S.L.',	'43',	'01/1018643/25',	'ANAIAK APLISERVICIOS, S.L.',	'AV. JUAN CARLOS I',	'4',	null,	null,	'01002',	'059',	null,	'01',	'945257773',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'10',	'2',	'B01312180',	'S',	'01-00014',	'PROTEC-LAN, INSTALACIN DE PRETECCIONES COLECTIVAS, S.L.',	'4329',	'01/1019822/40',	'PROTEC-LAN, INSTALACIN DE PRETECCIONES COLECTIVAS, S.L.',	'(POLGONO ANSOLETA) ARATZ',	'11-13',	null,	null,	'01006',	'059',	null,	'01',	'945155689',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'11',	'2',	'B01118702',	'S',	'01-00015',	'TALLER MECNICO PABLO LPEZ DE LACALLE, S.L.',	'314 ',	'01/0030589/61',	'TALLER MECNICO PABLO LPEZ DE LACALLE, S.L.',	'CAMPO DE LOS PALACIOS',	'26',	null,	null,	'01006',	'059',	null,	'01',	'945137792',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'12',	'2',	'A01039841',	'S',	'01-00016',	'AZCORRETA Y ZARATE, S.A.',	'4522',	'01/0024525/11',	'AZCORRETA Y ZARATE, S.A.',	'BARRATXI',	'29',	null,	null,	'01006',	'059',	null,	'01',	'945263820',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'13',	'2',	'B01438340',	'S',	'01-00017',	'CUBIERTAS OLI-CER, S.L.',	'43',	'01/1035941/57',	'CUBIERTAS OLI-CER, S.L.',	'URITIASOLO', 	'2',	'PAB.11',	null,	'01006',	'059',	null,	'01',	'945136740',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'14',	'2',	'B01284611',	'S',	'01-00018',	'ENVIANDE GASTEIZ, S.L.',	'43',	'01/1016469/82',	'ENVIANDE GASTEIZ, S.L.',	'JNDIZ',	'4',	'PAB.12',	'F',	'01015',	'059',	null,	'01',	'945292374',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'15',	'2',	'B01124502',	'S',	'01-00019',	'NUEVAS TCNICAS DE CONSTRUCCIN NUTECO, S.L.',	'4521',	'01/1000841/71',	'NUEVAS TCNICAS DE CONSTRUCCIN NUTECO, S.L.',	'VICENTE ALEIXANDRE',	'24',	'BAJO',	null,	'01003',	'059',	null,	'01',	'609888614',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'16',	'2',	'B01212323',	'S',	'01-00020',	'ENDU OBRAS, S.L.',	'43',	null,	'ENDU OBRAS, S.L.',	'(GALERAS ITACA) GENERAL LAVA',	'7',	null,	null,	'01005',	'059',	null,	'01',	'945147036',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'17',	'2',	'B32015604',	'S',	'01-00021',	'ESTVEZ CONTAINER ORENSANOS, S.L. ESCOR S.L.',	'3811',	'01/0024735/27',	'ESTVEZ CONTAINER ORENSANOS, S.L. ESCOR S.L.',	'AVENIDA GASTEIZ',	'84',	'BAJO',	null,	'01012',	'059',	null,	'01',	'945290390',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'18',	'2',	'B01303411',	'S',	'01-00022',	'DERRIBOS Y DESESCOMBROS, S.L.',	'43',	'01/1028760/54',	'DERRIBOS Y DESESCOMBROS, S.L.',	'PASEO DE LA ZUMAQUERA',	'78',	'BAJO',	null,	'01006',	'059',	null,	'01',	'945136554',	'609419067',	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'19',	'2',	'B01177609',	'S',	'01-00023',	'SABALAIN, S.L.',	'43',	'01/1016644/63',	'SABALAIN, S.L.',	'JUNDIZ',	'4',	'PAB.70',	null,	'01015',	'059',	null,	'01',	'945291565',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'20',	'2',	'B01355858',	'S',	'01-00024',	'CIG OBRA CIVIL, S.L.',	'4299',	'01/1024634/02',	'CIG OBRA CIVIL, S.L.',	'(POLGONO IND. JUNDIZ) UZBINA',	'4',	null,	null,	'01015',	'059',	null,	'01',	'945282566',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'21',	'2',	'B01040203',	'S',	'01-00025',	'CANALIZACIONES INDUSTRIALES DE GAS, S.L.',	'4221',	'01/0024600/86',	'CANALIZACIONES INDUSTRIALES DE GAS, S.L.',	'(POLGONO IND. JUNDIZ) UZBINA',	'4',	null,	null,	'01015',	'059',	null,	'01',	'945282566',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'22',	'2',	'B01378868',	'S',	'01-00026',	'KRONOS FONTANERA, REHABILITACIN Y CALEFACCIN, S.L.',	'43',	'01/1027554/12',	'KRONOS FONTANERA, REHABILITACIN Y CALEFACCIN, S.L.',	'ZUBIBARRI',	'5',	null,	null,	'01013',	'059',	null,	'01',	'945288888',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'23',	'2',	'A01019702',	'S',	'01-00027',	'OPACUA, S.A.',	'43',	'01/0019397/24',	'OPACUA, S.A.',	'DUQUE DE WELLINGTON',	'8',	'OFIC.1',	null,	'01011',	'059',	null,	'01',	'945283346',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'24',	'2',	'A01007889',	'S',	'01-00028',	'COMPAA PAVIMENTOS ALAVESES, S.A.',	'4299',	'01/0015441/45',	'COMPAA PAVIMENTOS ALAVESES, S.A.',	'HERACLIO FOURNIER',	'4B',	'1',	null,	'01006',	'059',	null,	'01',	'945138300',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'25',	'2',	'A01025865',	'S',	'01-00029',	'VITORIANA DE CONSTRUCCIN, S.A.',	'43',	'01/0020864/36',	'VITORIANA DE CONSTRUCCIN, S.A.',	'EL SALVADOR',	'6',	'BAJO',	null,	'01012',	'059',	null,	'01',	'945240950',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'26',	'2',	'A01031376',	'S',	'01-00030',	'CONSTRUCCIONES SEGUROLA, S.A.',	'4121',	'01/0022052/60',	'CONSTRUCCIONES SEGUROLA, S.A.',	'ZUBIBARRI',	'9',	'PAB.A',	'MD. 3',	'01013',	'059',	null,	'01',	'945284882',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'27',	'2',	'B01447127',	'S',	'01-00031',	'INSTALACIONES G. BORO, S.L.',	'43',	'01/1036775/18',	'INSTALACIONES G. BORO, S.L.',	'OREITIASOLO', 	'12',	'PAB.12',	null,	'01006',	'059',	null,	'01',	'945001649',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'28',	'2',	'B01497585',	'S',	'01-00032',	'R.T. TRANSLOAD, S.L.',	'43',	'01/1050109/63',	'R.T. TRANSLOAD, S.L.',	'BARRIO SAN MARTN',	'49',	null,	null,	'01479',	'010',	'10101000000238',	'01',	'610779515',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'29',	'2',	'A01036920',	'S',	'01-00033',	'OBRAS PBLICAS ONAINDIA, S.A.',	'43',	'01/0024225/02',	'OBRAS PBLICAS ONAINDIA, S.A.',	'ARRIURDINA',	'19',	null,	null,	'01015',	'059',	null,	'01',	'945266188',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'30',	'2',	'B01492180',	'S',	'01-00034',	'CONSTRUCCIONES EXCOGAN, S.A.',	'4222',	'01/1044136/07',	'CONSTRUCCIONES EXCOGAN, S.A.',	'LABASTIDA',	'20',	'6',	'DCHA.',	'01015',	'059',	null,	'01',	'635992542',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'31',	'2',	'A01050020',	'S',	'01-00035',	'CONSTRUCCIONES ARANA, S.A.',	'43',	'01/0026644/93',	'CONSTRUCCIONES ARANA, S.A.',	'ARTAPADURA',	'14',	'PAB.1',	null,	'01013',	'059',	null,	'01',	'945264622',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'32',	'2',	'A01008051',	'S',	'01-00036',	'YRRITU, S.A.',	'4211',	'01/0015766/79',	'YRRITU, S.A.',	'(POLGONO IND. JNDIZ) C/ MENDIGORRITXU',	'128',	null,	null,	'01015',	'059',	null,	'01',	'945243562',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'33',	'2',	'B26396325',	'S',	'01-00037',	'ALQUIREC 2012, S.L.',	'4121',	'01/1030366/11',	'ALQUIREC 2012, S.L.',	'POLGONO IND. IRUEBIDE',	'23',	'NAVE 5',	null,	'01320',	'043',	null,	'01',	'661207081',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'34',	'2',	'B01511955',	'S',	'01-00038',	'OBRAS HIDRULICAS HIDROARABA, S.L.',	'4399',	'01/1053033/77',	'OBRAS HIDRULICAS HIDROARABA, S.L.',	'TRATADO DE PARS',	'1',	'PAB.20',	null,	'01230',	'901',	null,	'01',	'945564290',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'35',	'2',	'B01314293',	'S',	'01-00039',	'SANFERIRU, S.L.',	'281 ',	'01/1020706/51',	'SANFERIRU, S.L.',	'OREITIASOLO',	'2',	'PAB.14',	null,	'01006',	'059',	null,	'01',	'945234139',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'36',	'2',	'B95452207',	'S',	'01-00040',	'AMIANTEC 3000, S.L.',	'4121',	'48/1094211/13',	'AMIANTEC 3000, S.L.',	'AXPE',	'26',	null,	null,	'01474',	'004',	null,	'01',	'944380279',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'37',	'2',	'F01484930',	'S',	'01-00041',	'LANCODEX, S. COOP. PEQUEA',	'4311',	'01/1042784/13',	'LANCODEX, S. COOP. PEQUEA',	'PORTAL DE GAMARRA',	'9',	'PAB.13',	null,	'01013',	'059',	null,	'01',	'945241686',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'38',	'2',	'F01506351',	'S',	'01-00042',	'TECMODI S. COOP. PEQUEA',	'43',	'01/1056103/43',	'TECMODI S. COOP. PEQUEA',	'PLAZA SENDA LANGARIKA',	'4',	'3',	'IZ',	'01200',	'051',	null,	'01',	'692194860',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'39',	'2',	'B01538834',	'S',	'01-00043',	'PROYECTALIA',	'43',	'01/1060937/27',	'PROYECTALIA',	'FLORIDA',	'19',	'1',	'IZ',	'01005',	'059',	null,	'01',	'616912569',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'40',	'2',	'B01234038',	'S',	'01-00044',	'SERVICIOS AGROFORESTALES EURIA, S.L.',	'81',	'01/1013487/10',	'SERVICIOS AGROFORESTALES EURIA, S.L.',	'ESKALMENDI',	'9',	'PAB.6',	null,	'01013',	'059',	null,	'01',	'608870979',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'41',	'2',	'B01530831',	'S',	'01-00045',	'NEW TALLERES SABARTE, S.L.',	'4321',	'01/1057551/36',	'NEW TALLERES SABARTE, S.L.',	'BARRATXI',	'20',	'BAJO',	null,	'01013',	'059',	null,	'01',	'945288190',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'42',	'2',	'B20473831', 	'S',	'20-00013', 	'CUBRENOR, S.L.',	'2511',	'20/100569463',	'CUBRENOR, S.L.',	'BIDEBITARTE  P.G.',	'8',	'ARLOA',	null,	'20014',	'903',	null,	'20',	'943333413',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'43',	'2',	'B20666467',	'S',	'20-00015', 	'CERRAMIENTOS IND. CUBERTEC',	'43',	'20/103091867',	'CERRAMIENTOS IND. CUBERTEC',	'ECIAGO P.G.',	null,	'PAR. 12',            	null,	'20120',	'040',	null,	'20',	'943553118',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'44',	'2',	'A20453437',	'S',	'20-00016', 	'REVESTIM. METAL. PLAMAR, S.A.L.',	'2433',	'20/100316253',	'REVESTIM. METAL. PLAMAR, S.A.L.',	'PG. 103 IRURZUN KALEA',	'25',	null,	null,	'20100',	'053',	null,	'20',	'943522104',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'45',	'2',	'A20029104',	'S',	'20-00017', 	'CONSTRUCC. ALTUNA Y URIA',	'41',	'20/000998751',	'CONSTRUCC. ALTUNA Y URIA',	'JOS ARTECHE  PZ',	'1',	'BEHEA(BAJO)',         	null,	'20730',	'018',	null,	'20',	'943157071',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'46',	'2',	'A20072302',	'S',	'20-00018', 	'CONSTRUCCIONES AMENABAR, S.A.',	'41',	'20/004147413',	'CONSTRUCCIONES AMENABAR, S.A.',	'NAFARROA KALEA',	'50',	null,	null,	'20800',	'079',	null,	'20',	'943831100',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'47',	'2',	'A20056974',	'S',	'20-00019', 	'EXCAV. Y TRANSPORT. BESAIDE, S.A',	'41',	'20/002562875',	'EXCAV. Y TRANSPORT. BESAIDE, S.A',	'BASABE P.G. EO',	'9',	'APT.149',            	null,	'20550',	'013',	null,	'20',	'943797831',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'48',	'2',	'B20494563', 	'S',	'20-00020', 	'CUBIERTAS GUTIERREZ, S. L.',	'43',	'20/100696977',	'CUBIERTAS GUTIERREZ, S. L.',	'PS. LARRATXO',	'52',	'4',	null,	'20017',	'069',	null,	'20',	'943404012',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'49',	'2',	'B20647608',	'S',	'20-00021', 	'GARMENDIA, TEJAS Y CUBIERTAS', 	'43',	'20/103014873',	'GARMENDIA, TEJAS Y CUBIERTAS', 	'PG. MAYUZ',	null,	'PAB.26',          	null,	'20240',	'076',	null,	'20',	'943161032',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'50',	'2',	'B20554606',	'S',	'20-00022', 	'CARRETILLAS Y MONTAJ. USABIAGA', 	'43',	'20/102822489',	'CARRETILLAS Y MONTAJ. USABIAGA', 	'ZALDIBIAKO ERREPIDEA',	'Z/G', 	null,	null,	'20240',	'076',	null,	'20',	'943164097',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'51',	'2',	'B20713566',	'S',	'20-00023', 	'TEJAS Y CUBIERTAS LOPETEGUI S.L. U.',	'43',	'20/103754804',	'TEJAS Y CUBIERTAS LOPETEGUI S.L. U.',	'ETXE  BERRI (OLARRAIN AUZOA)',	'22',	null,	null,	'20400',	'071',	null,	'20',	'943653605',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'52',	'2',	'B20184552',	'S',	'20-00024', 	'CONSTRUCC. ARABAOLAZA, S.A.',	'43',	'20/002861050',	'CONSTRUCC. ARABAOLAZA, S.A.',	'BORROKAZELAIETA BIDEA',	'18',	null,	null,	'20180',	'063',	null,	'20',	'943401365',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'53',	'2',	'B20472700', 	'S',	'20-00025', 	'TEJAS Y CUBIERTAS BIKUA, S.L.',	'43',	'20/006061545',	'TEJAS Y CUBIERTAS BIKUA, S.L.',	'KAROBIETA AUZOA',	'33A',	'1',	null,	'20120',	'040',	null,	'20',	'943331138',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'54',	'2',	'B09311531', 	'S',	'20-00026', 	'MONTAJES VILLAR, S.L.',	'43',	'09/100932848',	'MONTAJES VILLAR, S.L.',	'CONDADO DE TREVIO',	'40',	'6',	null,	'09200',	'219',	null,	'09',	'947313759',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'55',	'2',	'A20080453',	'S',	'20-00027', 	'SICESAL, S.A.',	'2511',	'20/004327871',	'SICESAL, S.A.',	'PROMAUTZAR KALEA',	'37',	null,	null,	'20300',	'045',	null,	'20',	'943631932',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'56',	'2',	'B20762530', 	'S',	'20-00028', 	'PROTECCIONES SECURIRED, S.L.',	'4321',	'20/104173217',	'PROTECCIONES SECURIRED, S.L.',	'PASAJES S. PEDRO ETORBIDEA',	'13',	'3',	'BUL.9',	'20017',	'069',	null,	'20',	'943393693',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'57',	'2',	'F20573648',	'S',	'20-00029', 	'BRUDER ZUGARRAMURDI, S. COOP.',	'43',	'20/104031454',	'BRUDER ZUGARRAMURDI, S. COOP.',	'EUSKADI ETORBIDEA',	'53',	'3',	null,	'20110',	'064',	null,	'20',	'943394652',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'58',	'2',	'B20226809', 	'S',	'20-00030', 	'MARTIN IRIGOYEN, S.L.',	'41',	'20/002006238',	'MARTIN IRIGOYEN, S.L.',	'ERRIBERA KALEA',	'1',	'BEHEA (BAJO)',           	null,	'20750',	'081',	null,	'20',	'943860375',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'59',	'2',	'A20111498', 	'S',	'20-00031', 	'TECNICA Y MONTAJES LASARTE, S.A',	'43',	'20/004651207',	'TECNICA Y MONTAJES LASARTE, S.A',	'FERNANDO MUGICA (PG. BELARTZA)',	'12',	null,	null,	'20018',	'069',	null,	'20',	'943363747',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'60',	'1',	'72457652Q',	'S',	'20-00032', 	'IKER TOBAR GURRUTXAGA',	'41',	null,	'IKER TOBAR GURRUTXAGA',	'SAN JUAN',	'91',	null,	null,	'20260',	'005',	null,	'20',	'943650499',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'61',	'2',	'B20190674',	'S',	'20-00033', 	'CONSTRUC. PEDRO IPARRAGIRRE, S.L',	'41',	'20/001073321',	'CONSTRUC. PEDRO IPARRAGIRRE, S.L',	'KALE NAGUSIA',	'48',	'BJ',       	null,	'20213',	'043',	null,	'20',	'943188008',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'62',	'2',	'B20435251', 	'S',	'20-00034', 	'EFZ, S.L.',	'43',	'20/005372744',	'EFZ, S.L.',	' ZUBIERREKA P.G.',	'49',	null,	null,	'20210',	'049',	null,	'20',	'943888659',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'63',	'1',	'72421463Y', 	'S',	'20-00035', 	'J.M. EIZAGIRRE MARTIJA',	'4121',	'20/100411031',	'J.M. EIZAGIRRE MARTIJA',	'BIDARE AZPIA',	'11',	null,	null,	'20750',	'081',	null,	'20',	'629423442',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'64',	'2',	'B20520466',	'S',	'20-00036', 	'ETXANAL, S.L.',	'43',	'20/005439432',	'ETXANAL, S.L.',	'ABENDAO KALEA', 	'6',	'LOCAL D',                     	null,	'20800',	'079',	null,	'20',	'943832961',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'65',	'2',	'A20036695', 	'S',	'20-00037', 	'VASCONTAINER, S.A.',	'41',	'20/003184988',	'VASCONTAINER, S.A.',	'PORTUETXE',	'18',	'BAJO',	null,	'20018',	'069',	null,	'20',	'902316677',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'66',	'2',	'B20797676', 	'S',	'20-00038', 	'URBANIZACIONES GIKOA, S.L.',	'4121',	'20/104565156',	'URBANIZACIONES GIKOA, S.L.',	'ESKALANTEGI', 	'12',	'BAJO',	null,	'20017',	'069',	null,	'20',	'943344855',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'67',	'2',	'A20135935',	'S',	'20-00039', 	'CONSTRUCCIONES DUMBOA, S.A.',	'4121',	'20/000477485',	'CONSTRUCCIONES DUMBOA, S.A.',	'GASKOINEN',	'2',	'2',	null,	'20280',	'036',	null,	'20',	'943643211',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'68',	'2',	'B20539300', 	'S',	'20-00040', 	'RECICLAJES Y DEMOLICIONES DEL NORTE, S.L.',	'43',	'20/103437229',	'RECICLAJES Y DEMOLICIONES DEL NORTE, S.L.',	'ZUBIONDO',	'14',	null,	null,	'20014',	'069',	null,	'20',	'943465093',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'69',	'2',	'B20754453', 	'S',	'20-00041', 	'LURKIDE HONDALANAK, S. L.',	'43',	'20/104114310',	'LURKIDE HONDALANAK, S. L.',	'LOYOLAKO IGACIO HIRIBIDEA',	'3',	'BEHEA (BAJO)',	null,	'20730',	'018',	null,	'20',	'943150305',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'70',	'2',	'B20680013', 	'S',	'20-00042', 	'EXCAVACIONES IMANOL LASA, S.L.',	'43',	'20/103282029',	'EXCAVACIONES IMANOL LASA, S.L.',	'PORTUETXE',	'37',	'3',	null,	'20018',	'069',	null,	'20',	'943444281',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'71',	'2',	'E20495560', 	'S',	'20-00043', 	'DOMARAL, C.B.',	'43',	'20/008492036',	'DOMARAL, C.B.',	'BERTSOLARI TXIRRITA',	'38',	null,	null,	'20017',	'069',	null,	'20',	'943392350',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'72',	'2',	'E20514469',	'S',	'20-00044', 	'JOMAR, C.B.',	'43',	'20/101026575',	'JOMAR, C.B.',	'ANTONIO PILDAIN',	'4',	null,	null,	'20100',	'053',	null,	'20',	'943523570',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'73',	'2',	'E20818852',	'S',	'20-00045',	'AITOR GOMEZ LOPEZ Y OTRO, C.B.',	'43',	'20/101123820',	'AITOR GOMEZ LOPEZ Y OTRO, C.B.',	'M JUNCAL LABANDIBAR',	'11',	null,	null,	'20305',	'045',	null,	'20',	'943311801',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'74',	'2',	'A20471462', 	'S',	'20-00046', 	'GIPUZKOAKO URAK-AGUAS DE GIPUZKOA, S.A.',	'3600',	'20/100422549',	'GIPUZKOAKO URAK-AGUAS DE GIPUZKOA, S.A.',	'EDIFICIO IBAETA C/ PORTUETXE',	'14',	'2',	null,	'20018',	'069',	null,	'20',	'636464644',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'75',	'2',	'B20775367',	'S',	'20-00047',	'MANEXENA, S.L.',	'41',	'20/104304973',	'MANEXENA, S.L.',	'C/EUSTASIO DE AMILIBIA',	'7',	null,	null,	'20011',	'069',	null,	'20',	'608770425',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'76',	'2',	'B20835757',	'S',	'20-00048', 	'CONSTRUCCIONES EGURKI ERAIKUNTZAK, S.L.',	'43',	'20/104933857',	'CONSTRUCCIONES EGURKI ERAIKUNTZAK, S.L.',	'CTRA. MRTIRES, KM 1',	null,	null,	'IZQ.',	'20720',	'017',	null,	'20',	'943261193',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'77',	'1',	'15886630R', 	'S',	'20-00049', 	'JUAN FLIX LETAMENDIA VERGARA',	'43',	'20/005589679',	'JUAN FLIX LETAMENDIA VERGARA',	'C/ SAN IGNACIO',	'2',	'2',	null,	'20200',	'019',	null,	'20',	'943345151',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'78',	'2',	'B20806956', 	'S',	'20-00050', 	'ANCLAJES Y CIMIENTOS, S.L.',	'43',	'20/104635076',	'ANCLAJES Y CIMIENTOS, S.L.',	'EDIFICIO OFICINAS MAMUT',	null,	'5',	'DCHA, OF.5',	'20180',	'063',	null,	'20',	'943513376',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'79',	'2',	'A31106875', 	'S',	'20-00051', 	'ARKAITZA, S.A.',	'41',	'20/004270176',	'ARKAITZA, S.A.',	'HAMARRETXETA',	'4',	'BAJO',	null,	'20110',	'064',	'12006400000018',	'20',	'659773225',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'80',	'2',	'B20658431', 	'S',	'20-00052', 	'OIARZABAL ANAIAK BERRIKUNTZAK, S.L.',	'41',	'20/102976477',	'OIARZABAL ANAIAK BERRIKUNTZAK, S.L.',	'C/ MIGUEL ZABALETA',	'33',	'BAJO',      	null,	'20100',	'067',	null,	'20',	'943449612',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'81',	'2',	'B20868089',	'S',	'20-00053',	'MONTAJES RENTERIA, S.L.',	'41',	'20/105301649',	'MONTAJES RENTERIA, S.L.',	'C/ BOLUETA',	'2',	'1',	'DCHA.',	'20305',	'045',	null,	'20',	'943639663',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'82',	'2',	'P2007200E', 	'S',	'20-00054', 	'AYUNTAMIENTO DE ERRENTERIA',	'8411',	'20/002665030',	'AYUNTAMIENTO DE ERRENTERIA',	'HERRIKO PLAZA',	'Z/G   ', 	null,	null,	'20100',	'067',	null,	'20',	'656309085',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'83',	'2',	'A20214011', 	'S',	'20-00055', 	'SERVICIOS DE TXINGUDI, S.A.', 	'41',	'20/102119544',	'SERVICIOS DE TXINGUDI, S.A.', 	'OLABERRIA',	'18',	null,	null,	'20303',	'045',	null,	'20',	'629510247',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'84',	'2',	'B20794434', 	'S',	'20-00056', 	'OBRAS DE REHABILITACIN NORCUS, S.L.',	'41',	'20/104536258',	'OBRAS DE REHABILITACIN NORCUS, S.L.',	'C/ TRIBUNAK', 	'12',	null,	null,	'20160',	'902',	null,	'20',	'630900279',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'85',	'2',	'F20897567', 	'S',	'20-00057', 	'JEL, S. COOP.',	'  ',	null, 	'JEL, S. COOP.',	'P LARRATXO',	'74',	'3',	'IZDA.',                    	'20017',	'069',	null,	'20',	'637157404',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'86',	'2',	'B20516746',	'S',	'20-00058', 	'IRUARKAITZ, S.L.',	'43',	'20/1012116/8',	'IRUARKAITZ, S.L.',	'BARRIO AGUINAGA, CASA GOIAGIN.',	null,	null,	null,	'20170',	'073',	null,	'20',	'943790900',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'87',	'2',	'B20875779',	'S',	'20-00059', 	'MONTAJES ALVAREZ Y JUANTORENA, S.L.',	'4122',	'20/1005132/5',	'MONTAJES ALVAREZ Y JUANTORENA, S.L.',	'PLAZA EMBAJADOR PEDRO ARISTEGUI', 	'2',	'3',	'B .', 	'20305',	'045',	null,	'20',	'943522104',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'88',	'2',	'P2005900B',	'S',	'20-00060', 	'AYUNTAMIENTO DE ARRASATE',	'8411',	'20/0003401/6',	'AYUNTAMIENTO DE ARRASATE',	'HERRIKO PLAZA',	'1',	null,	null,	'20500',	'055',	null,	'20',	'606680444',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'89',	'1',	'34083860E',	'S',	'20-00061', 	'JUAN M SALDAA LOPEZ',	'4522',	'20/1033322/4',	'JUAN M SALDAA LOPEZ',	'AVDA. ALCALDE JOS ELOSEGI',	'14',	'5',	'DCHA.',     	'20016',	'069',	null,	'20',	'637457400',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'90',	'2',	'B20903530',	'S',	'20-00062', 	'MONTAJES TXINGUDI, S.L.', 	'4122',	'20/1058460/6',	'MONTAJES TXINGUDI, S.L.', 	'C/ CURTIDORES',	'1BIS',	'2',	'B',	'20303',	'045',	null,	'20',	'943646025',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'91',	'2',	'B20832713',	'S',	'20-00063', 	'MONTAJES ARTEAN, S.L.',	'4122',	'20/1048933/4',	'MONTAJES ARTEAN, S.L.',	'C/ CURTIDORES',	'1BIS',	'2',	'B',	'20303',	'045',	null,	'20',	'943529104',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'92',	'2',	'B20682829',	'S',	'20-00064', 	'KARBER EDIFICACIN Y OBRA CIVIL, S.L.',	'41',	'20/1033297/2',	'KARBER EDIFICACIN Y OBRA CIVIL, S.L.',	'POLGONO TXIPLAU',	'12',	null,	null,	'20280',	'036',	null,	'20',	'943770706',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'93',	'2',	'B20559456',	'S',	'20-00065', 	'CONSTRUCCIONES NIGURKO, S.L.',	'41',	'20/1015685/6',	'CONSTRUCCIONES NIGURKO, S.L.',	'POLGONO INDUSTRIAL 110. C/ IPINTZA',	'39', 	null,	null,	'20100',	'053',	null,	'20',	'943701954',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'94',	'2',	'B20374286',	'S',	'20-00066', 	'CONSTRUCCIONES AMARAL DE SOUSA, S.L.',	'41',	'20/0056780/9',	'CONSTRUCCIONES AMARAL DE SOUSA, S.L.',	'POL. BASABE',	'20-A',	'PAB.4.',                  	null,	'20550',	'013',	null,	'20',	'943191952',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'95',	'2',	'B20409702',	'S',	'20-00067', 	'EXCAVACIONES BERGARETXE, S.L.',	'43',	'20/1000346/5',	'EXCAVACIONES BERGARETXE, S.L.',	'C/ERREBAL',	'16', 	null,	null,	'20600',	'030',	null,	'20',	'943191952',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'96',	'2',	'B20731154',	'S',	'20-00068', 	'REFORMAS ASKETA, S.L.',	'43',	'20/1039093/9',	'REFORMAS ASKETA, S.L.',	'OSIO KALEA', 	'7-C',	'2',	'ESK.',                    	'20820',	'029',	null,	'20',	'943326434',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'97',	'1',	'15236767A',	'S',	'20-00069', 	'VICENTE SERNA PEREZ',	'43',	'20/0059501/9',	'VICENTE SERNA PEREZ',	'JAIZKIBEL',	'41',	'1',	null,	'20301',	'045',	null,	'20',	'943633902',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'98',	'2',	'B20872255',	'S',	'20-00070', 	'ADEKUA SEGURIDAD INTEGRAL, S.L.',	'4399',	'20/1053657/1',	'ADEKUA SEGURIDAD INTEGRAL, S.L.',	'P GALICIA', 	'26',	'BAJO',      	null,	'20015',	'069',	null,	'20',	'618136786',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'99',	'2',	'B20823308',	'S',	'20-00071', 	'SECTOR VERTICAL, S.L.',	'4399',	'20/1051201/7',	'SECTOR VERTICAL, S.L.',	'AVDA. SALS', 	'21',	'BAJO',      	null,	'20304',	'045',	null,	'20',	'943292543',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'100',	'1',	'72431382N',	'S',	'20-00072', 	'OTAIZABAL ERAIKUNTZAK, S.L.',	'41',	'20/1037044/8',	'OTAIZABAL ERAIKUNTZAK, S.L.',	'LATXUNBE AUZOA',	'10',	'5',	'D',	'20120',	'040',	null,	'20',	'943740530',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'101',	'2',	'A20040390',	'S',	'20-00073', 	'ACUA, S.A.',	'4311',	'20/0030493/9',	'ACUA, S.A.',	'PASEO DE ULIA',	'62',	'BAJO',      	null,	'20003',	'069',	null,	'20',	'943631707',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'102',	'2',	'B20474656',	'S',	'20-00074', 	'SANTANA ITURGINTZA ETA INSTALAZIOAK',	'4322',	'20/0035170/1',	'SANTANA ITURGINTZA ETA INSTALAZIOAK',	'URASANDI',	'17',	'BAJO',      	null,	'20870',	'032',	null,	'20',	'943392658',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'103',	'2',	'B20760021',	'S',	'20-00075', 	'EUROMONTAJES GUIPUZCOA, S.L.',	'4399',	'20/1041563/4',	'EUROMONTAJES GUIPUZCOA, S.L.',	'C/ HILANDERAS',	'76',	null,	null,	'20303',	'045',	null,	'20',	'943161323',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'104',	'2',	'B20518791',	'S',	'20-00076', 	'GOPI RESTAURACIONES, S.L.',	'41',	'20/0054928/8',	'GOPI RESTAURACIONES, S.L.',	'P LARRATXO',	'45',	'BAJO',      	null,	'20017',	'069',	null,	'20',	'663861018',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'105',	'2',	'B20920302',	'S',	'20-00077', 	'DEMOLICIONES USABIAGA, S.L.', 	'4511',	'20/1060814/8',	'DEMOLICIONES USABIAGA, S.L.', 	'CARRETERA DE ZALDIBIA',	'Z/G', 	null,	null,	'20240',	'076',	null,	'20',	'943273365',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'106',	'2',	'E20966818',	'S',	'20-00078', 	'LAIN BLANCO GOIKOETXEA Y OTRO CB',	'4399',	'20/1011204/2',	'LAIN BLANCO GOIKOETXEA Y OTRO CB',	'AORGA TXIKI',	'22',	'2',	'B',	'20001',	'069',	null,	'20',	'943424121',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'107',	'2',	'B20675914',	'S',	'20-00079', 	'URBYCOLAN, S.L.',	'43',	'20/1032667/7',	'URBYCOLAN, S.L.',	'AORGA TXIKI',	'22',	'2',	'B',	'20120',	'040',	null,	'20',	'943641535',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'108',	'2',	'B20334728',	'S',	'20-00080', 	'CONSTRUCCIONES IPURU, S.L.',	'41',	'20/0058679/4',	'CONSTRUCCIONES IPURU, S.L.',	'PS. MUNDAIZ',	'10',	'2',	'OF.24',	'20012',	'069',	null,	'20',	'943623969',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'109',	'2',	'B20868030',	'S',	'20-00081', 	'GARBI-LANAK, S.L.',	'43',	'20/1053428/7',	'GARBI-LANAK, S.L.',	'C/ MONTE ALDABE',	'39',	null,	null,	'20301',	'045',	null,	'20',	'943579701',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'110',	'2',	'E20730396',	'S',	'20-00082', 	'AITOR ALZA ITURRIZA Y OTROS, C.B.',	'4121',	'20/1076149/9',	'AITOR ALZA ITURRIZA Y OTROS, C.B.',	'VIRGEN MILAGROSA', 	'3',	'2',	'C',	'20304',	'045',	null,	'20',	'943536885',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'111',	'2',	'B20969994',	'S',	'20-00083', 	'E.S.R. INSTALACIONES AMBIENTALES, S.L.',	'41',	'20/1067179/5',	'E.S.R. INSTALACIONES AMBIENTALES, S.L.',	'PASEO DE FRANCIA',	'3',	'1',	'IZDA.',	'20012',	'069',	null,	'20',	'943162247',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'112',	'1',	'15243001G',	'S',	'20-00084', 	'RAFAEL RAMOS SANCHEZ',	'4333',	'20/1019797/0',	'RAFAEL RAMOS SANCHEZ',	'LEKAENEA',	'3',	'4',	'DCHA.',	'20301',	'045',	null,	'20',	'943315157',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'113',	'2',	'B20802997',	'S',	'20-00085', 	'LAN BERTIKALAK, S.L.U.', 	'4399',	'20/1046457/8',	'LAN BERTIKALAK, S.L.U.', 	'CASA EZKURDIATEGI',	'Z/G', 	null, 	null,	'20211',	'015',	null,	'20',	'943467216',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'114',	'2',	'B20857009',	'S',	'20-00086', 	'RYDE OBRAS Y SERVICIOS, S.L.',	'43',	'20/1063098/4',	'RYDE OBRAS Y SERVICIOS, S.L.',	'C. PORTUETXE',	'83',	'2',	'OF.13',	'20018',	'069',	null,	'20',	'943314122',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'115',	'1',	'15981785M',	'S',	'20-00087', 	'ALBERTO DE BLAS GALARRETA',	'4399',	'20/1049907/4',	'ALBERTO DE BLAS GALARRETA',	'C/ MENDIGAIN',	'34',	'1',	'C',	'20014',	'069',	null,	'20',	'943833231',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'116',	'2',	'B20651857',	'S',	'20-00088',	'HOUSE PLUS CONSTRUCCION, REFORMAS Y Y DECORACIN, S.L.U.',	'41',	'20/1029788/0',	'HOUSE PLUS CONSTRUCCION, REFORMAS Y Y DECORACIN, S.L.U.',	'AVDA.ZARAUTZ',	'64',	'BAJO',	'TRASERA',	'20018',	'069',	null,	'20',	'943293525',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'117',	'2',	'B20939062',	'S',	'20-00089', 	'SINZATEC CANALIZACIONES, S.L.',	'4291',	'20/1065952/8',	'SINZATEC CANALIZACIONES, S.L.',	'ITURRIBIDE',	'8',	'BAJO',	'6',	'20800',	'079',	null,	'20',	'943653721',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'118',	'2',	'E20966081',	'S',	'20-00090', 	'AVELINO LOPEZ GARRIDO Y OTRO C.B.',	'43',	'20/1065617/4',	'AVELINO LOPEZ GARRIDO Y OTRO C.B.',	'ASTIGARRAGA',	'8',	'3',	'DCHA.',	'20100',	'067',	null,	'20',	'653838295',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'119',	'2',	'B20643557',	'S',	'20-00091', 	'EXCAVACIONES PERU, S.L.',	'429 ',	'20/1028517/9',	'EXCAVACIONES PERU, S.L.',	'PG. AREA A-11 Errotaldea',	'2',	'Nave 1',    	null,	'20270',	'010',	null,	'20',	'943551141',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'120',	'2',	'B20728119',	'S',	'20-00092', 	'OBRAS Y CONSTRUCCIONES ESYCO, S.L.',	'4122',	'20/1038748/4',	'OBRAS Y CONSTRUCCIONES ESYCO, S.L.',	'C/ LERTXUNA',	'15',	null,	null,	'20305',	'045',	null,	'20',	'943770185',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'121',	'2',	'P2004300F',	'S',	'20-00093', 	'AYUNTAMIENTO DE HERNANI',	'8411',	'20/0003270/2',	'AYUNTAMIENTO DE HERNANI',	'PLAZA GUDARIEN',	'1',	null,	null,	'20120',	'040',	null,	'20',	'627561813',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'122',	'2',	'B20850129',	'S',	'20-00094', 	'EGIA ANAIAK, S.L. (FONTANERA EGIA)',	'432 ',	'20/1076725/9',	'EGIA ANAIAK, S.L. (FONTANERA EGIA)',	'GIPUZKOA ETORBIDEA',	'39',	'BAJO',     	null,	'20500',	'055',	null,	'20',	'637558041',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'123',	'2',	'B75040063',	'S',	'20-00095', 	'IMPERMEABILIZACIONES EIZALAR, S.L.',	'4329',	'20/1078376/9',	'IMPERMEABILIZACIONES EIZALAR, S.L.',	'PZA UROLA',	'19',	null,	null,	'20750',	'081',	null,	'20',	'943653186',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'124',	'2',	'B75002352',	'S',	'20-00096', 	'CONTRATAS GOIBURU, S.L.',	'4322',	'20/1072811/5',	'CONTRATAS GOIBURU, S.L.',	'SAN JUAN',	'14',	'4',	'E',	'20130',	'072',	null,	'20',	'943615056',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'125',	'2',	'A75048397',	'S',	'20-00097', 	'CONSTRUCCIONES ECHAIDE, S.A.',	'42',	'20/1079598/5',	'CONSTRUCCIONES ECHAIDE, S.A.',	'AVDA. ARABA, BLOQUE',	'5',	'BAJO',	null,	'20400',	'071',	null,	'20',	'943522240',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'126',	'2',	'B20599015',	'S',	'20-00098', 	'OREKA PREGO, S.L.',	'439 ',	'20/1021674/3',	'OREKA PREGO, S.L.',	'C/ HENDAIA',	'11',	'BAJO',	'I',	'20301',	'045',	null,	'20',	'943520004',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'127',	'2',	'B20977229',	'S',	'20-00099', 	'OBRAS HIDRALICAS ORTEGA, S.L.L',	'43',	'20/1067356/3',	'OBRAS HIDRALICAS ORTEGA, S.L.L',	'POLGONO LANBARREN ii, C/ELBARRENA',	'2',	'NAVE 1A3.', 	null,	'20180',	'036',	null,	'20',	'943887640',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'128',	'2',	'B75029215',	'S',	'20-00100', 	'INSTALACIONES HIDRAULICAS URA, S.L.',	'43',	'20/1076133/8',	'INSTALACIONES HIDRAULICAS URA, S.L.',	'ESKALANTEGI',	'48',	'BAJO',	null,	'20017',	'069',	null,	'20',	'943779100',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'129',	'2',	'B20894309',	'S',	'20-00101', 	'CONSTRUCCIONES Y CONTRATAS ZEGAMA, S.L.',	'4339',	'20/1056819/6',	'CONSTRUCCIONES Y CONTRATAS ZEGAMA, S.L.',	'HERMANOS ASEGINOLAZA',	'3',	'BAJO',	'IZDA.',	'20215',	'025',	null,	'20',	'619661316',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'130',	'2',	'P2007900J',	'S',	'20-00102', 	'BERGARAKO UDALA /AYUNTAMIENTO DE BERGARA',	'8411',	'20/0003286/4',	'BERGARAKO UDALA /AYUNTAMIENTO DE BERGARA',	'PLAZA SAN MARTN DE AGUIRRE',	'1',	null,	null,	'20570',	'074',	null,	'20',	'634690842',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'131',	'2',	'B75052142',	'S',	'20-00103', 	'ROKOSA CERRAMIENTO METALICOS, SLU',	'4332',	'20/1084442/4',	'ROKOSA CERRAMIENTO METALICOS, SLU',	'ANAKA',	'42',	'4',	'D',	'20301',	'045',	null,	'20',	'943444281',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'132',	'2',	'B75079491',	'S',	'20-00104', 	'EXCAVACIONES IPAR LUR, SLU',	'43',	'20/1095927/8',	'EXCAVACIONES IPAR LUR, SLU',	'PORTUETXE',	'37',	'3',	'OF.8',	'20108',	'069',	null,	'20',	'943445208',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'133',	'2',	'B20675211',	'S',	'20-00105', 	'NAVEMETAL, S.L.',	'25',	'20/1032387/8',	'NAVEMETAL, S.L.',	'TROIA IBILBIDEA',	'20',	'PARC 7',	'LOCAL A-10',  	'20115',	'903',	null,	'20',	'943556986',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'134',	'2',	'B20669917',	'S',	'20-00106', 	'ZUMITZA ERAIKETAK, SL.',	'43',	'20/1031396/6',	'ZUMITZA ERAIKETAK, SL.',	'ZUMITZAGAIN',	'18A', 	null,	null,	'20170',	'073',	null,	'20',	'699472020',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'135',	'2',	'A20062451',	'S',	'20-00107', 	'SPANSET, S.A.',	'43',	'20/0039948/3',	'SPANSET, S.A.',	'POL. IND. 7  LOCALES 1 y 2',	null,	'BAJO',	'AGARAITZ',	'20150',	'075',	null,	'20',	'943692600',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'136',	'2',	'B20459459',	'S',	'20-00108', 	'MONTAJES FRONTERA, S.L.',	'43',	'20/1017667/0',	'MONTAJES FRONTERA, S.L.',	'C/ ARBESKO ERROTA',	'5',	null,	null,	'20304',	'045',	null,	'20',	'943619400',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'137',	'2',	'B75130633',	'S',	'20-00109', 	'EFZ EGITURAK, S.L.',	'43',	'20/1110108/0',	'EFZ EGITURAK, S.L.',	'POLGONO ZUBIERREKA', 	'49',	null,	null,	'20210',	'049',	null,	'20',	'943888659',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'138',	'2',	'B20862512',	'S',	'20-00110', 	'REHABILITACIONES Y OBRAS KUBER, S.L.',	'41',	'20/1052409/2',	'REHABILITACIONES Y OBRAS KUBER, S.L.',	'TELLERIARTE DISEMINADOS',	'16',	'PAB.6',           	null,	'20230',	'051',	null,	'20',	'943733573',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'139',	'2',	'B75139659',	'S',	'20-00111', 	'GRUPO GOIRITZA, S.L.',	'4121',	'20/1113101/9',	'GRUPO GOIRITZA, S.L.',	'DONOSTIA-ETORBIDEA',	'22H',	'PAB.8',               	null,	'20400',	'071',	null,	'20',	'902008943',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'140',	'2',	'B75150680',	'S',	'20-00112', 	'FONTANERA OLETA, S.L.', 	'4322',	'20/1116276/6',	'FONTANERA OLETA, S.L.', 	'CALZADA OLETA',	'19',	'BAJO',	'A',	'20017',	'069',	null,	'20',	'696455476',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'141',	'2',	'B20619722',	'S',	'20-00113', 	'CONSTRUCCIONES ZUBIEDER, S.L.',	'4329',	'20/1024628/8',	'CONSTRUCCIONES ZUBIEDER, S.L.',	'AVENIDA TOLOSA', 	'5',	'1',	null,	'20018',	'069',	null,	'20',	'943429320',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'142',	'2',	'B20604476',	'S',	'20-00114', 	'ARRIETA IGELTSERITZA, S.L.',	'4329',	'20/1029661/7',	'ARRIETA IGELTSERITZA, S.L.',	'PS UBARBURU',	'37',	'LOCAL 14',	null,	'20014',	'069',	null,	'20',	'943576086',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'143',	'2',	'B20890687',	'S',	'20-00115',	'CONSTRUCCIONES MOYUA, S.L.',	'41',	'20/1056243/7',	'CONSTRUCCIONES MOYUA, S.L.',	'PASEO ERROTABURU',	'1',	null,	null,	'20018',	'069',	null,	'20',	'943317600',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'144',	'2',	'A48055560',	'S',	'48-00005',	'KAEFER SERVICIOS INDUSTRIALES, S.A.',	'4329',	'48/42730/85',	'KAEFER SERVICIOS INDUSTRIALES, S.A.',	'RIBERA DE ERANDIO', 	'6',	null,	null,	'48950',	'902',	null,	'48',	'946710790',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'145',	'2',	'A48045371',	'S',	'48-00037',	'ATEFRISA',	'4329',	'48/35588/24',	'ATEFRISA',	'GRAN VA',	'53',	'6',	null,	'48011',	'020',	null,	'48',	'944423166',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'146',	'2',	'A48400360',	'S',	'48-00038',	'I.G.R.',	'4121',	'48/0090664/04',	'I.G.R.',	'C/OLABIDE',	'15-17',	'1',	'IZDA',   	'48600',	'085',	null,	'48',	'944643421',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'147',	'2',	'A48066856',	'S',	'48-00042',	'HIDRONOR',	'4311',	'48/005184178',	'HIDRONOR',	'TRINIDAD',	'9',	null,	null,	'48990',	'044',	'14804400000011',	'48',	'944911911',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'148',	'2',	'A48141881',	'S',	'48-00043',	'SISTEMAS TECNICOS AISLAMIENTOS',	'4329',	'48/7023643',	'SISTEMAS TECNICOS AISLAMIENTOS',	'TRAPAGA UGARTE P.G.',	null,	'H',	'8',	'48510',	'080',	null,	'48',	'944862281',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'149',	'2',	'A48691844',	'S',	'48-00044',	'PENINSULAR DE AISLAMIENTOS',	'4329',	'48/101444174',	'PENINSULAR DE AISLAMIENTOS',	'LAS MERCEDES',	'25',	'3',	'DPTO.3',   	'48930',	'044',	null,	'48',	'944851515',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'150',	'2',	'B81179897',	'S',	'48-00046',	'DESGUACES Y RECUPERACIONES LEZAMA',	'4677',	null,	'DESGUACES Y RECUPERACIONES LEZAMA',	'ATXUKARRO',	null,	'PAB 12',	null,   	'48480',	'011',	null,	'48',	'946713144',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'151',	'2',	'B48140818',	'S',	'48-00047',	'CONSTRUCCIONES PEREZ SANTOS HNOS.',	'4121',	'48/07046780',	'CONSTRUCCIONES PEREZ SANTOS HNOS.',	'SERANTES',	'5',	null,	null,	'48002',	'020',	null,	'48',	'944440497',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'152',	'2',	'A48061147',	'S',	'48-00048',	'INKARA, S.A.',	'4121',	'48/004765260',	'INKARA, S.A.',	'VIRGEN DE BEGOA',	'20',	null,	null, 	'48006',	'020',	null,	'48',	'944123599',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'153',	'2',	'B48750863',	'S',	'48-00050',	'PROM. CONST. ANGEL LAGUNA PILAR',	'4331',	'48/103113281',	'PROM. CONST. ANGEL LAGUNA PILAR',	'STA. MARINA',	'15',	null,	null, 	'48450',	'029',	null,	'48',	'944263374',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'154',	'2',	'A48161087',	'S',	'48-00051',	'EXCAVACIONES BARANDA',	null,	'48/7359911',	'EXCAVACIONES BARANDA',	'EL CAMPILLO P.G.',	'10',	null,	null, 	'48500',	'002',	'14800200000077',	'48',	'946361703',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'155',	'2',	'A48143762',	'S',	'48-00052',	'MONPORSA',	null,	'48/7061332',	'MONPORSA',	'SOTERA DE LA MIER',	'8',	'2',	null,   	'48920',	'078',	null,	'48',	'944955368',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'156',	'2',	'B48791768',	'S',	'48-00053',	'CUBILSA',	'4121',	null,	'CUBILSA',	'UGALDEGUREN P.G.',	'1',	'PAB.18',	null,   	'48170',	'905',	null,	'48',	'944545162',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'157',	'2',	'B95158184',	'S',	'48-00054',	'MONTAJES Y DESMONTAJES DE TEJADOS',	null,	null,	'MONTAJES Y DESMONTAJES DE TEJADOS',	'AMESTI',	'6',	null,	null,	'48990',	'044',	null,	'48',	null,	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'158',	'2',	'B95179297',	'S',	'48-00055',	'EGGLESTAN',	'2433',	null,	'EGGLESTAN',	'BILBAO ETORBIDEA',	null, 	null,	null,	'48530',	'083',	null,	'48',	'944990300',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'159',	'2',	'A95234811',	'S',	'48-00056',	'PROM. INMOB. ANGEL LAGUNA PILAR',	'4121',	'48/1066964/23',	'PROM. INMOB. ANGEL LAGUNA PILAR',	'TOMAS MEABE',	'12',	null,	null, 	'48450',	'029',	null,	'48',	'944263374',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'160',	'2',	'A20032298',	'S',	'48-00058',	'AGUAS DEL NORTE, S.A.',	'3600',	null,	'AGUAS DEL NORTE, S.A.',	'LEHEN.AGIRRE ETORBIDEA',	'29',	'6',	'EZ',   	'48014',	'020',	null,	'48',	'944765310',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'161',	'2',	'B48589600',	'S',	'48-00059',	'MINAYCU, S.L.',	'4321',	'48/1009459/39',	'MINAYCU, S.L.',	'MARCELINO GONZALEZ',	'41',	'SOLAIRUARTEA',	null,   	'48970',	'015',	null,	'48',	'944401469',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'162',	'2',	'B48805410',	'S',	'48-00061',	'BISTIBIETA, S.L.',	'5210',	'48/01057901/78',	'BISTIBIETA, S.L.',	'TRINIDAD',	'9',	null,	null,	'48990',	'044',	'14804400000011',	'48',	'944911911',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'163',	'2',	'A48212922',	'S',	'48-00062',	'RECUPERACIONES STEEL GALINDO, S.A.',	'4671',	'48/00759186',	'RECUPERACIONES STEEL GALINDO, S.A.',	'ERCILLA',	'18',	'2',	'EZK.',   	'48009',	'020',	null,	'48',	'944249199',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'164',	'2',	'B48147730',	'S',	'48-00063',	'ASFALTADOS Y CONSTRUCCIONES MORGA',	'4321',	'48/007197435',	'ASFALTADOS Y CONSTRUCCIONES MORGA',	'LA FLECHA P.G.',	null,	'PAB.1',	null,   	'48330',	'055',	null,	'48',	'946313975',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'165',	'2',	'B48731178',	'S',	'48-00064',	'ASTEKO, S.L.',	'4321',	'48/101247534',	'ASTEKO, S.L.',	'LOPEZ OSES',	'10',	null,	null, 	'48930',	'044',	null,	'48',	'944804632',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'166',	'2',	'A95341350',	'S',	'48-00065',	'CONSTRUCCIONES DEL NORTE DELIKAS, S.A.',	'4121',	'48/1078496/12',	'CONSTRUCCIONES DEL NORTE DELIKAS, S.A.',	'SANTA MARINA',	'44',	'BAJO',	null,   	'48450',	'029',	null,	'48',	'944406306',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'167',	'2',	'B48796064',	'S',	'48-00067',	'ITASA NAVAL, S.L.',	'3011',	'48/1024407/49',	'ITASA NAVAL, S.L.',	'AVDA. IPARRAGUIRRE',	'80',	null,	null,	'48940',	'054',	null,	'48',	'944315100',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'168',	'2',	'P4801900D',	'S',	'48-00069',	'AYUNTAMIENTO DE BASAURI',	'8411',	'48/1004651/81',	'AYUNTAMIENTO DE BASAURI',	'KAREAGA GOIKOA',	'52.', 	null,	null, 	'48510',	'015',	null,	'48',	'944666300',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'169',	'2',	'B48908115',	'S',	'48-00070',	'TRASINOR, S.L.',	'4942',	'48/1030915/58',	'TRASINOR, S.L.',	'FERRERAS',	'50',	'BAJO',	null,   	'48902',	'013',	null,	'48',	'944377236',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'170',	'2',	'A48112981',	'S',	'48-00072',	'DERRIBOS PETRALANDA, S.A.',	'5021',	'48/0066027/05',	'DERRIBOS PETRALANDA, S.A.',	'TXORIERRI ETORBIDEA',	'26-D.', 	null,	null,   	'48180',	'903',	null,	'48',	'944223735',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'171',	'2',	'B95458634',	'S',	'48-00074',	'VASCOSASTURIANA DEMOLICIONES Y DESGUACES, S.L.',	'4121',	'48/1094290/92',	'VASCOSASTURIANA DEMOLICIONES Y DESGUACES, S.L.',	'B BEKEA',	'7.', 	null,	null, 	'48960',	'036',	null,	'48',	'944363812',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'172',	'2',	'B95022158',	'S',	'48-00075',	'PROFESIONALES EN ALTURA, S.L.',	'4321',	'48/1043054/72',	'PROFESIONALES EN ALTURA, S.L.',	'POLGONO INDUSTRIAL MARTIARTU, C/2',	'28',	null,	null,	'48480',	'011',	null,	'48',	'946712556',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'173',	'2',	'A48169445',	'S',	'48-00076',	'AFESA MEDIO AMBIENTE, S.A.',	'4669',	'48/1020161/71',	'AFESA MEDIO AMBIENTE, S.A.',	'ED. SAN ISIDRO II, IDORSOLO KALEA',	'15.', 	null,	null,	'48160',	'901',	null,	'48',	'944239700',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'174',	'2',	'A48167373',	'S',	'48-00077',	'ZANJADORAS Y DESMONTES, S.A.',	'4511',	'48/0074602/44',	'ZANJADORAS Y DESMONTES, S.A.',	'POL. IND. EL CAMPILLO',	null,	'PAB.8',	null,   	'48500',	'002',	null,	'48',	'946369269',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'175',	'2',	'B95070405',	'S',	'48-00078',	'TRABAJOS VERTICALES AZKARAN, S.L.',	'4331',	'48/1049200/10',	'TRABAJOS VERTICALES AZKARAN, S.L.',	'C ZUBILETA (POL. IND. IBARRETA II)',	'25.',	'PAB.8',	null,	'48903',	'013',	null,	'48',	'944971324',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'176',	'2',	'E95529715',	'S',	'48-00079',	'ARI TRABAJOS VERTICALES',	'4121',	null,	'ARI TRABAJOS VERTICALES',	'URKIOLA',	'6',	'1B',	'DCHA.',   	'48160',	'901',	null,	'48',	'946404943',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'177',	'2',	'B95557385',	'S',	'48-00080',	'DESAMIANTADOS DESNOR, S.L.',	'4331',	'48/1105400/47',	'DESAMIANTADOS DESNOR, S.L.',	'C/ ZABALBIDE',	'73',	'ENTREPL.',	null,   	'48006',	'020',	null,	'48',	'944457574',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'178',	'2',	'A01038074',	'S',	'48-00081',	'EKONOR VERTEDERO DE BISTIETA',	'3831',	'48/1004945',	'EKONOR VERTEDERO DE BISTIETA',	'CRTRA. NACIONAL 634, PK. 95 KORTEDERRA',	'7.', 	null,	null, 	'48330',	'055',	null,	'48',	'945364055',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'179',	'2',	'A48162366',	'S',	'48-00082',	'TRANSPORTES AMEZAGA, S.A.',	null,	'48/0073710/25',	'TRANSPORTES AMEZAGA, S.A.',	'C/ ARRIAGA-SAKONI',	'14.', 	null,	null,  	'48950',	'902',	null,	'48',	'944531502',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'180',	'2',	'A48159149',	'S',	'48-00083',	'INDUMETAL RECYCLING, S.A.',	'3831',	'48/0073704/19',	'INDUMETAL RECYCLING, S.A.',	'CARRETERA DE LA CANTERA',	'11.', 	null,	null,  	'48950',	'902',	null,	'48',	'944711175',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'181',	'2',	'A48679096',	'S',	'48-00084',	'ANSAREO SANEAMIENTOS Y SERVICIOS, S.A.',	'4121',	'48/10855091/40',	'ANSAREO SANEAMIENTOS Y SERVICIOS, S.A.',	'POLGONO GRANADA M-1.',	null, 	null,	null,	'48530',	'083',	null,	'48',	'946354714',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'182',	'2',	'B95349072',	'S',	'48-00085',	'BILBAOVERTICAL, S.L.',	'4121',	'48/1078913/41',	'BILBAOVERTICAL, S.L.',	'CENTRO EMPRESARIAL LARRONDO ED.3',	null,	'NAVE 16',	null, 	'48180',	'903',	null,	'48',	'944000624',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'183',	'2',	'P4809100C',	'S',	'48-00086',	'AYUNTAMIENTO DE PORTUGALETE',	'8411',	'48/0005419/22',	'AYUNTAMIENTO DE PORTUGALETE',	'PLAZA DEL SOLAR',	'S/N.', 	null,	null,   	'48920',	'078',	null,	'48',	'944729200',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'184',	'1',	'78869930D',	'S',	'48-00087',	'ABEL VILLANO PORTILLO',	'4399',	'48/1075743/72',	'ABEL VILLANO PORTILLO',	'BARRIO OTIDES',	'9.', 	null,	null, 	'48891',	'022',	null,	'48',	'615709942',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'185',	'2',	'B95630679',	'S',	'48-00088',	'AMIANTO Y GESTIN, S.L.U.',	'4121',	'48/1116320/06',	'AMIANTO Y GESTIN, S.L.U.',	'C/ ISLAS CANARIAS',	'69',	'5',	null,   	'48015',	'020',	null,	'48',	'946414657',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'186',	'2',	'S5100023J',	'S',	'48-00089',	'OSAKIDETZA-HOSPITAL DE CRUCES, S.N.',	'851 ',	'48/1033588/15',	'OSAKIDETZA-HOSPITAL DE CRUCES, S.N.',	'PLAZA DE CRUCES',	'S/N.', 	null,	null,   	'48903',	'013',	null,	'48',	'946006042',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'187',	'2',	'B95121927',	'S',	'48-00090',	'ERMOYRCAL, S.L.',	'2433',	'48/1055357/56',	'ERMOYRCAL, S.L.',	'AVDA. GIPUZKOA',	'54',	'58',	null,   	'48260',	'034',	null,	'48',	'943173175',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'188',	'2',	'B48909170',	'S',	'48-00091',	'LOGISTICA RPIDA INTERNACIONAL, S.L.',	'4941',	'48/1045363/53',	'LOGISTICA RPIDA INTERNACIONAL, S.L.',	'POL. IND. IBARZAHARRA-MANZ.',	'9',	'PAB. 43',	null,   	'48510',	'080',	null,	'48',	'944953387',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'189',	'2',	'A95125662',	'S',	'48-00092',	'BETEARTE, S.A.',	'3811',	'48/1104519/39',	'BETEARTE, S.A.',	'CTRA.BI-3342, P.K. 38 (Alto de Areitio)',	'io)', 	null,	null,	'48269',	'058',	null,	'48',	'943170307',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'190',	'2',	'B48591424',	'S',	'48-00093',	'CONSTRUCCIONES LEGASKO, S.L.',	'4121',	'48/1008709/65',	'CONSTRUCCIONES LEGASKO, S.L.',	'ALDA.GREGORIO DE LA REVILLA',	'27',	'6',	null,   	'48010',	'020',	null,	'48',	'944355215',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'191',	'2',	'A48182703',	'S',	'48-00094',	'TRANSPORTES CON GRUAS PEA, S.A.',	'4941',	'48/0076810/21',	'TRANSPORTES CON GRUAS PEA, S.A.',	'CTRA. BILBAO-GALDAKAO, KM. 7,5.',	null, 	null,	null,	'48960',	'036',	null,	'48',	'944570548',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'192',	'2',	'B95640082',	'S',	'48-00095',	'RENOVA NORTE, S.L.',	'41  ',	'48/1121126/59',	'RENOVA NORTE, S.L.',	'PLAZA JOS RAMN AKETXE',	'3',	'LC-21',	null,   	'48940',	'054',	null,	'48',	'946000651',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'193',	'2',	'B48683817',	'S',	'48-00096',	'FONTANERIA MUSKIZ, S.L.',	'4322',	'48/1012380/50',	'FONTANERIA MUSKIZ, S.L.',	'AVDA. ANTONIO TRUEBA',	'19',	'BAJO.',	null,   	'48550',	'071',	null,	'48',	'946706028',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'194',	'2',	'A48152607',	'S',	'48-00097',	'S.A. DE MANTENIMIENTO SAMOS',	'4299',	'48/0072798/83',	'S.A. DE MANTENIMIENTO SAMOS',	'Etxatxu kalea',	'6',	null,	null,	'48100',	'069',	null,	'48',	'946745060',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'195',	'2',	'F95390126',	'S',	'48-00098',	'ASAKEN, S.COOP.',	'4121',	'48/1086026/73',	'ASAKEN, S.COOP.',	'C/Autonoma',	'45',	'2',	'DCHA.',   	'48012',	'020',	null,	'48',	'944102339',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'196',	'2',	'P9800003G',	'S',	'48-00099',	'BUSTURIKO UR PARTZUERGOA / CONSORCIO DE AGUAS DE BUSTURIALDEA',	'3600',	null,	'BUSTURIKO UR PARTZUERGOA / CONSORCIO DE AGUAS DE BUSTURIALDEA',	'PORTUONDO BIDE',	'7',	'BAXU',	null,   	'48395',	'076',	null,	'48',	'946870107',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'197',	'2',	'A48047377',	'S',	'48-00100',	'CONSTRUCCIONES FHIMASA, S.A.',	'4299',	'48/0039982/53',	'CONSTRUCCIONES FHIMASA, S.A.',	'QUINTANA (PLAZA DEL GAS)',	'5',	'EXTERIOR',	null,   	'48007',	'020',	null,	'48',	'944422012',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'198',	'2',	'B95176632',	'S',	'48-00101',	'STEULER TECNICA, S.L.',	'4333',	'48/1064508/89',	'STEULER TECNICA, S.L.',	'POLGONO UGALDEGUREN  III',	null,	'PARCELA 31',	'3',	'48170',	'905',	null,	'48',	'944525180',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'199',	'2',	'A48165427',	'S',	'48-00102',	'CONSTRUCCIONES IBARGOITIA, S.A.',	'4291',	'48/0074499/38',	'CONSTRUCCIONES IBARGOITIA, S.A.',	'LARRONDO KALEA (ELOTXELERRI)',	'11',	null,	null, 	'48180',	'903',	null,	'48',	'944249684',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'200',	'2',	'B95694576',	'S',	'48-00103',	'CIT VERTICAL, S.L.',	'4399',	'48/1144567/26',	'CIT VERTICAL, S.L.',	'C/ TROBIKA',	'4',	'3',	'IZDA.',   	'48100',	'069',	null,	'48',	'607401598',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'201',	'2',	'B95261830',	'S',	'48-00104',	'REHABILITACIN Y MANTENIMIENTO DE EDIFICIOS CLIMB, S.L.L.',	'4543',	'48/1069757/03',	'REHABILITACIN Y MANTENIMIENTO DE EDIFICIOS CLIMB, S.L.L.',	'POLGONO ERLETXE  PLATAFORMA I ',	null,	'NAVE 6',	null,   	'48960',	'036',	null,	'48',	'946009017',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'202',	'2',	'U95875498',	'S',	'48-00105',	'USSA A UTE',	'3600',	'48/1187295/74',	'USSA A UTE',	null, 	null,	null,	null,	null,	'020',	null,	'48',	'944466606',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'203',	'2',	'U95720199',	'S',	'48-00106',	'REDES CABB UTE',	'3600',	'48/1152371/70',	'REDES CABB UTE',	'PASEO CAMPO VOLANTIN',	'24',	'5',	'PTA. 3',   	'48007',	'020',	null,	'48',	'944466606',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'204',	'2',	'B48160030',	'S',	'48-00107',	'EXCAVACIONES GABIKA, S.L.',	'4311',	'48/0072492/68',	'EXCAVACIONES GABIKA, S.L.',	'C/ NAFARRO',	'1',	'3',	'B',   	'48340',	'003',	null,	'48',	'946733052',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'205',	'2',	'B95014700',	'S',	'48-00108',	'EXCAVACIONES AZKARRETA, S.A.',	'4311',	'48/1043883/28',	'EXCAVACIONES AZKARRETA, S.A.',	'C/ IBAIKUA',	'2',	'BAJO',	null,   	'48230',	'032',	null,	'48',	'946582838',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'206',	'2',	'B95135273',	'S',	'48-00109',	'UGAO INSTALACIONES, S.L.',	'4322',	'48/1055667/75',	'UGAO INSTALACIONES, S.L.',	'POL. USILA C/1',	null,	'PAB 11',	'MDULO 1',   	'48490',	'065',	null,	'48',	'946482671',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'207',	'2',	'A66141219',	'S',	'48-00110',	'AQUARBE, S.A.U.',	'3600',	'48/1156576/07',	'AQUARBE, S.A.U.',	'C / LEHENDAKARI AGUIRRE',	'29',	'6',	null,   	'48014',	'020',	null,	'48',	'944765310',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'208',	'2',	'B39627203',	'S',	'48-00111',	'CUMENORTE, D.L.',	'4121',	'48/1109051/12',	'CUMENORTE, D.L.',	'IBAIZABAL KALEA',	'1',	null,	null,	'48230',	'032',	null,	'48',	'946215677',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'209',	'2',	'B95654125',	'S',	'48-00112',	'TEJADOS Y FACHADAS SINGULARES',	'4399',	'48/1122512/87',	'TEJADOS Y FACHADAS SINGULARES',	'C/ BLAS DE OTERO',	'9-B',	'4',	'A',   	'48014',	'020',	null,	'48',	'635660333',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'210',	'2',	'A48441778',	'S',	'48-00113',	'TRANSPORTES ASOTRANS, S.A.',	'4941',	'48/0094957/29',	'TRANSPORTES ASOTRANS, S.A.',	'POLGONO INDUSTRIAL EL CAMPILLO',	null,	'PARC 32',	null,   	'48500',	'002',	null,	'48',	'946363710',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'211',	'2',	'B95664447',	'S',	'48-00114',	'EDIFNOR CONSTRUCCIONES Y CONTRATAS, S.L.',	'4121',	'48/1122560/38',	'EDIFNOR CONSTRUCCIONES Y CONTRATAS, S.L.',	'C/HURTADO DE AMEZAGA',	'20',	'2',	'D',   	'48008',	'020',	null,	'48',	'946071757',	'671072429',	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'212',	'2',	'B95708673',	'S',	'48-00115',	'VER-TECH PROYECTOS E INSTALACIONES, S.L.',	'4322',	'48/1149988/15',	'VER-TECH PROYECTOS E INSTALACIONES, S.L.',	'C/ PLENTZIA',	'3',	'4',	'IZDA',   	'48007',	'020',	null,	'48',	'667314243',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'213',	'2',	'B95138061',	'S',	'48-00116',	'HIJOS DE MANTEIGA, S.L.',	'4121',	'48/1055886/03',	'HIJOS DE MANTEIGA, S.L.',	'ESKINARRUAGA',	'16-18', 	null,	null,   	'48370',	'017',	null,	'48',	'946882768',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'214',	'2',	'B48637615',	'S',	'48-00117',	'RECIFEMETAL ESPAA, S.L.',	'4672',	'48/1116489/78',	'RECIFEMETAL ESPAA, S.L.',	'CAPITN MENDIZABAL',	'20',	'1',	null,   	'48980',	'082',	null,	'48',	'944625194',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'215',	'2',	'B95771663',	'S',	'48-00118',	'SOKA LANAK 21, S.L.',	'433 ',	'48/1163730/80',	'SOKA LANAK 21, S.L.',	'LEHENDAKARI AGIRRE',	'27',	null,	null, 	'48140',	'094',	null,	'48',	'695706180',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'216',	'1',	'78911791X',	'S',	'48-00119',	'JOSEBA GOMEZ DE SEGURA TOBALINA',	'4331',	'48/1081524/33',	'JOSEBA GOMEZ DE SEGURA TOBALINA',	'NARDIZ TAR JON',	'53',	'2',	null,   	'48370',	'017',	null,	'48',	'944655028',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'217',	'2',	'B95203022',	'S',	'48-00120',	'REFORMAS MAVER, S.L.',	'4321',	'48/1064042/11',	'REFORMAS MAVER, S.L.',	'ESTRADA DE MASUSTEGUI',	'7',	'LONJA',	null,   	'48002',	'020',	null,	'48',	'944275491',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'218',	'2',	'B95755013',	'S',	'48-00121',	'MAROCASTRO, S.L.',	'4121',	'48/1159832/62',	'MAROCASTRO, S.L.',	'SANTIAGO BROUARD',	'3',	'Lonja 1',	'D',   	'48012',	'020',	null,	'48',	'946756585',	'607601550',	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'219',	'2',	'A48045843',	'S',	'48-00122',	'CONSTRUCCIONES CASTELLANO, S.A',	'41  ',	'48/0037082/63',	'CONSTRUCCIONES CASTELLANO, S.A',	'PLAZA AMETZOLA',	'2',	'Entreplta',	'IZDA.',   	'48012',	'020',	null,	'48',	'944218231',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'220',	'2',	'B95455861',	'S',	'48-00123',	'CONSTRUCCIONES Y EXCAVA. AGUIRREZABAL, S.L.',	'4121',	'48/1094677/91',	'CONSTRUCCIONES Y EXCAVA. AGUIRREZABAL, S.L.',	'ARRILUZEA',	'13',	'BAJO',	null,   	'48200',	'027',	null,	'48',	'946200335',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'221',	'2',	'B95770020',	'S',	'48-00124',	'LAN GAINEKO, S.L.',	'4122',	'48/1171093/71',	'LAN GAINEKO, S.L.',	'ALDA.MAZARREDO',	'63',	'Bajo',	'DCHA.',   	'48009',	'020',	null,	'48',	'944230459',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'222',	'2',	'B95700241',	'S',	'48-00125',	'JAVIER BRAVO, S.L.',	'4322',	'48/1148951/45',	'JAVIER BRAVO, S.L.',	'GORDONIZ KALEA',	'84',	'LONJA',	null,   	'48002',	'020',	null,	'48',	'615751773',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'223',	'2',	'B95590972',	'S',	'48-00126',	'EWA CARS MATIENA, S.L.',	'3900',	'48/1110784/96',	'EWA CARS MATIENA, S.L.',	'POLIGONO MALLABARRENA',	'S/N',	null,	null,	null,	'058',	null,	'48',	'679960466',	null,	'ewacars@hotmail.com',	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'224',	'2',	'U95875498',	'S',	'48-00127',	'USSA A/17 UTE',	'3600',	'48/1187295/74',	'USSA A/17 UTE',	'PASEO CAMPO VOLANTN',	'24',	'5',	'3',	'48007',	'020',	null,	'48',	'944466606',	null,	null,	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'225',	'2',	'B48277768',	'S',	'48-00128',	'CONSTRUCCIONES EKIN, S.L.',	'4221',	'48/0087235/67',	'CONSTRUCCIONES EKIN, S.L.',	'IGORREKO INDUSTRIALDEA',	null,	'F9',	null,   	'48140',	'094',	null,	'48',	'946317257',	null,	null,	'946739525');
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'226',	'2',	'B95210837',	'S',	'48-00129',	'VERTER RECYCLING 2002, S.L.',	'3821',	'48/1067935/24',	'VERTER RECYCLING 2002, S.L.',	'CASERO KONDIA',	'S/N',	'F9',	null,   	'48250',	'095',	null,	'48',	'943173581',	null,	'verter@verter.es',	null);
INSERT INTO AB03B.AB03B47T00 (ID_047,TIPO_DOC_044,NIF_EMPRESA_047,ACTIVO_SN_047,NUM_RERA_047,RAZON_SOCIAL_047,CNAE_047,NSS_047,NOMBRE_EMPRESA_047,CALLE_047,NUM_CALLE_047,PISO_047,LETRA_047,CP_047,MUNICIPIO_047,LOCALIDAD_047,PROVINCIA_047,TELF1_047,TELF2_047,EMAIL_047,FAX_047) VALUES (	'227',	'2',	'A48108724',	'S',	'48-00130',	'URRE, S.A.',	'4299',	'48/0065341/95',	'URRE, S.A.',	'AULESTIA',	'22',	null,	null,	'48380',	'070',	null,	'48',	'946279037',	null,	'urre@urre.es',	null);


INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'1',	'1',	'01-00003',	'0',	TO_DATE('07/08/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'2',	'2',	'01-00005',	'0',	TO_DATE('09/03/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'3',	'3',	'01-00006',	'0',	TO_DATE('25/04/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'4',	'4',	'01-00008',	'0',	TO_DATE('17/01/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'5',	'5',	'01-00009',	'0',	TO_DATE('17/01/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'6',	'6',	'01-00010',	'0',	TO_DATE('03/05/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'7',	'7',	'01-00011',	'0',	TO_DATE('03/05/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'8',	'8',	'01-00012',	'0',	TO_DATE('03/03/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'9',	'9',	'01-00013',	'0',	TO_DATE('02/03/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'10',	'10',	'01-00014',	'0',	TO_DATE('09/07/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'11',	'11',	'01-00015',	'0',	TO_DATE('15/07/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'12',	'12',	'01-00016',	'0',	TO_DATE('24/07/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'13',	'13',	'01-00017',	'0',	TO_DATE('17/09/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'14',	'14',	'01-00018',	'0',	TO_DATE('23/09/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'15',	'15',	'01-00019',	'0',	TO_DATE('12/01/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'16',	'16',	'01-00020',	'0',	TO_DATE('12/03/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'17',	'17',	'01-00021',	'0',	TO_DATE('25/03/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'18',	'18',	'01-00022',	'0',	TO_DATE('06/09/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'19',	'19',	'01-00023',	'0',	TO_DATE('07/09/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'20',	'20',	'01-00024',	'0',	TO_DATE('27/09/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'21',	'21',	'01-00025',	'0',	TO_DATE('27/09/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'22',	'22',	'01-00026',	'0',	TO_DATE('18/02/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'23',	'23',	'01-00027',	'0',	TO_DATE('14/03/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'24',	'24',	'01-00028',	'0',	TO_DATE('06/04/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'25',	'25',	'01-00029',	'0',	TO_DATE('26/04/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'26',	'26',	'01-00030',	'0',	TO_DATE('01/07/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'27',	'27',	'01-00031',	'0',	TO_DATE('02/07/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'28',	'28',	'01-00032',	'0',	TO_DATE('18/10/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'29',	'29',	'01-00033',	'0',	TO_DATE('31/10/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'30',	'30',	'01-00034',	'0',	TO_DATE('14/01/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'31',	'31',	'01-00035',	'0',	TO_DATE('14/02/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'32',	'32',	'01-00036',	'0',	TO_DATE('05/03/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'33',	'33',	'01-00037',	'0',	TO_DATE('17/03/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'34',	'34',	'01-00038',	'0',	TO_DATE('27/06/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'35',	'35',	'01-00039',	'0',	TO_DATE('29/09/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'36',	'36',	'01-00040',	'0',	TO_DATE('26/11/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'37',	'37',	'01-00041',	'0',	TO_DATE('06/04/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'38',	'38',	'01-00042',	'0',	TO_DATE('16/05/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'39',	'39',	'01-00043',	'0',	TO_DATE('29/06/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'40',	'40',	'01-00044',	'0',	TO_DATE('07/03/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'41',	'41',	'01-00045',	'0',	TO_DATE('27/06/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'42',	'42',	'20-00013', 	'0',	TO_DATE('29/08/1997','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'43',	'43',	'20-00015', 	'0',	TO_DATE('03/11/1999','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'44',	'44',	'20-00016', 	'0',	TO_DATE('29/10/1999','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'45',	'45',	'20-00017', 	'0',	TO_DATE('02/05/2000','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'46',	'46',	'20-00018', 	'0',	TO_DATE('22/06/2000','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'47',	'47',	'20-00019', 	'0',	TO_DATE('09/02/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'48',	'48',	'20-00020', 	'0',	TO_DATE('18/02/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'49',	'49',	'20-00021', 	'0',	TO_DATE('17/05/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'50',	'50',	'20-00022', 	'0',	TO_DATE('24/09/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'51',	'51',	'20-00023', 	'0',	TO_DATE('22/10/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'52',	'52',	'20-00024', 	'0',	TO_DATE('31/10/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'53',	'53',	'20-00025', 	'0',	TO_DATE('28/01/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'54',	'54',	'20-00026', 	'0',	TO_DATE('15/02/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'55',	'55',	'20-00027', 	'0',	TO_DATE('02/05/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'56',	'56',	'20-00028', 	'0',	TO_DATE('14/05/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'57',	'57',	'20-00029', 	'0',	TO_DATE('29/08/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'58',	'58',	'20-00030', 	'0',	TO_DATE('03/10/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'59',	'59',	'20-00031', 	'0',	TO_DATE('25/10/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'60',	'60',	'20-00032', 	'0',	TO_DATE('21/11/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'61',	'61',	'20-00033', 	'0',	TO_DATE('14/03/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'62',	'62',	'20-00034', 	'0',	TO_DATE('17/06/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'63',	'63',	'20-00035', 	'0',	TO_DATE('18/07/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'64',	'64',	'20-00036', 	'0',	TO_DATE('01/12/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'65',	'65',	'20-00037', 	'0',	TO_DATE('19/12/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'66',	'66',	'20-00038', 	'0',	TO_DATE('14/01/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'67',	'67',	'20-00039', 	'0',	TO_DATE('27/01/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'68',	'68',	'20-00040', 	'0',	TO_DATE('23/02/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'69',	'69',	'20-00041', 	'0',	TO_DATE('28/05/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'70',	'70',	'20-00042', 	'0',	TO_DATE('03/06/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'71',	'71',	'20-00043', 	'0',	TO_DATE('24/06/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'72',	'72',	'20-00044', 	'0',	TO_DATE('24/06/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'73',	'73',	'20-00045',	'0',	TO_DATE('24/06/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'74',	'74',	'20-00046', 	'0',	TO_DATE('12/07/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'75',	'75',	'20-00047',	'0',	TO_DATE('14/07/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'76',	'76',	'20-00048', 	'0',	TO_DATE('11/10/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'77',	'77',	'20-00049', 	'0',	TO_DATE('24/11/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'78',	'78',	'20-00050', 	'0',	TO_DATE('21/12/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'79',	'79',	'20-00051', 	'0',	TO_DATE('03/03/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'80',	'80',	'20-00052', 	'0',	TO_DATE('18/04/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'81',	'81',	'20-00053',	'0',	TO_DATE('21/06/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'82',	'82',	'20-00054', 	'0',	TO_DATE('15/07/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'83',	'83',	'20-00055', 	'0',	TO_DATE('05/09/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'84',	'84',	'20-00056', 	'0',	TO_DATE('14/12/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'85',	'85',	'20-00057', 	'0',	TO_DATE('10/01/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'86',	'86',	'20-00058', 	'0',	TO_DATE('07/03/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'87',	'87',	'20-00059', 	'0',	TO_DATE('04/04/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'88',	'88',	'20-00060', 	'0',	TO_DATE('07/04/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'89',	'89',	'20-00061', 	'0',	TO_DATE('17/05/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'90',	'90',	'20-00062', 	'0',	TO_DATE('15/06/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'91',	'91',	'20-00063', 	'0',	TO_DATE('16/06/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'92',	'92',	'20-00064', 	'0',	TO_DATE('28/06/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'93',	'93',	'20-00065', 	'0',	TO_DATE('07/09/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'94',	'94',	'20-00066', 	'0',	TO_DATE('15/12/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'95',	'95',	'20-00067', 	'0',	TO_DATE('15/12/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'96',	'96',	'20-00068', 	'0',	TO_DATE('28/01/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'97',	'97',	'20-00069', 	'0',	TO_DATE('27/03/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'98',	'98',	'20-00070', 	'0',	TO_DATE('12/07/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'99',	'99',	'20-00071', 	'0',	TO_DATE('25/07/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'100',	'100',	'20-00072', 	'0',	TO_DATE('11/09/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'101',	'101',	'20-00073', 	'0',	TO_DATE('18/09/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'102',	'102',	'20-00074', 	'0',	TO_DATE('20/12/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'103',	'103',	'20-00075', 	'0',	TO_DATE('07/03/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'104',	'104',	'20-00076', 	'0',	TO_DATE('14/04/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'105',	'105',	'20-00077', 	'0',	TO_DATE('29/04/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'106',	'106',	'20-00078', 	'0',	TO_DATE('12/05/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'107',	'107',	'20-00079', 	'0',	TO_DATE('23/07/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'108',	'108',	'20-00080', 	'0',	TO_DATE('10/10/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'109',	'109',	'20-00081', 	'0',	TO_DATE('12/10/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'110',	'110',	'20-00082', 	'0',	TO_DATE('17/09/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'111',	'111',	'20-00083', 	'0',	TO_DATE('19/11/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'112',	'112',	'20-00084', 	'0',	TO_DATE('17/12/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'113',	'113',	'20-00085', 	'0',	TO_DATE('21/01/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'114',	'114',	'20-00086', 	'0',	TO_DATE('01/03/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'115',	'115',	'20-00087', 	'0',	TO_DATE('16/03/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'116',	'116',	'20-00088',	'0',	TO_DATE('04/05/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'117',	'117',	'20-00089', 	'0',	TO_DATE('17/08/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'118',	'118',	'20-00090', 	'0',	TO_DATE('17/08/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'119',	'119',	'20-00091', 	'0',	TO_DATE('17/09/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'120',	'120',	'20-00092', 	'0',	TO_DATE('26/01/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'121',	'121',	'20-00093', 	'0',	TO_DATE('16/03/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'122',	'122',	'20-00094', 	'0',	TO_DATE('13/07/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'123',	'123',	'20-00095', 	'0',	TO_DATE('14/07/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'124',	'124',	'20-00096', 	'0',	TO_DATE('28/07/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'125',	'125',	'20-00097', 	'0',	TO_DATE('14/02/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'126',	'126',	'20-00098', 	'0',	TO_DATE('24/02/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'127',	'127',	'20-00099', 	'0',	TO_DATE('01/06/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'128',	'128',	'20-00100', 	'0',	TO_DATE('19/07/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'129',	'129',	'20-00101', 	'0',	TO_DATE('27/07/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'130',	'130',	'20-00102', 	'0',	TO_DATE('23/10/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'131',	'131',	'20-00103', 	'0',	TO_DATE('13/02/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'132',	'132',	'20-00104', 	'0',	TO_DATE('01/03/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'133',	'133',	'20-00105', 	'0',	TO_DATE('05/08/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'134',	'134',	'20-00106', 	'0',	TO_DATE('05/08/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'135',	'135',	'20-00107', 	'0',	TO_DATE('09/01/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'136',	'136',	'20-00108', 	'0',	TO_DATE('04/12/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'137',	'137',	'20-00109', 	'0',	TO_DATE('14/04/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'138',	'138',	'20-00110', 	'0',	TO_DATE('16/07/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'139',	'139',	'20-00111', 	'0',	TO_DATE('13/06/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'140',	'140',	'20-00112', 	'0',	TO_DATE('09/01/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'141',	'141',	'20-00113', 	'0',	TO_DATE('28/03/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'142',	'142',	'20-00114', 	'0',	TO_DATE('04/04/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'143',	'143',	'20-00115',	'0',	TO_DATE('10/07/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'144',	'144',	'48-00005',	'0',	TO_DATE('22/09/1986','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'145',	'145',	'48-00037',	'0',	TO_DATE('22/03/1993','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'146',	'146',	'48-00038',	'0',	TO_DATE('12/06/1996','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'147',	'147',	'48-00042',	'0',	TO_DATE('29/12/1997','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'148',	'148',	'48-00043',	'0',	TO_DATE('09/09/1998','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'149',	'149',	'48-00044',	'0',	TO_DATE('10/08/1999','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'150',	'150',	'48-00046',	'0',	TO_DATE('23/01/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'151',	'151',	'48-00047',	'0',	TO_DATE('10/04/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'152',	'152',	'48-00048',	'0',	TO_DATE('21/05/2001','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'153',	'153',	'48-00050',	'0',	TO_DATE('18/02/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'154',	'154',	'48-00051',	'0',	TO_DATE('18/04/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'155',	'155',	'48-00052',	'0',	TO_DATE('05/06/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'156',	'156',	'48-00053',	'0',	TO_DATE('17/06/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'157',	'157',	'48-00054',	'0',	TO_DATE('03/07/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'158',	'158',	'48-00055',	'0',	TO_DATE('08/11/2002','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'159',	'159',	'48-00056',	'0',	TO_DATE('10/01/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'160',	'160',	'48-00058',	'0',	TO_DATE('30/04/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'161',	'161',	'48-00059',	'0',	TO_DATE('29/07/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'162',	'162',	'48-00061',	'0',	TO_DATE('18/08/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'163',	'163',	'48-00062',	'0',	TO_DATE('03/09/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'164',	'164',	'48-00063',	'0',	TO_DATE('18/11/2003','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'165',	'165',	'48-00064',	'0',	TO_DATE('11/03/2004','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'166',	'166',	'48-00065',	'0',	TO_DATE('25/01/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'167',	'167',	'48-00067',	'0',	TO_DATE('15/07/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'168',	'168',	'48-00069',	'0',	TO_DATE('12/12/2005','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'169',	'169',	'48-00070',	'0',	TO_DATE('12/05/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'170',	'170',	'48-00072',	'0',	TO_DATE('01/12/2006','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'171',	'171',	'48-00074',	'0',	TO_DATE('01/03/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'172',	'172',	'48-00075',	'0',	TO_DATE('17/07/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'173',	'173',	'48-00076',	'0',	TO_DATE('03/03/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'174',	'174',	'48-00077',	'0',	TO_DATE('15/05/2007','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'175',	'175',	'48-00078',	'0',	TO_DATE('23/09/2008','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'176',	'176',	'48-00079',	'0',	TO_DATE('22/01/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'177',	'177',	'48-00080',	'0',	TO_DATE('22/01/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'178',	'178',	'48-00081',	'0',	TO_DATE('07/09/2009','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'179',	'179',	'48-00082',	'0',	TO_DATE('02/11/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'180',	'180',	'48-00083',	'0',	TO_DATE('07/05/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'181',	'181',	'48-00084',	'0',	TO_DATE('30/06/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'182',	'182',	'48-00085',	'0',	TO_DATE('05/10/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'183',	'183',	'48-00086',	'0',	TO_DATE('13/10/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'184',	'184',	'48-00087',	'0',	TO_DATE('17/12/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'185',	'185',	'48-00088',	'0',	TO_DATE('27/12/2010','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'186',	'186',	'48-00089',	'0',	TO_DATE('11/02/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'187',	'187',	'48-00090',	'0',	TO_DATE('23/02/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'188',	'188',	'48-00091',	'0',	TO_DATE('25/05/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'189',	'189',	'48-00092',	'0',	TO_DATE('31/05/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'190',	'190',	'48-00093',	'0',	TO_DATE('06/06/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'191',	'191',	'48-00094',	'0',	TO_DATE('13/12/2011','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'192',	'192',	'48-00095',	'0',	TO_DATE('14/02/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'193',	'193',	'48-00096',	'0',	TO_DATE('20/02/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'194',	'194',	'48-00097',	'0',	TO_DATE('20/01/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'195',	'195',	'48-00098',	'0',	TO_DATE('21/09/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'196',	'196',	'48-00099',	'0',	TO_DATE('30/10/2012','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'197',	'197',	'48-00100',	'0',	TO_DATE('14/01/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'198',	'198',	'48-00101',	'0',	TO_DATE('16/01/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'199',	'199',	'48-00102',	'0',	TO_DATE('22/02/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'200',	'200',	'48-00103',	'0',	TO_DATE('16/07/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'201',	'201',	'48-00104',	'0',	TO_DATE('30/08/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'202',	'202',	'48-00105',	'0',	null);
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'203',	'203',	'48-00106',	'0',	TO_DATE('30/08/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'204',	'204',	'48-00107',	'0',	TO_DATE('07/10/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'205',	'205',	'48-00108',	'0',	TO_DATE('04/11/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'206',	'206',	'48-00109',	'0',	TO_DATE('27/11/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'207',	'207',	'48-00110',	'0',	TO_DATE('02/12/2013','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'208',	'208',	'48-00111',	'0',	TO_DATE('08/01/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'209',	'209',	'48-00112',	'0',	TO_DATE('11/09/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'210',	'210',	'48-00113',	'0',	TO_DATE('23/10/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'211',	'211',	'48-00114',	'0',	TO_DATE('20/11/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'212',	'212',	'48-00115',	'0',	TO_DATE('12/12/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'213',	'213',	'48-00116',	'0',	TO_DATE('12/12/2014','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'214',	'214',	'48-00117',	'0',	TO_DATE('16/01/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'215',	'215',	'48-00118',	'0',	TO_DATE('03/06/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'216',	'216',	'48-00119',	'0',	TO_DATE('03/06/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'217',	'217',	'48-00120',	'0',	TO_DATE('16/09/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'218',	'218',	'48-00121',	'0',	TO_DATE('25/11/2015','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'219',	'219',	'48-00122',	'0',	TO_DATE('04/02/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'220',	'220',	'48-00123',	'0',	TO_DATE('14/10/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'221',	'221',	'48-00124',	'0',	TO_DATE('15/12/2016','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'222',	'222',	'48-00125',	'0',	TO_DATE('21/03/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'223',	'223',	'48-00126',	'0',	TO_DATE('29/03/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'224',	'224',	'48-00127',	'0',	TO_DATE('08/04/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'225',	'225',	'48-00128',	'0',	TO_DATE('26/04/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'226',	'226',	'48-00129',	'0',	TO_DATE('19/09/2017','dd/MM/YYYY'));
INSERT INTO AB03B.AB03B31T00 (ID_031, ID_047_EMPRESA,NUM_RERA_031,ESTADO_031,F_CAMBIO_ESTADO_031) VALUES (	'227',	'227',	'48-00130',	'0',	TO_DATE('02/11/2017','dd/MM/YYYY'));
